/*------------------------------------------------------------------------------*
 * File Name: TreeEditor.h	 													*
 * Creation: TD, CPY															*
 * Purpose: OriginC Header for OTreeEditor DLL implemented control for			*
 *			XML based Tree editing												*
 * Copyright (c) Originlab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _TREEEDITOR_H_
#define _TREEEDITOR_H_

#include <Control.h>
#include <tree.h>

#pragma dll(OTreeEditor.dll)

/** #
*/
class TreeEditor
: public Control
{
public:
	TreeEditor();
	TreeEditor(Control& ctrl);
	TreeEditor(Window& wnd);
	
	BOOL Load(LPCSTR lpcszXMLFile);
	/**#
	Example:
		OTreeEditor	te = dlg.GetDlgItem(IDC_TREE_EDITOR);
		te.Save(GetAppPath() + "theme.xml");
	*/
	BOOL Save(LPCSTR lpcszFilename, BOOL bSelectedOnly=FALSE, BOOL bVisibleOnly=FALSE);
	
	BOOL Build(BOOL bBegin);
	
	int	AddItem(UINT nNodeType, LPCTSTR lpcszNodeLabel, LPCTSTR lpcsz=NULL, DWORD dwParam1=0L, UINT nNodeID = 0);
	BOOL SetValue(int nValue);
	BOOL SetValue(double fValue);
	BOOL SetValue(LPCSTR lpcszValue);
	
#if _OC_VER > 0x0703
	/**#
			Adding or replacing a treenode inside the editor
		Parameters:
			tr = a node to be added or to be used to replace an existing node
			bReplace = ture will replace or to add depending on nRowLocation and whether the node already existed, see Remarks.
			nRowLocation = if bReplace is false, or if it is negative, then ignore, otherwise to specified the location to replace
		Remark:
			For the case where bReplace is true but nRowLocation < 0, then this function will do the following
			1. If the node does not already existed, based on a case by case condition in the nature of the tree, the node is simply added to the end
			2. If the node already existed, then we will replace it with the new node
			For the case where bReplace is true and nRowLocation is also specified, the
			1. If the node does not already existed, we simply replace the specifed row with the new node
			2. If the node already existed and is at the same row as the specified row, then we also just replace it
			3. If the node already existed but is at a different node then the specified row, we will need to first replace the specified row, then remove the conflicting one
		//------------------------
			On return *parrLayerRows receives the indices of the rows containing the layer branches of the layers
			inside which adding (or replacement) happened.
	*/
	BOOL	Add(const TreeNode &tr, BOOL bReplace, vector<uint> *parrLayerRows = NULL);
	BOOL	Add(const TreeNode &tr, vector<uint> &vPlotTypes, vector<uint> *parrLayerRows = NULL);
	
	/**#
	*/
	BOOL	GetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	BOOL	SetTreeNode(TreeNode &tr, LONG nRow);
	
	/**#
	*/
	BOOL	BeginRowEdit(string &strGraphLayerName, string &strGraphGroupName, string &strWksPageName, string &strWksLayerName, vector<uint> &vnColDesignations, vector<string> &vstrColNames, int &nPlotType, DWORD &dwAuxTypeInfo, DWORD &dwLTPlotInfo, string &strColPattern);
	
	/**#
	*/
	BOOL	EndRowEdit();
	
	/**#
			Returns the information about the tree. The information depends on the type of the tree editor.
		Parameters:
			dwOptions = optional description of what kind of information is needed.
	*/
	DWORD	GetInfo(DWORD dwOptions = 0);
	
	/**#
	*/
	DWORD	GetRowInfo(int nRow, UINT &lParam, UINT &wParam);

	
#endif	// _OC_VER > 0x0703

	int GetSelectedRows(vector<uint> *parrRows = NULL, BOOL bExcludeBranchNodes = FALSE);

	//properties
	DWORD 		View;
	
	TreeNode	Root;

	// get the internal property object, to be used in EditorManager class
	DWORD		GetProperty(uint nRow);

#ifdef	ORIGIN_COM_SUPPORT
	/**#
	*/
	_VARIANT GetActiveXControl();
#endif //#ifdef	ORIGIN_COM_SUPPORT
};





#endif //!_TREEEDITOR_H_

