/*------------------------------------------------------------------------------*
 * File Name: AccessGraphObjectsTutorial.C										*
 * Creation: GJL 8/15/03														*
 * Purpose: Origin C file containing AccessGraphObjectsTutorial example.		*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h> // Includes most Origin C header files including NAG

/**
		Demonstrate accessing graph related internal Origin Objects. This function assumes
		that the project file AccessGraphObjectsTutorial.OPJ is currently open.
	Return:
		Returns TRUE on successful exit and FALSE on error.
*/
BOOL AccessGraphObjectsTutorial()
{
	GraphPage gp;                               // Declare GraphPage object
	GraphLayer gl;                              // Declare GraphLayer object
	Folder fld;                                 // Declare Folder object
	
	int iColor;
	
	// Note: The Project object is an instance of the Project class that is automatically available
	// to all Origin C functions
	
	// *** Use Project class RootFolder property to get root folder in Project Explorer ***
	fld = Project.RootFolder;                   // Get root folder
	if( !fld.IsValid() )                        // If not valid return error
		return FALSE;
	
	// *** Use Folder class Subfolders collection to get subfolder "Level 2B" ***
	fld = fld.Subfolders("Level 2B");           // Re-use Folder object to get subfolder
	if( !fld.IsValid() )                        // If not valid return error
		return FALSE;
	
	// *** Use Folder class Pages collection to get "Graph2B" and attach to GraphPage object ***
	gp = (GraphPage) fld.Pages("Graph2B");      // Cast PageBase object returned by Pages collection to GraphPage
	if( !gp.IsValid() )                         // If not valid return error
		return FALSE;
	
	// *** Use GraphPage class Layers collection to get GraphLayer ***
	gl = gp.Layers(0);                          // Get Layer 1 as GraphLayer object (use 0 based layer number)
	if( !gl.IsValid() )                         // If not valid return error
		return FALSE;
	
	// *** Use foreach command and DataPlots collection in GraphLayer class to loop on and set color ***
	// *** of all DataPlots in GraphLayer                                                            ***
	iColor = 0;                                 // Init to Black (0 based color index)  
	foreach( DataPlot dp in gl.DataPlots )      // Loop once for each DataPlot dp in GraphLayer gl
	{
		iColor++;                               // Increment to next color in 0 based color list
		                                        // (1=Red,2=Green,3=Blue,etc.)
		dp.SetColor( iColor, TRUE );            // Set color of current DataPlot 
	}

	return TRUE;                                // Done!
}