﻿var G, PSInstaller, PSU, e, errorMessage, psInstaller;
if ($["os"]["match"](/windows/i) == "Windows") {
    var userFolder = (Folder["myDocuments"]["fsName"]).toString()["replace"](/\\/g, "/");
    var userTempFolder = userFolder + "/OrangeBoxTemp";
    inputFolder = new Folder(userTempFolder);
    inputFolder["create"]()
} else {
    if ($["os"]["match"](/Macintosh/i) == "Macintosh") {
        var userFolder = (Folder["myDocuments"]["fsName"]);
        var userTempFolder = userFolder + "/OrangeBoxTemp";
        inputFolder = new Folder(userTempFolder);
        inputFolder["create"]()
    }
};
var G, PSInstaller, PSU, e, errorMessage, psInstaller;
G = {
    COMPANY: "Orange_Box",
    CONTACT_INFO: "http://graphicriver.net/user/orange_box",
    PRODUCT_NAME: "X-Free-IsometrIcon",
    PRODUCT_ID: "X-Free-IsometrIcon.extension",
    PRODUCT_VERSION: "1.0",
    MIN_VERSION: void(14.0),
    MAX_VERSION: void(0),
    HTML_PANEL: "X-Free-IsometrIcon",
    README: "license_agreement.txt",
    SYSTEM_INSTALL: false,
    INSTALLER_VERSION: "0.1.1",
    ENABLE_LOG: false,
    LOG_FILE_PATH: "~/Desktop",
    LOG_FILE: "",
    IGNORE: void(0),
    CURRENT_PATH: File($["fileName"])["path"],
    CURRENT_PS_VERSION: app["version"]["split"](".")[0]
};
PSU = (function(GLOBAL) {
    var createFolder, exceptionMessage, init, isMac, isWindows, log, that, throwFileError;
    that = this;
    this["enableLog"] = void(0);
    this["logFile"] = void(0);
    this["logFilePointer"] = void(0);
    isWindows = function() {
        return $["os"]["match"](/windows/i)
    };
    isMac = function() {
        return ! isWindows()
    };
    throwFileError = function(f, msg) {
        if (msg == null) {
            msg = ""
        };
        return Error["runtimeError"](9002, "" + msg + "\"" + f + "\": " + f["error"] + ".")
    };
    exceptionMessage = function(e) {
        var fname, str;
        fname = !e["fileName"] ? "???": decodeURI(e["fileName"]);
        str = "\x09Message: " + e["message"] + "\x0A\x09File: " + fname + "\x0A\x09Line: " + (e["line"] || "???") + "\x0A\x09Error Name: " + e["name"] + "\x0A\x09Error Number: " + e["number"];
        if ($["stack"]) {
            str += "\x09" + $["stack"]
        };
        return str
    };
    log = function(msg) {
        var file;
        if (!that["enableLog"]) {
            return
        };
        file = that["logFilePointer"];
        if (!file["open"]("e")) {
            throwFileError(file, "Unable to open Log file")
        };
        file["seek"](0, 2);
        if (!file["writeln"]("" + msg)) {
            return throwFileError(file, "Unable to write to log file")
        }
    };
    createFolder = function(fptr) {
        var rc;
        if (fptr == null) {
            Error["runtimeError"](19, "No Folder name specified")
        };
        if (fptr["constructor"] === String) {
            fptr = new Folder(fptr)
        };
        if (fptr instanceof File) {
            return createFolder(fptr["parent"])
        };
        if (fptr["exists"]) {
            return true
        };
        if (! (fptr instanceof Folder)) {
            log(fptr["constructor"]);
            Error["runtimeError"](21, "Folder is not a Folder?")
        };
        if ((fptr["parent"] != null) && !fptr["parent"]["exists"]) {
            if (!createFolder(fptr["parent"])) {
                return false
            }
        };
        rc = fptr["create"]();
        if (!rc) {
            Error["runtimeError"](9002, "Unable to create folder " + fptr + " (" + fptr["error"] + ")\x0APlease create it manually and run this script again.")
        };
        return rc
    };
    init = function(logFile, isLogEnabled) {
        var file;
        if (!isLogEnabled) {
            return
        };
        that["enableLog"] = isLogEnabled;
        that["logFile"] = logFile;
        file = new File(that["logFile"]);
        if (file["exists"]) {
            file["remove"]()
        };
        if (!file["open"]("w")) {
            throwFileError(file, "Unable to open Log file")
        };
        if (isMac()) {
            file["lineFeed"] = "unix"
        };
        that["logFilePointer"] = file
    };
    return {
        "isMac": isMac,
        "exceptionMessage": exceptionMessage,
        "log": log,
        "createFolder": createFolder,
        "init": init
    }
})(this);
PSInstaller = (function() {
    function PSInstaller() {
        G["LOG_FILE"] = "" + G["LOG_FILE_PATH"] + "/" + G["PRODUCT_NAME"] + ".log";
        PSU["init"](G.LOG_FILE, G.ENABLE_LOG);
        this["productsToInstall"] = [];
        this["foldersList"] = [];
        this["installedFiles"] = [];
        this["installedFolders"] = [];
        PSU["log"]("=======================================\x0A " + (new Date()) + "\x0A \x09Company: " + G["COMPANY"] + "\x0A \x09Product: " + G["PRODUCT_NAME"] + "\x0A \x09Product version: " + G["PRODUCT_VERSION"] + "\x0A \x09App: " + BridgeTalk["appName"] + "\x0A \x09App Version: " + app["version"] + "\x0A \x09OS: " + $["os"] + "\x0A \x09Locale: " + $["locale"] + "\x0A ---------------------------------------\x0A \x09Installer Version: " + G["INSTALLER_VERSION"] + "\x0A =======================================");
        return
    }
    PSInstaller["prototype"]["preflight"] = function() {
        var _ref;
        G["MIN_VERSION"] = G["MIN_VERSION"] || 0;
        G["MAX_VERSION"] = G["MAX_VERSION"] || 99;
        PSU["log"]("\x0APreflight \x0A----------------------------");
        if ((G["MIN_VERSION"] <= (_ref = G["CURRENT_PS_VERSION"]) && _ref <= G["MAX_VERSION"])) {
            PSU["log"]("OK: PS version " + G["CURRENT_PS_VERSION"] + " in the range [" + G["MIN_VERSION"] + ", " + G["MAX_VERSION"] + "]");
            return true
        } else {
            PSU["log"]("\x0AFAIL: PS version " + G["CURRENT_PS_VERSION"] + " not in the range [" + G["MIN_VERSION"] + ", " + G["MAX_VERSION"] + "]");
            return Error["runtimeError"](9002, "Bad Photoshop version.\x0A" + G["CURRENT_PS_VERSION"] + " not in the range [" + G["MIN_VERSION"] + ", " + G["MAX_VERSION"] + "]")
        }
    };
    PSInstaller["prototype"]["init"] = function() {
        var dependencyObj, product, that, _i, _len, _ref;
        that = this;
        dependencyObj = {
            "10": ["HTML_PANEL"],
            "11": ["HTML_PANEL"],
            "12": ["HTML_PANEL"],
            "13": ["HTML_PANEL"],
            "14": ["HTML_PANEL"],
            "15": ["HTML_PANEL"],
            "16": ["HTML_PANEL"],
            "17": ["HTML_PANEL"],
            "18": ["HTML_PANEL"],
            "19": ["HTML_PANEL"],
            "20": ["HTML_PANEL"],
            "21": ["HTML_PANEL"],
            "22": ["HTML_PANEL"],
            "23": ["HTML_PANEL"],
            "24": ["HTML_PANEL"],
            "25": ["HTML_PANEL"]
        };
        this["productsToInstall"] = dependencyObj[G["CURRENT_PS_VERSION"]];
        PSU["log"]("\x0AItems to be installed \x0A----------------------------");
        _ref = this["productsToInstall"];
        for (_i = 0, _len = _ref["length"]; _i < _len; _i++) {
            product = _ref[_i];
            PSU["log"]("- " + product)
        }
    };
    PSInstaller["prototype"]["copy"] = function() {
        var allFiles, copyFiles, createRelativeFolder, destinationFolder, destinationPath, eachFolder, getFoldersList, ignoreRegExp, panelsPath, pluginsPath, product, saveFolder, scriptsPath, sourceFolder, that, _i, _j, _len, _len1, _ref, _ref1, _results;
        that = this;
        createRelativeFolder = function(destination, origin, base) {
            var destinationArray, destinationToWriteArray, destinationToWriteFolder, destinationToWriteString, originArray, originBaseArray;
            destinationArray = decodeURI(destination).toString()["split"]("/");
            originArray = decodeURI(origin).toString()["split"]("/");
            originBaseArray = decodeURI(base).toString()["split"]("/");
            originArray["splice"](0, originBaseArray["length"]);
            destinationToWriteArray = destinationArray["concat"](originArray);
            destinationToWriteString = destinationToWriteArray["join"]("/");
            destinationToWriteFolder = Folder(destinationToWriteString);
            if (!destinationToWriteFolder["exists"]) {
                destinationToWriteFolder["create"]()
            };
            PSU["log"]("Created Folder:\x09" + destinationToWriteFolder["fsName"]);
            that["installedFolders"]["push"]("" + destinationToWriteFolder["fsName"]);
            return destinationToWriteFolder
        };
        getFoldersList = function(folder) {
            var i, item, list, _i, _len;
            if (folder["constructor"] === String) {
                folder = new Folder(folder)
            };
            list = folder["getFiles"]();
            i = 0;
            for (_i = 0, _len = list["length"]; _i < _len; _i++) {
                item = list[_i];
                if (item instanceof Folder) {
                    that["foldersList"]["push"](item);
                    PSU["log"]("Folder: " + item["fsName"]);
                    getFoldersList(item)
                }
            }
        };
        copyFiles = function(files, folder) {
            var eachFile, file, filesList, _i, _j, _len, _len1, _results;
            filesList = [];
            for (_i = 0, _len = files["length"]; _i < _len; _i++) {
                file = files[_i];
                filesList["push"](decodeURI(file))
            };
            _results = [];
            for (_j = 0, _len1 = filesList["length"]; _j < _len1; _j++) {
                eachFile = filesList[_j];
                if (File(eachFile)["exists"]) {
                    File(eachFile)["copy"]("" + folder + "/" + (File(eachFile)["name"]));
                    that["installedFiles"]["push"]("" + folder + "/" + (File(eachFile)["name"]));
                    _results["push"](PSU["log"]("Copied:\x09\x09" + (File(eachFile)["name"])))
                } else {
                    _results["push"](void(0))
                }
            };
            return _results
        };
        _ref = this["productsToInstall"];
        _results = [];
        for (_i = 0, _len = _ref["length"]; _i < _len; _i++) {
            product = _ref[_i];
            if (!G[product]) {
                PSU["log"]("\x0A" + product + " - Nothing to install\x0A");
                continue
            };
            switch (product) {
            case "HTML_PANEL":
                panelsPath = userTempFolder;
                destinationPath = "" + panelsPath;
                break
            };
            if (destinationPath === "") {
                continue
            };
            PSU["log"]("\x0A\x0AAdding " + product + "\x0A----------------------------\x0ADestination folder: " + (Folder(destinationPath)["fsName"]));
            if (PSU["createFolder"](destinationPath)) {
                PSU["log"]("Destination Folder successfully created.\x0A")
            } else {
                PSU["log"]("ERROR! Can't create destination folder.")
            };
            sourceFolder = Folder("" + G["CURRENT_PATH"] + "/" + G[product]);
            destinationFolder = Folder(destinationPath);
            this["foldersList"] = [];
            PSU["log"]("List of Folders to be copied for the " + product + ":");
            getFoldersList(sourceFolder);
            this["foldersList"]["unshift"](sourceFolder);
            PSU["log"]("Folder: " + sourceFolder);
            PSU["log"]("\x0ACreating Folders in destination and copying files:\x0A");
            ignoreRegExp = G["IGNORE"] ? new RegExp(G["IGNORE"]["join"]("|"), "i") : new RegExp("$.");
            _ref1 = this["foldersList"];
            for (_j = 0, _len1 = _ref1["length"]; _j < _len1; _j++) {
                eachFolder = _ref1[_j];
                saveFolder = createRelativeFolder(destinationFolder, eachFolder, sourceFolder);
                allFiles = eachFolder["getFiles"](function(f) {
                    if (f instanceof Folder) {
                        return false
                    } else {
                        if ((f["name"]["match"](ignoreRegExp)) != null) {
                            return false
                        };
                        return true
                    }
                });
                if (allFiles["length"]) {
                    copyFiles(allFiles, saveFolder)
                }
            };
            _results["push"](PSU["log"]("\x0AEnded copying files for " + product + "."))
        };
        return _results
    };
    PSInstaller["prototype"]["wrapUp"] = function() {
        alert("\u5b8c\u6210\u0021\u0020\u0020\u4f60\u4f1a\u627e\u5230\u0020" + G["PRODUCT_NAME"] + "\u0020\u73b0\u5728\u5728\u004f\u0072\u0061\u006e\u0067\u0065\u0042\u006f\u0078\u0020\u0046\u0058\u9762\u677f\u4e2d\u0021","\u004f\u0048\u6c49\u5316");
        if (G["README"]) {
            return (File("" + G["CURRENT_PATH"] + "/" + G["README"]))["execute"]()
        }
    };
    PSInstaller["prototype"]["createUninstaller"] = function() {
        var uninstall, uninstaller;
        uninstall = function(files, folders) {
            var e, eachFile, eachFolder, file, folder, performInstallation, uninstallErrors, _i, _j, _len;
            if (! (performInstallation = confirm("" + G["PRODUCT_NAME"] + "\u0020\u7248\u672c\u0020" + G["PRODUCT_VERSION"] + "\u0020\u5378\u8f7d\u005c\u0078\u0030\u0041\u4f60\u786e\u5b9a\u8981\u5220\u9664\u5417\u0020" + G["PRODUCT_NAME"] + "?",false,"\u004f\u0048\u6c49\u5316"))) {
                return
            };
            uninstallErrors = false;
            G["LOG_FILE"] = "" + G["LOG_FILE_PATH"] + "/" + G["PRODUCT_NAME"] + " Uninstaller.log";
            PSU["init"](G.LOG_FILE, false);
            PSU["log"]("=======================================\x0A " + (new Date()) + "\x0A \x09Company: " + G["COMPANY"] + "\x0A \x09Product: " + G["PRODUCT_NAME"] + "\x0A \x09Product version: " + G["PRODUCT_VERSION"] + "\x0A \x09App: " + BridgeTalk["appName"] + "\x0A \x09App Version: " + app["version"] + "\x0A \x09OS: " + $["os"] + "\x0A \x09Locale: " + $["locale"] + "\x0A ---------------------------------------\x0A \x09Installer Version: " + G["INSTALLER_VERSION"] + "\x0A =======================================");
            PSU["log"]("\x0ARemoving FILES...");
            for (_i = 0, _len = files["length"]; _i < _len; _i++) {
                eachFile = files[_i];
                try {
                    file = File(eachFile);
                    PSU["log"]("Removing:\x09" + file["fsName"] + "...");
                    file["remove"]();
                    PSU["log"]("Done!")
                } catch(_error) {
                    e = _error;
                    PSU["log"]("ERROR!");
                    uninstallErrors = true
                }
            };
            PSU["log"]("---------------------------------------\x0A Removing FOLDERS...");
            for (_j = folders["length"] - 1; _j >= 0; _j += -1) {
                eachFolder = folders[_j];
                try {
                    folder = Folder(eachFolder);
                    PSU["log"]("Removing:\x09" + folder["fsName"] + "...");
                    folder["remove"]();
                    PSU["log"]("Done!")
                } catch(_error) {
                    e = _error;
                    PSU["log"]("ERROR!");
                    uninstallErrors = true
                };
                if (uninstallErrors) {
                    alert("\u51fa\u9519\u4e86\u0021\u005c\u0078\u0030\u0041\u5378\u8f7d\u65e5\u5fd7\u6587\u4ef6\u5df2\u521b\u5efa\u5728\u003a\u005c\u0078\u0030\u0041" + G["LOG_FILE"] + "\u002c\u0020\u8bf7\u53d1\u9001\u7ed9\u0020" + G["CONTACT_INFO"],"\u004f\u0048\u6c49\u5316");
                    throw Error("\u91cd\u65b0\u542f\u52a8\u0050\u0068\u006f\u0074\u006f\u0073\u0068\u006f\u0070\u5e76\u67e5\u770b\u4ea7\u54c1\u662f\u5426\u5df2\u88ab\u5378\u8f7d\u002e")
                }
            };
            return alert("" + G["PRODUCT_NAME"] + "\u0020\u6210\u529f\u5220\u9664\u005c\u0078\u0030\u0041\u8bf7\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u002e","\u004f\u0048\u6c49\u5316")
        };
        uninstaller = new File("" + userTempFolder + "/" + G["PRODUCT_NAME"] + "-UNINSTALLER.jsx");
        if (!uninstaller["open"]("w")) {
            throwFileError(uninstaller, "\u65e0\u6cd5\u5199\u5165\u5378\u8f7d\u7a0b\u5e8f\u6587\u4ef6")
        };
        if (PSU["isMac"]()) {
            uninstaller["lineFeed"] = "unix"
        };
        uninstaller["writeln"]("var G = " + (G["toSource"]()));
        uninstaller["writeln"]("var PSU=(function(GLOBAL){var createFolder,exceptionMessage,init,isMac,isWindows,log,that,throwFileError;that=this;this.enableLog=void 0;this.logFile=void 0;this.logFilePointer=void 0;isWindows=function(){return $.os.match(/windows/i);};isMac=function(){return!isWindows();};throwFileError=function(f,msg){if(msg==null){msg='';}return Error.runtimeError(9002,''+msg+''+f+': '+f.error+'.');};exceptionMessage=function(e){var fname,str;fname=!e.fileName?'???':decodeURI(e.fileName);str='  Message: '+e.message+'  File: '+fname+'\\tLine: '+(e.line||'???')+'\\n\\tError Name: '+e.name+'\\n\\tError Number: '+e.number;if($.stack){str+='  '+$.stack;}return str;};log=function(msg){var file;if(!that.enableLog){return;}file=that.logFilePointer;if(!file.open('e')){throwFileError(file,'Unable to open Log file');}file.seek(0,2);if(!file.writeln(''+msg)){return throwFileError(file,'Unable to write to log file');}};createFolder=function(fptr){var rc;if(fptr==null){Error.runtimeError(19,'No Folder name specified');}if(fptr.constructor===String){fptr=new Folder(fptr);}if(fptr instanceof File){return createFolder(fptr.parent);}if(fptr.exists){return true;}if(!(fptr instanceof Folder)){log(fptr.constructor);Error.runtimeError(21,'Folder is not a Folder?');}if((fptr.parent!=null)&&!fptr.parent.exists){if(!createFolder(fptr.parent)){return false;}}rc=fptr.create();if(!rc){Error.runtimeError(9002,'Unable to create folder '+fptr+' ('+fptr.error+') Please create it manually and run this script again.');}return rc;};init=function(logFile,isLogEnabled){var file;if(!isLogEnabled){return;}that.enableLog=isLogEnabled;that.logFile=logFile;file=new File(that.logFile);if(file.exists){file.remove();}if(!file.open('w')){throwFileError(file,'Unable to open Log file');}if(isMac()){file.lineFeed='unix';}that.logFilePointer=file;};return{'isMac':isMac,'exceptionMessage':exceptionMessage,'log':log,'createFolder':createFolder,'init':init};})(this);");
        uninstaller["writeln"]("var filesToRemove = " + (this["installedFiles"]["toSource"]()) + ";");
        uninstaller["writeln"]("var foldersToRemove = " + (this["installedFolders"]["toSource"]()) + ";");
        uninstaller["writeln"]("var uninstall = " + (uninstall["toSource"]()) + ";");
        uninstaller["writeln"]("uninstall(filesToRemove, foldersToRemove);");
        return uninstaller["close"]()
    };
    return PSInstaller
})();
try {
    psInstaller = new PSInstaller();
    psInstaller["preflight"]();
    psInstaller["init"]();
    psInstaller["copy"]();
    psInstaller["createUninstaller"]();
    psInstaller["wrapUp"]()
} catch(_error) {
    e = _error;
    errorMessage = "Installation failed: " + (PSU["exceptionMessage"](e));
    PSU["log"](errorMessage);
    alert("\u51fa\u9519\u4e86\u0021\u005c\u0078\u0030\u0041" + errorMessage + "\u005c\u0078\u0030\u0041\u8bf7\u8054\u7cfb\u0020" + G["CONTACT_INFO"] + "\u002c\u0020\u8c22\u8c22\u002e")
};
"psInstaller"