;;
;;
;;  ACETLAYR.lsp - Layer routines
;;  Copyright ?1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer
;;  Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;  (Rights in Technical Data and Computer Software), as applicable.
;;
;;-------------------------------------------------------------------------
;;
;;  DESCRIPTION
;;    Layer manipulation routines.
;;
;;-------------------------------------------------------------------------
 
(acet-autoload '("lman.lsp" "(bns_sl ls)"))
(acet-autoload '("lman.lsp" "(bns_rl ls)"))
(acet-autoload '("lman.lsp" "(bns_dl ls)"))
 
; -------------------- ISOLATE LAYER FUNCTION --------------------
; Isolates selected object's layer by turning all other layers off
; ----------------------------------------------------------------
 
(Defun C:LAYISO (/ SS CNT LAY LAYLST VAL VPMODE)
  ;;;local function to find an unused layer state name for saving
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
      T     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
  (acet-autoload '("lman.lsp" "(bns_sl  name)"))   ;;changed to support LAYUNISO
 
  (if (and (= 1 (acet-LayVpMode-Get))
           (= 0 (getvar "tilemode"))                          ; if in a paper space
           (/= 1 (getvar "cvport"))                           ; viewport
      )
      (setq VPMODE T)                                           ; set flag for viewport behavior
  )
 
  (if (not (setq SS (ssget "_i")))
    (progn
      (prompt "\nSelect object(s) on the layer(s) to be isolated: ")
      (setq SS (ssget))
    )
  )
 
 
  (if SS
    (progn
 
      (setq CNT 0)
 
      (while (and ss
                  (> (sslength ss) 0)
                  (setq LAY (ssname SS CNT))
             );and
        (setq LAY (cdr (assoc 8 (entget LAY))))
        (if (not (member LAY LAYLST))
          (setq LAYLST (cons LAY LAYLST))
        )
        (setq CNT (1+ CNT))
      )
 
      (cond
        (VPMODE
          (bns_sl "ACET-lAYISO") ;setq    Save the current layer state
          (setq acet:LSTVPORT (list (getvar "ctab") (acet-currentviewport-ename))) ;setq save the layout and the viewport
          (command "_.vplayer" "_freeze" "*" "_Current")
          (foreach VAL LAYLST (command "_Thaw" VAL "_Current"))
          (command "")
          (if (= (length LAYLST) 1)
            (prompt (acet-str-format "\nLayer %1 has been isolated in this viewport." (car LAYLST)))
            (prompt (acet-str-format "\n%1 layers have been isolated in this viewport." (itoa (length LAYLST))))
          )
        )
        (T
          (bns_sl "acet-layiso") ;setq    Save the current layer state
          (setq acet:LSTVPORT (list (getvar "ctab") (acet-currentviewport-ename))) ;setq save the layout and the viewport
          ;(setq acet:LSTVPORT (list "Model")) ;setq   new GLOBAL for LAYUNISO
          (if (member (getvar "CLAYER") LAYLST)
            (setq LAY (getvar "CLAYER"))
            (setvar "CLAYER" (setq LAY (last LAYLST)))
          )
 
          (command "_.-LAYER" "_OFF" "*" "_Y")
          (foreach VAL LAYLST (command "_ON" VAL))
          (command "")
 
          (if (= (length LAYLST) 1)
            (prompt (acet-str-format "\nLayer %1 has been isolated." (car LAYLST)))
            (prompt (acet-str-format "\n%1 layers have been isolated. Layer %2 is current."
                                      (itoa (length LAYLST)) LAY)
            )
          )
        )
      )
    )
  )
 
  (acet-error-restore)
 
  (princ)
)
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Controls usage of vplayer vs layer when in paper space.
;
(defun c:layvpmode ()
 (acet-error-init nil)
 (acet-LayVpMode-ui-get)
 (acet-error-restore)
);defun c:layvpmode
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-LayVpMode-Get ( / a )
 (setq a (acet-getvar (list "ACET-LAYVPMODE")))
 (if (or (not a)
         (not (equal 'INT (type a)))
     );or
     (progn
      (acet-setvar (list "ACET-LAYVPMODE" 1 3))
      (setq a 1)
     );progn then
 );if
 a
);defun acet-Layvpmode-Get
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-LayVpMode-Set ( a / )
 (if (and a
          (equal 'INT (type a))
     );and
     (progn
      (acet-setvar (list "ACET-LAYVPMODE" a 3))
     );progn then
     (setq a nil)
 );if
 a
);defun acet-LayVpMode-Set
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Prompts for layer viewport mode. Vpfreeze or freeze/off
;
(defun acet-LayVpMode-ui-get ( / ans def )
 (setq def (acet-LayVpMode-get))
 (initget "Yes No")
 (if (= def 1)
     (setq ans (getkword "\nUse 'VpFreeze' in place of 'Freeze' or 'Off' when in paper space? <Y>: "))
     (setq ans (getkword "\nUse 'VpFreeze' in place of 'Freeze' or 'Off' when in paper space? <N>: "))
 );if
 (if ans
     (progn 
      (if (= ans "Yes")
          (setq def 1)
          (setq def 0)
      );if
      (acet-LayVpMode-Set def)
     );progn then
 );if
 def
);defun acet-LayVpMode-ui-get
 
 
; -------------------- LAYER FREEZE FUNCTION ---------------------
; Freezes selected object's layer
; ----------------------------------------------------------------
 
(defun C:LAYFRZ ()
; --------------------- Error initialization ---------------------
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
 
      nil     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (layproc "frz")
 
  (acet-error-restore)
  (princ)
)
 
; ---------------------- LAYER OFF FUNCTION ----------------------
; Turns selected object's layer off
; ----------------------------------------------------------------
 
(defun C:LAYOFF ()
; --------------------- Error initialization ---------------------
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
 
      nil     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (layproc "off")
 
  (acet-error-restore)
  (princ)
)
 
; ------------- LAYER PROCESSOR FOR LAYOFF & LAYFRZ --------------
; Main program body for LAYOFF and LAYFRZ. Provides user with
; options for handling nested entities.
; ----------------------------------------------------------------
 
(defun LAYPROC ( TASK / NOEXIT OPT BLKLST CNT VPMODE EN PMT ANS LAY NEST BLKLST VPSS flt allLayouts)
 
 
 
; -------------------- Variable initialization -------------------
 
  (setq NOEXIT T)
 
  (setq OPT (getenv (strcat "ACET_Lay" TASK)))    ; get default option setting
  (if (not (or (null OPT) (= OPT ""))) (setq OPT (atoi OPT)))
 
  (setq CNT 0)                                                ; cycle counter
 
  (if (and (= 1 (acet-LayVpMode-Get))
           (= 0 (getvar "tilemode"))                          ; if in a paper space
           (/= 1 (getvar "cvport"))                           ; viewport
      )
      (setq VPMODE T)                                           ; set flag for freeze behavior
  )
 
 
; ----------------------- Selection Prompt -----------------------
 
  (while NOEXIT
 
    (setvar "errno" 7)
    (while (= (getvar "errno") 7)
      (setvar "errno" 0)
      (initget "Options Undo _Options Undo")
      (cond
        ((= TASK "off")
          (setq EN (nentsel "\nSelect an object on the layer to be turned off or [Options/Undo]: "))
        )
        ((= TASK "frz")
          (setq EN (nentsel "\nSelect an object on the layer to be frozen or [Options/Undo]: "))
        )
        ((= TASK "vpi")
          (setq EN (nentsel "\nSelect an object on the layer to be Isolated in viewport or [Options/Undo]: "))
        )
      )
      (if (= (getvar "errno") 7)
        (prompt "\nNothing selected.")
      )
    )
 
; ---------------------- Options  Selected -----------------------
 
    (cond
      ((= EN "Options")
        (if (= TASK "vpi")
            (progn
             (initget "Layouts Selection")
             (setq ans (getkword "\nSelect an option [Layouts/Selection]: "))
             (if (= ans "Layouts")
                 (acet-layvpi-ui-get-layoutmode)
                 (setq opt (acet-layproc-ui-get-selectmode opt))
             );if
            );progn then
            (setq opt (acet-layproc-ui-get-selectmode opt))
        );if
 
      ) 
; ---------------------- Undo selected ---------------------------
 
      ((= EN "Undo")
        (if (> CNT 0)
          (progn
            (command "_.u")
            (setq CNT (1- CNT))
          )
          (prompt "\nEverything has been undone.")
        )
      )
 
; ------------------------- Find Layer ---------------------------
 
    (EN
 
        (setq BLKLST (last EN))
        (setq NEST (length BLKLST))
 
        (cond
 
      ; If the entity is not nested or if the option for entity
      ; level nesting is selected.
 
          ((or (= OPT 2) (< (length EN) 3))
            (setq LAY (entget (car EN)))
          )
 
      ; If no nesting is desired
 
          ((= OPT 1)
            (setq LAY (entget (car (reverse BLKLST))))
          )
 
      ; All other cases (default)
 
          (T
            (setq BLKLST (reverse BLKLST))
 
            (while (and                         ; strip out xrefs
                ( > (length BLKLST) 0)
                (assoc 1 (tblsearch "BLOCK" (cdr (assoc 2 (entget (car BLKLST))))))
                   );and
              (setq BLKLST (cdr BLKLST))
            )
            (if ( > (length BLKLST) 0)          ; if there is a block present
              (setq LAY (entget (car BLKLST)))  ; use block layer
              (setq LAY (entget (car EN)))      ; else use layer of nensel
            )
          )
        )
 
; ------------------------ Process Layer -------------------------
 
        (setq LAY (cdr (assoc 8 LAY)))
 
        (if (= LAY (getvar "CLAYER"))
          (cond
            ((= TASK "off")
              (initget "Yes No _Yes No")
              (setq ANS (getkword (acet-str-format "\nReally want layer %1 (the CURRENT layer) off? [Yes/No] <No>: " LAY)))
              (setq ANS (if (null ANS) "No" ANS))
              (if (= ANS "No")
                (setq LAY nil)
              )
            )
            ((and (= TASK "frz") (not VPMODE))
              (prompt (acet-str-format "\nCannot freeze layer %1.  It is the CURRENT layer." LAY))
              (setq LAY nil)
            )
          )
          (setq ANS nil)
        )
 
        (if LAY
          (cond
            ((= TASK "off")
              (if ANS
                (command "_.-LAYER" "_OFF" LAY "_Yes" "")
                (command "_.-LAYER" "_OFF" LAY "")
              )
              (prompt (acet-str-format "\nLayer %1 has been turned off." LAY))
              (setq CNT (1+ CNT))
            )
            ((and (= TASK "frz") VPMODE)
              (command "_.VPLAYER" "_FREEZE" LAY "_current" "")
              (prompt (acet-str-format "\nLayer %1 has been frozen in this viewport." LAY))
              (setq CNT (1+ CNT))
            )
            ((= TASK "frz")
              (command "_.-LAYER" "_FREEZE" LAY "")
              (prompt (acet-str-format "\nLayer %1 has been frozen."  LAY ))
              (setq CNT (1+ CNT))
            )
            ((= TASK "vpi")
              (setq flt (list '(-4 . "<AND")
                                '(0 . "VIEWPORT")                 ; get all viewports
 
                                '(-4 . "<NOT")			; except the current one
                                  '(-4 . "<AND")
                                    (cons 69 (getvar "cvport"))    
                                    (cons 410 (acet-str-esc-wildcards (getvar "ctab")))
                                  '(-4 . "AND>")
                                '(-4 . "NOT>")
  
                                '(-4 . "<NOT")			;exclude the paper space viewports as well
                                  '(69 . 1)                      
                                '(-4 . "NOT>")
                        );list
              );setq
              (setq allLayouts (acet-getvar (list "ACET-LAYVPI-ALL-LAYOUTS" 2)))
              (if (= allLayouts 1)
                  (setq flt (append flt '((-4 . "AND>"))));setq then
                  (setq flt (append flt 
                                    (list
                                     (cons 410 (acet-str-esc-wildcards (getvar "ctab")))
                                     '(-4 . "AND>")
                                    );list
                            );append
                  );setq else current layout only
              );if
              (setq VPSS (ssget "_x" flt))
              
              (if vpss
                  (progn
                   (if (= allLayouts 1)
                       (progn
                        (sssetfirst nil nil)
                        (command "_.select" "") ;dummy command so undo is handled properly
                        (acet-viewport-vpfreeze vpss (list lay))
                       );progn 
                       (command "_.VPLAYER" "_FREEZE" LAY "_select" VPSS "" "")
                   );if
                   (prompt (acet-str-format "\nLayer %1 has been frozen in all viewports but the current one."  LAY ))
                  );progn then
              );if 
              (setq CNT (1+ CNT))
            )
          )
        )
      )
 
; ---------------------- Nothing  Selected -----------------------
 
      ((not EN)
        (setq NOEXIT nil)
      )
    )
  )
)
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;prompts for layout mode "all" or "current only".
;returns 1 for all and 0 for current.
;
(defun acet-layvpi-ui-get-layoutmode ( / ans def )
 (setq def (acet-getvar (list "ACET-LAYVPI-ALL-LAYOUTS" 2)))
 (if (not def)
     (setq def 0)
 );if
 (initget "All Current")
 (if (= def 1)
     (setq ans (getkword "\nIsolate layers in [All layouts/Current layout] <All>: "))
     (setq ans (getkword "\nIsolate layers in [All layouts/Current layout] <Current>: "))
 );if
 (if ans
     (progn 
      (if (= ans "All")
          (setq def 1)
          (setq def 0)
      );if
     );progn then
 );if
 (acet-setvar (list "ACET-LAYVPI-ALL-LAYOUTS" def 2))
 def
);defun acet-layvpi-ui-get-layoutmode
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-layproc-ui-get-selectmode ( opt / pmt ans )
  (initget "No Block Entity _No Block Entity")
  (cond
   ((= OPT 1)
    (setq PMT "\nEnter an option [Block level nesting/Entity level nesting/]<No nesting>: ")
   )
   ((= OPT 2)
    (setq PMT "\nEnter an option [Block level nesting/No nesting/]<Entity level nesting>: ")
   )
   (T
    (setq PMT "\nEnter an option [Entity level nesting/No nesting/]<Block level nesting>: ")
   )
  );cond close
  (setq ANS (getkword PMT))
 
  (cond
   ((null ANS)
    (if (or (null OPT) (= OPT ""))
        (progn
         (setq OPT 3)
         (setenv (strcat "ACET_Lay" TASK) "3")
        )
    )
   )
   ((= ANS "No")
    (setq OPT 1)
    (setenv (strcat "ACET_Lay" TASK) "1")
   )
   ((= ANS "Entity")
    (setq OPT 2)
    (setenv (strcat "ACET_Lay" TASK) "2")
   )
   (T
    (setq OPT 3)
    (setenv (strcat "ACET_Lay" TASK) "3")
   )
  );cond close
  opt
);defun acet-layproc-ui-get-selectmode
 
; --------------------- LAYER LOCK FUNCTION ----------------------
; Locks selected object's layer
; ----------------------------------------------------------------
 
(Defun C:LAYLCK (/ LAY)
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
 
      T     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (setq LAY (entsel "\nSelect an object on the layer to be locked: "))
 
  (if LAY
    (progn
      (setq LAY (cdr (assoc 8 (entget (car LAY)))))
      (Command "_.-LAYER" "_LOCK" LAY "")
      (prompt (acet-str-format "\nLayer %1 has been locked."  LAY ))
    )
  )
 
  (acet-error-restore)
 
  (princ)
)
 
; -------------------- LAYER UNLOCK FUNCTION ---------------------
; Unlocks selected object's layer
; ----------------------------------------------------------------
 
(Defun C:LAYULK (/ LAY)
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
 
      T     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (setq LAY (entsel "\nSelect an object on the layer to be unlocked: "))
 
  (if LAY
    (progn
      (setq LAY (cdr (assoc 8 (entget (car LAY)))))
      (Command "_.-LAYER" "_UNLOCK" LAY "")
      (prompt (acet-str-format "\nLayer %1 has been unlocked."  LAY ))
    )
  )
 
  (acet-error-restore)
 
  (princ)
)
 
; ---------------------- LAYER ON FUNCTION -----------------------
; Turns all layers on
; ----------------------------------------------------------------
 
(Defun C:LAYON ()
 
  (acet-error-init
    (list
      (list "cmdecho" 0)
      nil     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (Command "_.-LAYER" "_ON" "*" "")
  (prompt "\nAll layers have been turned on.")
 
  (acet-error-restore)
 
  (princ)
)
 
 
; --------------------- LAYER THAW FUNCTION ----------------------
; Thaws all layers
; ----------------------------------------------------------------
 
(Defun C:LAYTHW ()
 
  (acet-error-init
    (list
      (list "cmdecho" 0)
      nil     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  (Command "_.-LAYER" "_THAW" "*" "")
  (prompt "\nAll layers have been thawed.")
 
  (acet-error-restore)
 
  (princ)
)
 
 
; --------------------- LAYER MATCH FUNCTION ---------------------
; Changes the layer of selected object(s) to the layer of a
; selected destination object.
; ----------------------------------------------------------------
 
(Defun C:LAYMCH (/ SS CNT LOOP LAY ANS)
 
  (acet-error-init
    (list
      (list "cmdecho" 0)
      T     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
 
  (if (not (setq SS (ssget "_i")))
    (progn
      (prompt "\nSelect objects to be changed: ")
      (setq SS (ssget))
    )
  )
 
  (if SS
    (progn
      (setq CNT (sslength SS))
      (princ (acet-str-format "\n%1 found."  (itoa CNT)))       ; Report number of items found
      (sssetfirst nil nil) 
      (command "_.move" SS "")                         ; filter out objects on locked layers
 
      (if (> (getvar "cmdactive") 0)                   ; if there are still objects left
        (progn
          (command "0,0" "0,0")
          (setq SS  (ssget "_p")
                CNT (- CNT (sslength SS))              ; count them
          )
        )
        (setq SS nil)                                  ; else abort operation
      )
 
      (if (> CNT 0)                                    ; if items where filtered out
        (if (= CNT 1)
          (princ (acet-str-format "\n%1 was on a locked layer."  (itoa CNT) ))   ; report it.
          (princ (acet-str-format "\n%1 were on a locked layer."  (itoa CNT) ))
        )
      )
    )
  )
 
 
  (if SS
    (progn
      (initget "Type-it _Type-it")
      (setq LAY  (entsel "\nSelect object on destination layer or [Type-it]: ")
            LOOP T
      )
 
      (while LOOP
        (cond
          ((not LAY)
            (prompt "\nNothing selected.")
            (initget "Yes No _Yes No")
            (setq ANS (getkword "\nUse current layer? [Yes/No] <Yes> "))
            (setq ANS (if (null ANS) "Yes" ANS))
            (if (= ANS "Yes")
              (setq LAY  (getvar "clayer")
                    LOOP nil
              )
            )
          )
          ((listp LAY)
            (setq LOOP nil)
          )
          ((= LAY "Type-it")
            (setq LAY (getstring "\nEnter layer name: "))
            (cond
              ((tblobjname "LAYER" LAY)
                (setq LOOP nil)
              )
              ((/= LAY "")
                (initget "Yes No _Yes No")
                (setq ANS (getkword "\nLayer does not exist. Would you like to create it? [Yes/No] <Yes>: "))
                (setq ANS (if (null ANS) "Yes" ANS)) ;setq
                (if (= ANS "Yes")
                  (if
                    (entmake (list
                              '(0 . "LAYER")
                              '(100 . "AcDbSymbolTableRecord")
                              '(100 . "AcDbLayerTableRecord")
                              '(6 . "CONTINUOUS")
                              '(62 . 7)
                              '(70 . 0)
                               (cons 2 LAY)
                             )
                    )
                    (setq LOOP nil)
                    (prompt "\nInvalid Layer name.")
                  )
                )
              )
            )
          )
        )
        (if LOOP
          (progn
            (initget "Type-it _Type-it")
            (setq LAY (entsel "\nSelect entity on destination layer or [Type-it]: "))
          )
        )
      ); while LOOP
 
 
      (if (listp LAY)
        (setq LAY (cdr (assoc 8 (entget (car LAY)))))
      )
      (command "_.chprop" SS "" "_la" LAY "")
 
      (if (= (sslength SS) 1)
        (prompt (acet-str-format "\nOne object changed to layer %1" LAY ))
        (prompt (acet-str-format "\n%1 objects changed to layer %2" (itoa (sslength SS)) LAY ))
      )
      (if (= LAY (getvar "clayer"))
        (prompt " (the current layer).")
        (prompt ".")
      )
    )
  )
 
  (acet-error-restore)
 
  (princ)
)
 
; --------------- CHANGE TO CURRENT LAYER FUNCTION ---------------
; Changes the layer of selected object(s) to the current layer
; ----------------------------------------------------------------
 
(Defun C:LAYCUR (/ SS CNT LAY)
 
  (acet-error-init
    (list
      (list "cmdecho" 0)
      T     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
 
  (if (not (setq SS (ssget "_i")))
    (progn
      (prompt "\nSelect objects to be changed to the current layer: ")
      (setq SS (ssget))
    )
  )
 
  (if SS
    (progn
      (setq CNT (sslength SS))
      (princ (acet-str-format "\n%1 found."  (itoa CNT) ))       ; Report number of items found
      (sssetfirst nil nil)
      (command "_.move" SS "")                         ; filter out objects on locked layers
 
      (if (> (getvar "cmdactive") 0)                   ; if there are still objects left
        (progn
          (command "0,0" "0,0")
          (setq SS  (ssget "_p")
                CNT (- CNT (sslength SS))              ; count them
          )
        )
        (setq SS nil)                                  ; else abort operation
      )
 
      (if (> CNT 0)                                    ; if items where filtered out
        (if (= CNT 1)
          (princ (acet-str-format "\n%1 was on a locked layer."  (itoa CNT) ))   ; report it.
          (princ (acet-str-format "\n%1 were on a locked layer."  (itoa CNT) ))
        )
      )
    )
  )
 
  (if SS
    (progn
      (setq LAY (getvar "CLAYER"))
 
      (command "_.chprop" SS "" "_la" LAY "")
 
      (if (= (sslength SS) 1)
        (prompt (acet-str-format "\nOne object changed to layer %1 (the current layer)."  LAY ))
        (prompt (acet-str-format "\n%1 objects changed to layer %2 (the current layer)." (itoa (sslength SS)) LAY))
      )
    )
  )
 
  (acet-error-restore)
 
  (princ)
)
; -------------ISOLATE LAYER TO CURRENT VIEWPORT FUNCTION --------
; Isolates selected object's layer to its floating viewport.
; PV: Moved this here from LAYVPI.LSP , removed autoload stub  4/7/1999
; ----------------------------------------------------------------
 
(defun C:LAYVPI ( / PS)
 
  (acet-error-init
    (list
      (list "cmdecho" 0
            "expert"  0
      )
 
      nil     ;flag. True means use undo for error clean up.
    );list
  );acet-error-init
 
  ;(acet-autoload '("acetlayr.lsp" "(layproc str)"))
 
  (cond
    ((not (equal 0 (getvar "tilemode")))
       (princ "\n  Command not allowed unless TILEMODE is set to 0  ")
    )
    ((> 3 (sslength (ssget "_x" '((0 . "VIEWPORT")))))
       (princ "\n  Command works with two or more viewports only  ")
    )
    (T
      (if (= (getvar "cvport") 1)
        (progn
          (command "_.mspace")
          (setq PS T)
        )
      )
      (layproc "vpi")
      (if PS (command "_.pspace"))
    )
  )
 
  (acet-error-restore)
  (princ)
);defun c:layvpi
 
(defun C:LAYUNISO (/ elistvp)
  (acet-error-init '(("CMDECHO" 0  "EXPERT" 0) T))
 
  ;;  requires LMAN routines
  ;(if (not (load "lman" nil))
  ;  (progn
  ;    (alert "Could not load 'LMAN.LSP'.")
  ;    (exit)
  ;  )
  ;)
 
  ;;  anything saved ??
  (if (and acet:LSTVPORT (member "ACET-LAYISO" (bns_get_layerstates)))
    (cond
      ((member (car acet:LSTVPORT) (acet-dict-name-list "acad_layout"))
        (setvar "CTAB" (car acet:LSTVPORT))
        (if (cadr acet:LSTVPORT)
            (progn     
             (if (setq elistvp (entget (cadr acet:LSTVPORT)))
                 (progn
                  (setvar "CVPORT" (cdr (assoc 69 elistvp)))
                  (bns_rl "ACET-LAYISO")
                  (bns_dl "ACET-LAYISO")
                 );progn then get the entity list so go for it.
                 (princ "\nViewport has been deleted or 'Display viewport objects' has been turned off since the last LAYISO")
             );if
            );progn then got an ename of viewport
            (progn
             (bns_rl "ACET-LAYISO")
             (bns_dl "ACET-LAYISO")
            );progn else no ename (model(tilemode=1) or paper it was the space viewport)
        );if
      );cond #1
 
    ;;  must be deleted layout
      (T
        (princ (acet-str-format "\nLayout '%1' has been deleted since last LAYISO" (car acet:LSTVPORT)))
        (bns_dl "ACET-LAYISO")
      )
    )
    (princ "\nNo layers to restore from LAYISO command.")
  )
 
  (acet-error-restore)
  (princ)
)

(princ)
