/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkinterface;

import com.st.stlinkinterface.STLinkDevVersion;
import com.st.stlinkinterface.jni.STLinkDevInfo;
import com.st.stlinkinterface.jni.STLinkDevRequest;
import com.st.stlinkinterface.jni.STLinkUSBDriverJni;
import java.util.Arrays;

public class STLinkDevice {
    public static final long DEV_NO_ERR = 0L;
    public static final long DEV_CONNECT_ERR = 1L;
    public static final long DEV_DLL_ERR = 2L;
    public static final long DEV_USB_COMM_ERR = 3L;
    public static final long DEV_NO_DEVICE = 4L;
    public static final long DEV_NO_MORE_HW_BKPT = 5L;
    public static final long DEV_BAD_BKPT_ADDRESS = 6L;
    public static final long DEV_UNKNOWN_MCU_TARGET = 7L;
    public static final long DEV_FLASH_MONITOR_OPEN_ERR = 8L;
    public static final long DEV_FLASH_MONITOR_READ_ERR = 9L;
    public static final long DEV_FLASH_MONITOR_EXEC_ERR = 10L;
    public static final long DEV_FLASH_PROG_ERR = 11L;
    public static final long DEV_FLASH_VERIFY_ERR = 12L;
    public static final long DEV_FLASH_PROG_TIMEOUT = 13L;
    public static final long DEV_FIRMWARE_TOO_OLD_FOR_API2 = 14L;
    public static final long DEV_OLD_FIRMWARE_WARNING = 15L;
    public static final long DEV_TARGET_RESET_ERR = 16L;
    public static final long DEV_TARGET_HELD_UNDER_RESET = 16L;
    public static final long DEV_TARGET_NOT_HALTED = 18L;
    public static final long DEV_TARGET_CMD_ERR = 19L;
    public static final long DEV_PARAM_ERR = 20L;
    public static final long DEV_CMD_NOT_SUPPORTED = 21L;
    public static final long DEV_FLASH_NOT_BLANK = 22L;
    public static final long DEV_DFU_RUNNING_NOT_EXPECTED = 23L;
    public static final long DEV_GET_INFO_ERR = 24L;
    public static final long DEV_OPEN_GO_TO_USB_LOADER_CMD_ERR = 25L;
    public static final long DEV_OPEN_CANNOT_GO_TO_USB_LOADER = 26L;
    public static final long DEV_OPEN_COMM_ERR = 27L;
    public static final long DEV_DFU_INTERNAL_ERR = 28L;
    public static final long DEV_DEVICE_NOT_SUPPORTED = 29L;
    public static final long DEV_PERMISSION_ERR = 30L;
    public static final long DEV_ENUM_ERR = 31L;
    public static final byte STLINK_DFU_COMMAND = -13;
    public static final byte STLINK_DFU_EXIT = 7;
    public static final byte STLINK_GET_CURRENT_MODE = -11;
    public static final byte STLINK_GET_TARGET_VOLTAGE = -9;
    public static final byte STLINK_GET_BOARD_TYPE = -8;
    public static final byte STLINK_GO_TO_USB_LOADER = -7;
    public static final byte STLINK_IS_JUMP_POSSIBLE = 0;
    public static final byte STLINK_JUMP_NOW = 1;
    public static final byte STLINK_DEV_DFU_MODE = 0;
    public static final byte STLINK_DEV_MASS_MODE = 1;
    public static final byte STLINK_DEV_JTAG_MODE = 2;
    public static final byte STLINK_DEV_SWIM_MODE = 3;
    public static final byte STLINK_DEV_BTLD_MODE = 4;
    public static final short STLINK_JTAG_OK = 128;
    public static final short STLINK_NO_JUMP_TO_USB_LOADER = 33;
    protected static final int CMD_HEADER_SIZE = 16;
    protected static final long INVALID_HANDLE = -1L;
    protected static final int STLINK_DEFAULT_TIMEOUT_MS = 5000;
    protected STLinkUSBDriverJni m_jni;
    protected STLinkDevInfo m_jniDevInfo;
    protected int m_ifId;
    protected STLinkDevRequest m_devReq;
    protected long m_devHandle;
    protected int m_timeout;
    protected STLinkDevVersion m_version;
    protected byte m_currentMode;
    protected byte m_STLinkV2_DfuVer;

    public STLinkDevice(STLinkUSBDriverJni sTLinkUSBDriverJni) {
        this.m_jni = sTLinkUSBDriverJni;
        this.m_jniDevInfo = new STLinkDevInfo();
        this.m_devReq = new STLinkDevRequest();
        this.m_devHandle = -1L;
        this.m_timeout = 5000;
        this.m_version = null;
        this.m_currentMode = 1;
        this.m_STLinkV2_DfuVer = 0;
    }

    public byte GetDfuVersion() {
        return this.m_STLinkV2_DfuVer;
    }

    protected long ConvertJniStatus(long l) {
        long l2 = 20L;
        if (l >= 65536L) {
            System.out.println("JNI error returned by system: " + Long.toString(l - 65536L));
            l2 = 3L;
        } else {
            switch ((int)l) {
                case 1: {
                    l2 = 0L;
                    break;
                }
                case 130: {
                    l2 = 4L;
                    break;
                }
                case 4: 
                case 129: 
                case 228: 
                case 4096: 
                case 4099: {
                    l2 = 1L;
                    break;
                }
                case 4098: 
                case 4176: {
                    l2 = 20L;
                    break;
                }
                case 4179: {
                    l2 = 21L;
                    break;
                }
                case 4097: 
                case 4100: 
                case 8192: {
                    l2 = 3L;
                    break;
                }
                case 4180: {
                    l2 = 29L;
                    break;
                }
                case 4181: {
                    l2 = 30L;
                    break;
                }
            }
        }
        return l2;
    }

    protected short ConvertStatus(byte[] byArray) {
        int n = byArray[1] << 8 & 0xFF00;
        return (short)(n += byArray[0] & 0xFF);
    }

    protected long SendCmd(long l, long l2) {
        long l3 = 20L;
        if (this.m_jni.IsNativeLoaded()) {
            long l4 = this.m_jni.SendCommand(l, this.m_devReq, l2);
            l3 = this.ConvertJniStatus(l4);
            if (l3 != 0L) {
                System.out.println("JNI command error 0x" + Long.toHexString(l4) + " after cmd " + Arrays.toString(this.m_devReq.m_cmd));
            }
        } else {
            System.out.println("JNI not loaded in SendCmd");
            l3 = 2L;
        }
        return l3;
    }

    protected long GetVersionCmd(STLinkDevVersion sTLinkDevVersion) {
        byte[] byArray = new byte[6];
        this.m_devReq.m_cmd[0] = -15;
        this.m_devReq.m_cmd[1] = -128;
        for (int i = 2; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 6;
        long l = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l == 0L) {
            int n = byArray[0] & 0xFF;
            sTLinkDevVersion.m_majorVer = n >> 4 & 0xF;
            int n2 = byArray[1] & 0xFF;
            sTLinkDevVersion.m_jtagVer = n << 2 & 0x3C | n2 >> 6 & 3;
            sTLinkDevVersion.m_swimVer = n2 & 0x3F;
            n = byArray[3] & 0xFF;
            n2 = byArray[2] & 0xFF;
            sTLinkDevVersion.m_vendorId = (short)(n << 8 | n2);
            n = byArray[5] & 0xFF;
            n2 = byArray[4] & 0xFF;
            sTLinkDevVersion.m_productId = (short)(n << 8 | n2);
        }
        return l;
    }

    public long OpenStlink(int n, int n2, boolean bl) {
        long l = 0L;
        if (this.m_devHandle == -1L) {
            if (this.m_jni.IsNativeLoaded()) {
                long l2 = this.m_jni.GetNbDevices(n);
                if ((long)n2 >= l2) {
                    System.out.println("Bad ST-Link index (" + Long.toString(n2) + ">=" + Long.toString(l2) + ")");
                    l = 1L;
                } else {
                    long l3 = this.m_jni.GetDeviceInfo(n, n2, this.m_jniDevInfo);
                    if (l3 == 1L) {
                        l3 = this.m_jni.OpenDevice(n, n2, bl);
                    }
                    if (l3 == 1L) {
                        this.m_ifId = n;
                        this.m_devHandle = this.m_jni.GetLastOpenedDeviceHandle();
                    }
                    l = this.ConvertJniStatus(l3);
                }
            } else {
                System.out.println("JNI not loaded in OpendDevice");
                l = 2L;
            }
        }
        if (l == 0L && this.m_version == null) {
            this.m_version = new STLinkDevVersion();
            l = this.GetVersionCmd(this.m_version);
            if (l != 0L) {
                this.CloseStlink();
                l = 27L;
            }
        }
        return l;
    }

    public long CloseStlink() {
        long l = 0L;
        if (this.m_devHandle != -1L && this.m_jni.IsNativeLoaded()) {
            l = this.ConvertJniStatus(this.m_jni.CloseDevice(this.m_devHandle));
            this.m_devHandle = -1L;
        }
        this.m_version = null;
        return l;
    }

    public boolean IsStlinkOpened() {
        return this.m_devHandle != -1L;
    }

    public long GetCurrentMode() {
        byte[] byArray = new byte[2];
        this.m_devReq.m_cmd[0] = -11;
        for (int i = 1; i < 16; ++i) {
            this.m_devReq.m_cmd[i] = 0;
        }
        this.m_devReq.m_accessType = STLinkUSBDriverJni.STLINK_JNI_REQUEST_READ;
        this.m_devReq.m_data = byArray;
        this.m_devReq.m_dataLength = 2;
        long l = this.SendCmd(this.m_devHandle, this.m_timeout);
        if (l == 0L) {
            this.m_currentMode = byArray[0];
            if (this.m_currentMode == 0) {
                this.m_STLinkV2_DfuVer = byArray[1];
            }
        }
        return l;
    }

    public STLinkDevVersion GetVersion() {
        return this.m_version;
    }
}

