/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkinterface.jni;

import com.st.stlinkinterface.jni.STLinkDevInfo;
import com.st.stlinkinterface.jni.STLinkDevRequest;
import com.st.stlinkupgrade.app.STLinkIntegrationJava;
import java.io.File;
import java.net.URLDecoder;

public class STLinkUSBDriverJni {
    public static final int STLINK_JNI_OK = 1;
    public static final int STLINK_JNI_ERR = 4;
    public static final int STLINK_JNI_NO_DEVICE = 130;
    public static final int STLINK_JNI_INVALID_HANDLE = 129;
    public static final int STLINK_JNI_INIT_FAILED = 228;
    public static final int STLINK_JNI_MEMORY_ERR = 4096;
    public static final int STLINK_JNI_TIMEOUT = 4097;
    public static final int STLINK_JNI_BAD_PARAM = 4098;
    public static final int STLINK_JNI_OPEN_ERR = 4099;
    public static final int STLINK_JNI_TRANSFER_ERR = 4100;
    public static final int STLINK_JNI_NO_SUCH_INFO = 4176;
    public static final int STLINK_JNI_TRUNCATED_DATA = 4178;
    public static final int STLINK_JNI_CMD_NOT_AVAILABLE = 4179;
    public static final int STLINK_JNI_DEVICE_NOT_SUPPORTED = 4180;
    public static final int STLINK_JNI_PERMISSION_ERR = 4181;
    public static final int STLINK_JNI_FAILED = 8192;
    public static final int STLINK_JNI_SYSTEM_ERR_OFFSET = 65536;
    public static byte STLINK_JNI_REQUEST_WRITE = 0;
    public static byte STLINK_JNI_REQUEST_READ = 1;
    public static byte STLINK_JNI_REQUEST_SWV = (byte)3;
    private static boolean m_bIsLoaded = false;
    private boolean m_bIsWindows = false;
    private String m_platformName = null;

    public boolean LoadNativeCode(STLinkIntegrationJava sTLinkIntegrationJava) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "native" + File.separator;
        String string4 = System.getProperty("os.arch").toLowerCase();
        this.m_platformName = System.getProperty("os.name").toLowerCase();
        if (this.m_platformName.contains("win")) {
            this.m_bIsWindows = true;
            string3 = string3 + "win";
        } else if (this.m_platformName.contains("mac")) {
            bl = true;
            string3 = string3 + "mac";
        } else if (this.m_platformName.contains("nix") || this.m_platformName.contains("nux") || this.m_platformName.indexOf("aix") > 0) {
            bl2 = true;
            string3 = string3 + "linux";
        } else if (this.m_platformName.contains("sunos")) {
            bl3 = true;
            string3 = string3 + "linux";
        } else {
            sTLinkIntegrationJava.DisplayError("Platform not supported (" + this.m_platformName + ")");
            return false;
        }
        switch (string4) {
            case "i386": 
            case "x86": {
                string3 = string3 + "_x86";
                if (this.m_bIsWindows) {
                    string = "STLinkUSBDriver.dll";
                    break;
                }
                if (!bl2) break;
                string = "libSTLinkUSBDriver.so";
                break;
            }
            case "amd64": 
            case "x64": 
            case "x86_64": {
                string3 = string3 + "_x64";
                if (this.m_bIsWindows) {
                    string = "STLinkUSBDriver.dll";
                    break;
                }
                if (bl) {
                    string = "libSTLinkUSBDriver.dylib";
                    break;
                }
                if (!bl2) break;
                string = "libSTLinkUSBDriver.so";
                break;
            }
            default: {
                sTLinkIntegrationJava.DisplayError("Architecture not supported (" + string4 + ")");
                return false;
            }
        }
        string3 = string3 + File.separator;
        if (string == null) {
            sTLinkIntegrationJava.DisplayError("Native library not available for the current platform (" + this.m_platformName + " " + string4 + ")");
            return false;
        }
        boolean bl4 = true;
        String string5 = System.getProperty("user.dir");
        string2 = string5 + File.separator + string3 + string;
        File file = new File(string2);
        if (!file.exists()) {
            try {
                String string6 = STLinkUSBDriverJni.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String string7 = URLDecoder.decode(string6, "UTF-8");
                string5 = new File(string7).getParentFile().getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = string5 + File.separator + string3 + string;
            file = new File(string2);
            if (!file.exists()) {
                bl4 = false;
                sTLinkIntegrationJava.DisplayError(string2 + " not found. Check the installation of the application.");
                return false;
            }
        }
        if (bl4) {
            try {
                System.load(string2);
            }
            catch (Exception exception) {
                sTLinkIntegrationJava.DisplayError("Exception caught =" + exception.getMessage());
                return false;
            }
            m_bIsLoaded = true;
        }
        return true;
    }

    public boolean IsNativeLoaded() {
        return m_bIsLoaded;
    }

    public boolean IsWindows() {
        return this.m_bIsWindows;
    }

    public String GetPlatformName() {
        return this.m_platformName;
    }

    public native long Reenumerate(int var1, boolean var2);

    public native long GetNbDevices(int var1);

    public native long GetDeviceInfo(int var1, int var2, STLinkDevInfo var3);

    public native long OpenDevice(int var1, int var2, boolean var3);

    public native long GetLastOpenedDeviceHandle();

    public native long CloseDevice(long var1);

    public native long SendCommand(long var1, STLinkDevRequest var3, long var4);

    public native long FreeLibrary();
}

