/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.app;

import com.st.stlinkinterface.STLinkDevVersion;
import com.st.stlinkinterface.jni.STLinkDevInfo;
import com.st.stlinkupgrade.app.CmdLineParams;
import com.st.stlinkupgrade.core.STLinkUpgrade;
import com.st.stlinkupgrade.core.SystemParam;
import com.st.stlinkupgrade.gui.STLinkUpgradeGui;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class STLinkIntegrationJava {
    protected List<STLinkUpgrade> m_devList = new ArrayList<STLinkUpgrade>();
    protected long m_nbDevices = 0L;
    protected SystemParam m_userParams;
    protected CmdLineParams m_cmdLineParams;
    protected STLinkUpgradeGui m_mainDlg;
    protected int m_progressRange;
    protected int m_progressPos;

    public void launch(String[] stringArray) {
        long l = 0L;
        this.m_cmdLineParams = new CmdLineParams();
        this.m_cmdLineParams.Parse(stringArray);
        if (!STLinkUpgrade.LoadNativeCode(this)) {
            System.exit(0);
        }
        this.m_userParams = new SystemParam();
        this.EnumDevices();
        if (this.m_nbDevices == -1L) {
            l = 28L;
        }
        if (this.IsConsoleMode()) {
            if (l == 0L) {
                l = this.m_cmdLineParams.CheckAndAffect(this, this.m_userParams);
            }
            STLinkUpgrade sTLinkUpgrade = null;
            if (l == 0L) {
                if (this.m_nbDevices == 0L || this.m_devList.size() <= 0) {
                    this.DisplayError("No ST-Link detected");
                    l = 28L;
                } else {
                    sTLinkUpgrade = this.m_devList.get(0);
                    if (this.m_nbDevices > 1L) {
                        this.DisplayError("Caution: " + this.m_nbDevices + " detected. The upgrade will apply to the first one in the list.");
                    }
                    l = this.ConnectStlink(sTLinkUpgrade);
                }
            }
            if (l == 0L && sTLinkUpgrade != null) {
                l = this.ProgramFirmware(0);
                if (l == 0L) {
                    if (!this.IsConsoleMode()) {
                        this.m_mainDlg.SetProgressBar(this.m_progressRange);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(STLinkIntegrationJava.class.getName()).log(Level.SEVERE, null, interruptedException);
                        }
                        this.m_mainDlg.SetProgressBar(-1);
                    } else {
                        this.DisplayError("Upgrade is successful.");
                    }
                }
                if ((l = this.LeaveUpgradeMode(0)) != 0L) {
                    this.DisplayError("Failure exiting upgrade mode (Error " + l + ").");
                }
            }
            if (sTLinkUpgrade != null) {
                sTLinkUpgrade.CloseDevice();
            }
            STLinkUpgrade.FreeResources();
            System.exit(0);
        } else {
            this.m_mainDlg = new STLinkUpgradeGui();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    STLinkIntegrationJava.this.m_mainDlg.CreateDialog(STLinkIntegrationJava.this);
                }
            });
        }
    }

    public void DisplayError(String string) {
        if (this.IsConsoleMode()) {
            System.out.println(string);
        } else if (this.m_mainDlg == null) {
            System.out.println(string);
            JOptionPane.showMessageDialog(null, string);
        } else {
            this.m_mainDlg.DisplayError(string);
        }
    }

    public boolean IsConsoleMode() {
        return this.m_cmdLineParams.IsConsoleMode();
    }

    public void SetProgressRange(int n) {
        if (!this.IsConsoleMode()) {
            this.m_progressRange = n;
            this.m_progressPos = 0;
            this.m_mainDlg.SetProgressBarRange(n);
            this.m_mainDlg.SetProgressBar(0);
        }
    }

    public void Step() {
        if (this.IsConsoleMode()) {
            System.out.print('.');
        } else {
            ++this.m_progressPos;
            if (this.m_progressPos > this.m_progressRange) {
                this.m_progressPos = this.m_progressRange;
            }
            this.m_mainDlg.SetProgressBar(this.m_progressPos);
        }
    }

    public long ConnectStlink(STLinkUpgrade sTLinkUpgrade) {
        long l = 0L;
        if (sTLinkUpgrade == null) {
            this.DisplayError("Internal error when conected device (null object)");
            return 20L;
        }
        if (l == 0L) {
            sTLinkUpgrade.CloseDevice();
            l = sTLinkUpgrade.OpenInUpgradeMode(sTLinkUpgrade.GetUniqueId(), this.IsConsoleMode(), this.m_cmdLineParams.GetFirmwareType(), this.m_cmdLineParams.IsForceProg());
        }
        return l;
    }

    public long GetNbDevices() {
        return this.m_nbDevices;
    }

    public STLinkUpgrade GetDevice(int n) {
        return this.m_devList.get(n);
    }

    public long ProgramFirmware(int n) {
        STLinkUpgrade sTLinkUpgrade;
        long l = 20L;
        boolean bl = true;
        if (this.m_devList.size() > n && (sTLinkUpgrade = this.m_devList.get(n)) != null) {
            bl = false;
            l = sTLinkUpgrade.ProgramFirmware();
        }
        if (bl && l == 20L) {
            this.DisplayError("Internal error: Bad device selection index (" + n + ")");
        }
        return l;
    }

    public long SetFirmwTypeToProgram(int n, int n2) {
        STLinkUpgrade sTLinkUpgrade;
        long l = 20L;
        boolean bl = true;
        if (this.m_devList.size() > n && (sTLinkUpgrade = this.m_devList.get(n)) != null) {
            sTLinkUpgrade.SetUpToDateVersion(n2);
            bl = false;
            l = sTLinkUpgrade.SetFirmwareTypeToProgram(n2);
        }
        if (bl && l == 20L) {
            this.DisplayError("Internal error: Bad device selection index (" + n + ")");
        }
        return l;
    }

    public long LeaveUpgradeMode(int n) {
        STLinkUpgrade sTLinkUpgrade;
        long l = 20L;
        if (this.m_devList.size() > n && (sTLinkUpgrade = this.m_devList.get(n)) != null && (l = sTLinkUpgrade.LeaveUpgradeMode()) == 0L && this.IsConsoleMode()) {
            STLinkDevVersion sTLinkDevVersion = sTLinkUpgrade.GetFirmwareVersion();
            this.DisplayError("Version read: " + sTLinkDevVersion.m_majorVer + "." + sTLinkDevVersion.m_jtagVer + "." + sTLinkDevVersion.m_swimVer);
        }
        return l;
    }

    public void EnumDevices() {
        ArrayList<STLinkUpgrade> arrayList = new ArrayList<STLinkUpgrade>();
        this.m_nbDevices = STLinkUpgrade.EnumDevices();
        int n = this.m_devList.size();
        int n2 = 0;
        while ((long)n2 < this.m_nbDevices) {
            boolean bl = false;
            STLinkDevInfo sTLinkDevInfo = STLinkUpgrade.GetDeviceInfo(n2);
            if (sTLinkDevInfo != null) {
                for (int i = 0; i < n; ++i) {
                    if (!sTLinkDevInfo.m_enumUniqueID.equals(this.m_devList.get(i).GetUniqueId())) continue;
                    arrayList.add(this.m_devList.get(i));
                    this.m_devList.get(i).SetUsed(sTLinkDevInfo.m_deviceUsed);
                    bl = true;
                    break;
                }
                if (!bl) {
                    STLinkUpgrade sTLinkUpgrade = new STLinkUpgrade(this, this.m_userParams);
                    sTLinkUpgrade.SetUniqueId(sTLinkDevInfo.m_enumUniqueID);
                    String string = sTLinkDevInfo.m_productId == 14148 ? "ST-LINK" : (sTLinkDevInfo.m_productId == 14152 ? "ST-LINK/V2" : (sTLinkDevInfo.m_productId == 14154 || sTLinkDevInfo.m_productId == 14155 ? "ST-LINK/V2-1" : "ST-LINK (too recent)"));
                    sTLinkUpgrade.SetUsed(sTLinkDevInfo.m_deviceUsed);
                    sTLinkUpgrade.SetDisplayedName(string);
                    arrayList.add(sTLinkUpgrade);
                }
            }
            ++n2;
        }
        this.m_devList = arrayList;
    }
}

