/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.core;

import com.st.stlinkinterface.STLinkDevVersion;
import com.st.stlinkinterface.jni.STLinkDevInfo;
import com.st.stlinkinterface.jni.STLinkUSBDriverJni;
import com.st.stlinkupgrade.app.STLinkIntegrationJava;
import com.st.stlinkupgrade.core.Aes_Encryption;
import com.st.stlinkupgrade.core.STLinkDeviceDfu;
import com.st.stlinkupgrade.core.STLinkV1DiskImage;
import com.st.stlinkupgrade.core.SystemParam;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class STLinkUpgrade {
    public static final int FIRMWARE_TYPE_UNKNOWN = 0;
    public static final int FIRMWARE_TYPE_VIRGIN = 1;
    public static final int FIRMWARE_TYPE_STM32_DBG = 2;
    public static final int FIRMWARE_TYPE_STM8_DBG = 3;
    public static final int FIRMWARE_TYPE_STM8_STM32_DBG = 4;
    public static final int FIRMWARE_TYPE_STM32_DBG_MSD_VCP = 5;
    public static final int FIRMWARE_TYPE_STM32_DBG_IF2 = 6;
    protected static final int FIRMWARE_MAJOR_VER_OLD_STLINK = 1;
    protected static final int FIRMWARE_JTAG_VER_OLD_STLINK = 13;
    protected static final int FIRMWARE_SWIM_VER_OLD_STLINK = 3;
    protected static final int FIRMWARE_MAJOR_VER_STLINK_V2 = 2;
    protected static final int FIRMWARE_JTAG_VER_STLINK_V2 = 24;
    protected static final int FIRMWARE_SWIM_VER_STLINK_V2 = 4;
    protected static final int FIRMWARE_MBED_VER = 11;
    protected static final int FIRMWARE_AUDIO_VER = 1;
    public static final int FIRMWARE_JTAG_VER_FOR_PROTOS = 63;
    protected final int FLASH_PAGE_SIZE = 1024;
    protected final int FIRMWARE_PROG_FLAG_VAL = -1526716461;
    protected int ALLOW_CHANGING_FIRMWARE_TYPE = 0;
    protected STLinkIntegrationJava m_parentApp;
    protected static STLinkUSBDriverJni m_stlinkJni = new STLinkUSBDriverJni();
    protected STLinkDeviceDfu m_device;
    protected static long m_nbEnumeratedDev = 0L;
    protected int m_FirmwareType;
    protected int m_FirmwareTypeToProgram;
    protected STLinkDevVersion m_upToDateVersion;
    protected STLinkDevVersion m_detectedVersion;
    protected SystemParam m_sysParams;
    protected String m_enumUniqueId = "";
    protected boolean m_opened;
    protected boolean m_updateInProgress;
    protected String m_displayName = "ST-Link";
    protected boolean m_bInUse;
    protected int m_availableFlashSize = 0;
    protected int m_movedUsbLoaderSize = 0;

    public STLinkUpgrade(STLinkIntegrationJava sTLinkIntegrationJava, SystemParam systemParam) {
        this.m_parentApp = sTLinkIntegrationJava;
        this.m_device = new STLinkDeviceDfu(m_stlinkJni);
        this.m_FirmwareType = 0;
        this.m_FirmwareTypeToProgram = 0;
        this.m_sysParams = systemParam;
        this.m_opened = false;
        this.m_updateInProgress = false;
        this.m_bInUse = false;
    }

    public void CloseDevice() {
        this.m_device.CloseStlink();
    }

    public static boolean LoadNativeCode(STLinkIntegrationJava sTLinkIntegrationJava) {
        return m_stlinkJni.LoadNativeCode(sTLinkIntegrationJava);
    }

    public static void FreeResources() {
        if (m_stlinkJni.IsNativeLoaded()) {
            m_stlinkJni.FreeLibrary();
        }
    }

    private void DisplayError(String string) {
        this.m_parentApp.DisplayError(string);
    }

    public static long EnumDevices() {
        long l;
        int n = 0;
        m_nbEnumeratedDev = 0L;
        if (m_stlinkJni.IsNativeLoaded() && ((l = m_stlinkJni.Reenumerate(n, false)) == 1L || l == 4181L)) {
            m_nbEnumeratedDev = m_stlinkJni.GetNbDevices(n);
            return m_nbEnumeratedDev;
        }
        return -1L;
    }

    public static STLinkDevInfo GetDeviceInfo(int n) {
        int n2 = 0;
        STLinkDevInfo sTLinkDevInfo = null;
        if ((long)n < m_nbEnumeratedDev && m_stlinkJni.IsNativeLoaded()) {
            sTLinkDevInfo = new STLinkDevInfo();
            m_stlinkJni.GetDeviceInfo(n2, n, sTLinkDevInfo);
        }
        return sTLinkDevInfo;
    }

    public STLinkDevVersion GetFirmwareVersion() {
        if (this.m_device.IsStlinkOpened()) {
            return this.m_detectedVersion;
        }
        return null;
    }

    public STLinkDevVersion GetFirmwareUpToDateVersion() {
        return this.m_upToDateVersion;
    }

    public int GetFirmwareType() {
        return this.m_FirmwareType;
    }

    public long OpenInUpgradeMode(String string, boolean bl, int n, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        STLinkDevInfo sTLinkDevInfo = null;
        this.m_opened = false;
        if (string == null) {
            return 20L;
        }
        n2 = 0;
        while (!((long)n2 >= m_nbEnumeratedDev || (sTLinkDevInfo = STLinkUpgrade.GetDeviceInfo(n2)) != null && sTLinkDevInfo.m_enumUniqueID.equals(string))) {
            ++n2;
        }
        if ((long)n2 >= m_nbEnumeratedDev) {
            this.DisplayError("Can not find device on system with ID = " + string);
            return 20L;
        }
        long l = this.m_device.OpenStlink(n3, n2, true);
        if (l != 0L) {
            if (l == 29L) {
                String string2 = "";
                if (sTLinkDevInfo != null && sTLinkDevInfo.m_productId == 14148) {
                    string2 = " (ST-Link/V1";
                    if (m_stlinkJni.GetPlatformName() != null) {
                        string2 = string2 + " on " + m_stlinkJni.GetPlatformName();
                    }
                    string2 = string2 + ")";
                }
                this.DisplayError("ST-Link board not supported on the current platform" + string2);
            } else if (l == 30L) {
                this.DisplayError("Access to ST-Link was denied by the system. Ensure it is not already in use, and that you have enough rights.");
            } else {
                this.DisplayError("Error connecting to device " + this.toString() + " (error 0x" + Long.toHexString(l) + "); check the USB connection and refresh the device list");
            }
        } else {
            STLinkDevVersion sTLinkDevVersion = this.m_device.GetVersion();
            l = this.m_device.GetCurrentMode();
            if (l == 0L && !this.m_device.IsDfuMode() && (sTLinkDevVersion.m_majorVer > 2 || sTLinkDevVersion.m_majorVer == 2 && sTLinkDevVersion.m_jtagVer >= 18)) {
                l = this.m_device.GoToUsbLoader();
                if (l == 0L) {
                    l = this.m_device.GetCurrentMode();
                } else if (l == 2L) {
                    this.DisplayError("ST-Link DLL error. Check software installation.");
                } else if (l == 4L) {
                    this.DisplayError("No ST-Link found after GoToUsbLoader command. Wait for the end of USB enumeration then try again.");
                } else if (l == 25L) {
                    this.DisplayError("Error in GoToUsbLoader command. Ensure the hardware is recent enough for the software. Try to restart it.");
                } else if (l == 27L) {
                    this.DisplayError("Error after GoToUsbLoader command. Ensure the hardware is recent enough for the software. Try to restart it.");
                } else if (l == 26L) {
                    l = 0L;
                } else if (l == 30L) {
                    this.DisplayError("Access to ST-Link was denied by the system. Ensure it is not already in use, and that you have enough rights.");
                } else if (l == 31L) {
                    this.DisplayError("Error during ST-Link devices enumeration. Check the USB connection and refresh the device list.");
                } else {
                    this.DisplayError("Unexpected error during opening (" + l + ").");
                }
            }
        }
        if (l == 0L) {
            if (!this.m_device.IsDfuMode()) {
                this.DisplayError("ST-Link is not in the DFU mode. Please restart it.");
                l = 25L;
                this.CloseDevice();
            } else {
                l = this.m_device.GetDevInfo();
            }
        }
        if (l == 0L) {
            this.m_availableFlashSize = this.m_device.GetFlashSizeKb();
            if (this.m_availableFlashSize < 64) {
                this.DisplayError("Unexpected flash size for ST-Link micro. Don't know how to upgrade.");
                l = 28L;
            }
            if (this.m_device.GetDfuVersion() >= 2) {
                this.m_device.GetBootInfo();
                if ((this.m_device.GetBootFlags() & 1) == 1) {
                    this.m_availableFlashSize = 128;
                }
                this.m_movedUsbLoaderSize = (this.m_device.GetBootFlags() & 2) == 2 ? 20480 : 0;
            }
            this.m_sysParams.SetVolumeNameRequired(false);
            switch (this.m_device.m_versionFlag & 0xFF) {
                case 255: {
                    this.m_FirmwareType = 1;
                    break;
                }
                case 74: {
                    this.m_FirmwareType = 2;
                    break;
                }
                case 83: {
                    this.m_FirmwareType = 3;
                    break;
                }
                case 77: {
                    this.m_FirmwareType = 4;
                    break;
                }
                case 66: {
                    this.m_FirmwareType = 5;
                    break;
                }
                case 65: {
                    this.m_FirmwareType = 6;
                }
            }
            if (this.ALLOW_CHANGING_FIRMWARE_TYPE == 1) {
                this.m_FirmwareType = 1;
            }
            if (this.m_device.GetVersion().m_productId == 14155 && this.m_device.GetVersion().m_jtagVer == 63) {
                this.m_FirmwareType = 5;
            }
            if (this.m_device.GetVersion().m_productId != 14148 && this.m_device.GetDfuVersion() != 1 && this.m_device.GetDfuVersion() != 2) {
                this.DisplayError("Old firmware loader detected on ST-Link/V2.\r\nFor full operation (especially SWV support), please contact ST for upgrading.");
                l = 28L;
            }
        }
        if (l == 0L) {
            if (this.m_FirmwareType == 0) {
                this.DisplayError("The content of the ST-Link is corrupt.");
                l = 28L;
            } else {
                this.m_detectedVersion = this.m_device.GetVersion();
                if (this.m_FirmwareType == 1) {
                    this.m_detectedVersion.m_majorVer = 0;
                    this.m_detectedVersion.m_jtagVer = 0;
                    this.m_detectedVersion.m_swimVer = 0;
                    if (bl) {
                        if (n == 0) {
                            this.DisplayError("ST-Link is blank. You must choose which firmware to program.");
                            l = 28L;
                        } else {
                            this.m_FirmwareType = n;
                        }
                    }
                } else if (bl && this.m_FirmwareType != n && n != 0 && this.m_detectedVersion.m_jtagVer != 63) {
                    this.DisplayError("The specified firmware type does not match the detected one: can not update.");
                    l = 28L;
                }
                this.m_upToDateVersion = this.ComputeUpToDateVersion(this.m_FirmwareType);
                if (bl && this.m_detectedVersion != null && !bl2 && (this.m_FirmwareType == 2 && this.m_detectedVersion.m_jtagVer >= this.m_upToDateVersion.m_jtagVer || this.m_FirmwareType == 3 && this.m_detectedVersion.m_swimVer >= this.m_upToDateVersion.m_swimVer || (this.m_FirmwareType == 4 || this.m_FirmwareType == 5 || this.m_FirmwareType == 6) && this.m_detectedVersion.m_jtagVer >= this.m_upToDateVersion.m_jtagVer && this.m_detectedVersion.m_swimVer >= this.m_upToDateVersion.m_swimVer)) {
                    this.DisplayError("Detected firmware is up to date; use -force_prog to enforce reprogramming.");
                    l = 28L;
                }
            }
        }
        if (l == 0L) {
            this.m_opened = true;
        }
        return l;
    }

    protected STLinkDevVersion ComputeUpToDateVersion(int n) {
        STLinkDevVersion sTLinkDevVersion = new STLinkDevVersion();
        int n2 = n;
        if (n == 1 || n == 0) {
            n2 = this.m_FirmwareType;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.m_device.GetVersion() != null) {
            sTLinkDevVersion.m_vendorId = this.m_device.GetVersion().m_vendorId;
            sTLinkDevVersion.m_productId = this.m_device.GetVersion().m_productId;
            if (sTLinkDevVersion.m_productId == 14148) {
                sTLinkDevVersion.m_majorVer = 1;
                n3 = 13;
                n4 = 3;
            } else {
                sTLinkDevVersion.m_majorVer = 2;
                n3 = 24;
                n4 = 4;
            }
        }
        switch (n2) {
            case 0: 
            case 1: {
                sTLinkDevVersion.m_jtagVer = 0;
                sTLinkDevVersion.m_swimVer = 0;
                break;
            }
            case 2: {
                sTLinkDevVersion.m_jtagVer = n3;
                sTLinkDevVersion.m_swimVer = 0;
                break;
            }
            case 3: {
                sTLinkDevVersion.m_jtagVer = 0;
                sTLinkDevVersion.m_swimVer = n4;
                break;
            }
            case 4: {
                sTLinkDevVersion.m_jtagVer = n3;
                sTLinkDevVersion.m_swimVer = n4;
                break;
            }
            case 5: {
                sTLinkDevVersion.m_jtagVer = n3;
                sTLinkDevVersion.m_swimVer = 11;
                break;
            }
            case 6: {
                sTLinkDevVersion.m_jtagVer = n3;
                sTLinkDevVersion.m_swimVer = 1;
            }
        }
        return sTLinkDevVersion;
    }

    public void SetUpToDateVersion(int n) {
        this.m_upToDateVersion = this.ComputeUpToDateVersion(n);
    }

    protected long DecipherAndProgramData(BufferedInputStream bufferedInputStream, long l, long l2, int n) {
        long l3 = 0L;
        byte[] byArray = new byte[n];
        long l4 = 0L;
        long l5 = 0L;
        try {
            while (l4 < l && l3 == 0L) {
                l5 = bufferedInputStream.read(byArray);
                if (l5 == -1L) continue;
                l3 = this.DecipherAndProgramData(byArray, l2 + l4, n);
                l4 += l5;
            }
        }
        catch (IOException iOException) {
            this.DisplayError("Failure reading file: " + iOException.getMessage());
            return 28L;
        }
        return l3;
    }

    protected long DecipherAndProgramData(byte[] byArray, long l, int n) {
        long l2 = 0L;
        byte[] byArray2 = new byte[4 * ((byArray.length + 3) / 4)];
        byte[] byArray3 = new byte[16];
        Aes_Encryption.StrKeyToByteChar("best performance", byArray3);
        Aes_Encryption.STlinkPCaes_Decry_Api(byArray, byArray2, byArray3, byArray.length);
        int n2 = 0;
        int n3 = byArray2.length;
        while (n3 > 0 && l2 == 0L) {
            int n4 = n3 > n ? n : n3;
            byte[] byArray4 = Arrays.copyOfRange(byArray2, n2, n2 + n4);
            l2 = this.m_device.Download(l, byArray4, n4);
            this.m_parentApp.Step();
            l += (long)n4;
            n3 -= n4;
            n2 += n4;
        }
        return l2;
    }

    public long ProgramFirmware() {
        byte[] byArray;
        int n = this.m_FirmwareTypeToProgram;
        long l = 0L;
        boolean bl = this.m_device.GetVersion().m_productId == 14148;
        int n2 = -1;
        byte[] byArray2 = new byte[2];
        BufferedInputStream bufferedInputStream = null;
        long l2 = 0L;
        if (n == 1 || n == 0) {
            n = this.m_FirmwareType;
        } else if (n != this.m_FirmwareType && this.m_FirmwareType != 1) {
            this.DisplayError("Can not change the type of firmware from " + this.m_FirmwareType + " to " + n);
            return 28L;
        }
        byArray2[0] = (byte)(this.m_upToDateVersion.m_majorVer << 4 & 0xF0 | this.m_upToDateVersion.m_jtagVer >> 2 & 0xF);
        byArray2[1] = (byte)(this.m_upToDateVersion.m_jtagVer << 6 & 0xC0 | this.m_upToDateVersion.m_swimVer & 0x3F);
        String string = null;
        switch (n) {
            case 2: {
                n2 = 74;
                if (bl) {
                    string = "f1_1.bin";
                    break;
                }
                string = "f2_1.bin";
                break;
            }
            case 3: {
                n2 = 83;
                if (bl) {
                    string = "f1_2.bin";
                    break;
                }
                string = "f2_2.bin";
                break;
            }
            case 4: {
                n2 = 77;
                if (bl) {
                    string = "f1_3.bin";
                    break;
                }
                string = "f2_3.bin";
                break;
            }
            case 5: {
                n2 = 66;
                string = "f2_4.bin";
                if (this.m_FirmwareType != 1) break;
                this.m_sysParams.SetVolumeNameRequired(true);
                break;
            }
            case 6: {
                n2 = 65;
                string = "f2_5.bin";
            }
        }
        if (string == null) {
            this.DisplayError("Can not find data for upgrade.");
            return 28L;
        }
        l2 = 0L;
        try {
            bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
            while (true) {
                int n3 = -1;
                try {
                    n3 = bufferedInputStream.read();
                }
                catch (IOException iOException) {
                    this.DisplayError("Failure opening file " + string + ": " + iOException.getMessage());
                    n3 = -1;
                }
                if (n3 == -1) break;
                ++l2;
            }
            bufferedInputStream.close();
            bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
        }
        catch (IOException iOException) {
            this.DisplayError("Failure getting firmware data");
        }
        if (l2 == 0L) {
            return 28L;
        }
        if (l2 > (long)((this.m_availableFlashSize - 1) * 1024 - 16384 - this.m_movedUsbLoaderSize)) {
            long l3 = l2 - (long)((this.m_availableFlashSize - 1) * 1024) + 16384L + (long)this.m_movedUsbLoaderSize;
            this.DisplayError("The up-to-date firmware is too big for this board (" + l3 + " bytes in excess). Can't update.");
            return 28L;
        }
        this.m_updateInProgress = true;
        int n4 = 3072;
        long l4 = l2 == 0L ? 0L : 1L + (l2 - 1L) / (long)n4;
        long l5 = 0L;
        if (bl && STLinkV1DiskImage.data.length > 0) {
            l5 = 1 + (STLinkV1DiskImage.data.length - 1) / n4;
        }
        this.m_parentApp.SetProgressRange((int)(l4 + l5 + 3L));
        byte[] byArray3 = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            byArray3[i] = -1;
        }
        long l6 = 0x8000000 + this.m_availableFlashSize * 1024 - 4;
        l = this.m_device.Download(l6 - 12L, byArray3, 16L);
        if (l == 0L) {
            this.m_parentApp.Step();
            l = this.DecipherAndProgramData(bufferedInputStream, l2, 0x8004000L, n4);
        }
        if (l == 0L && bl) {
            l = this.DecipherAndProgramData(STLinkV1DiskImage.data, 0x800D000L, n4);
        }
        if (l != 0L) {
            this.DisplayError("Upgrade Error, Please try again.");
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.DisplayError("Failure closing file: " + iOException.getMessage());
            }
        }
        if (l == 0L) {
            byArray = new byte[16];
            Aes_Encryption.StrKeyToByteChar("What are you doing", byArray);
            Aes_Encryption.STlinkPCaes_Encry_Api(this.m_device.m_UniqueID, byArray3, byArray, this.m_device.m_UniqueID.length);
            byArray3[32] = n2;
            byArray3[1022] = byArray2[0];
            byArray3[1023] = byArray2[1];
            l = this.m_sysParams.GetInitialDataFromDevice(this.m_device);
            if (l != 0L) {
                this.DisplayError("Error getting previous values of parameters (USB max current, volume name).");
            }
        }
        if (l == 0L) {
            byArray = this.m_sysParams.GetSysParamsToProgram();
            System.arraycopy(byArray, 0, byArray3, 48, byArray.length);
            l = this.m_device.Download(134233088L, byArray3, 1024L);
            if (l != 0L) {
                this.DisplayError("Upgrade Error, Please try again.");
            }
            this.m_parentApp.Step();
        }
        if (l == 0L) {
            for (int i = 0; i < 12; ++i) {
                byArray3[i] = -1;
            }
            ByteBuffer.wrap(byArray3).order(ByteOrder.LITTLE_ENDIAN).putInt(12, -1526716461);
            l = this.m_device.Download(l6 - 12L, byArray3, 16L);
            if (l != 0L) {
                this.DisplayError("Upgrade Error, Please try again.");
            }
            this.m_parentApp.Step();
        }
        this.m_updateInProgress = false;
        return l;
    }

    public long LeaveUpgradeMode() {
        if (this.m_device != null && this.m_device.IsStlinkOpened()) {
            long l = this.m_device.DfuExit();
            if (l == 0L) {
                this.m_detectedVersion = this.m_device.GetVersion();
            }
            this.m_opened = false;
            return l;
        }
        return 0L;
    }

    public void SetUniqueId(String string) {
        this.m_enumUniqueId = string;
    }

    public String GetUniqueId() {
        return this.m_enumUniqueId;
    }

    public boolean IsConnected() {
        return this.m_opened;
    }

    public boolean IsUpdating() {
        return this.m_updateInProgress;
    }

    public void SetUsed(boolean bl) {
        this.m_bInUse = bl;
    }

    public void SetDisplayedName(String string) {
        this.m_displayName = string;
    }

    public String toString() {
        if (this.m_bInUse) {
            return this.m_displayName + " (in use)";
        }
        return this.m_displayName;
    }

    public long SetFirmwareTypeToProgram(int n) {
        this.m_FirmwareTypeToProgram = n;
        return 0L;
    }
}

