/*
 * Decompiled with CFR 0.152.
 */
package com.st.stlinkupgrade.gui;

import com.st.stlinkinterface.STLinkDevVersion;
import com.st.stlinkupgrade.app.STLinkIntegrationJava;
import com.st.stlinkupgrade.core.STLinkUpgrade;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class STLinkUpgradeGui
extends JFrame {
    protected STLinkIntegrationJava m_mainApp;
    protected JButton m_setUpdateModeBtn;
    protected JButton m_upgradeBtn;
    protected JButton m_refreshBtn;
    protected JLabel m_detectedFirmwareVersion;
    protected JLabel m_lastFirmwareVersion;
    protected JLabel m_uniqueId;
    protected JComboBox<STLinkUpgrade> m_DevSelCombo;
    protected boolean m_bComboSelectByUser = true;
    protected JProgressBar m_progressBar;
    protected JProgressBar m_connectProgressIndicator;
    protected JLabel m_statusMsg;
    protected JRadioButton m_rbStm32;
    protected JRadioButton m_rbStm8;
    protected JRadioButton m_rbStm32Stm8;
    protected JRadioButton m_rbStm32Msd;
    protected JRadioButton m_rbStm32Audio;

    public void CreateDialog(STLinkIntegrationJava sTLinkIntegrationJava) {
        Object object;
        Accessible accessible;
        this.m_mainApp = sTLinkIntegrationJava;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = 0;
                while ((long)n < STLinkUpgradeGui.this.m_mainApp.GetNbDevices()) {
                    STLinkUpgradeGui.this.m_mainApp.GetDevice(n).CloseDevice();
                    ++n;
                }
                System.exit(0);
            }
        });
        this.setTitle("STLinkUpgrade 3.0.3");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            this.m_mainApp.DisplayError("Kept default look and feel");
        }
        URL uRL = this.getClass().getResource("icon.png");
        if (uRL != null) {
            accessible = new ImageIcon(uRL);
            this.setIconImage(((ImageIcon)accessible).getImage());
        }
        this.m_setUpdateModeBtn = new JButton();
        this.m_setUpdateModeBtn.setText("Open in update mode");
        this.m_setUpdateModeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgradeGui.this.ClearErrorMsg();
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    STLinkUpgradeGui.this.m_connectProgressIndicator.setIndeterminate(true);
                    STLinkUpgradeGui.this.m_connectProgressIndicator.setVisible(true);
                    STLinkUpgradeGui.this.GuiConnectStlink(sTLinkUpgrade);
                }
            }
        });
        this.m_upgradeBtn = new JButton();
        this.m_upgradeBtn.setText("Upgrade");
        this.m_upgradeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgradeGui.this.ClearErrorMsg();
                final int n = STLinkUpgradeGui.this.m_DevSelCombo.getSelectedIndex();
                if (n >= 0) {
                    int n2 = 0;
                    if (STLinkUpgradeGui.this.m_rbStm32.isSelected()) {
                        n2 = 2;
                    }
                    if (STLinkUpgradeGui.this.m_rbStm8.isSelected()) {
                        n2 = 3;
                    }
                    if (STLinkUpgradeGui.this.m_rbStm32Stm8.isSelected()) {
                        n2 = 4;
                    }
                    if (STLinkUpgradeGui.this.m_rbStm32Msd.isSelected()) {
                        n2 = 5;
                    }
                    if (STLinkUpgradeGui.this.m_rbStm32Audio.isSelected()) {
                        n2 = 6;
                    }
                    STLinkUpgradeGui.this.m_mainApp.SetFirmwTypeToProgram(n, n2);
                    STLinkUpgradeGui.this.m_upgradeBtn.setEnabled(false);
                    STLinkUpgradeGui.this.SetFirmwareTypeVisible(false);
                    STLinkUpgradeGui.this.m_setUpdateModeBtn.setEnabled(false);
                    STLinkUpgradeGui.this.m_refreshBtn.setEnabled(false);
                    STLinkUpgradeGui.this.m_DevSelCombo.setEnabled(false);
                    final SwingWorker<Long, Void> swingWorker = new SwingWorker<Long, Void>(){

                        @Override
                        protected Long doInBackground() throws Exception {
                            long l = STLinkUpgradeGui.this.m_mainApp.ProgramFirmware(n);
                            return l;
                        }

                        @Override
                        public void done() {
                            long l = 28L;
                            try {
                                l = (Long)this.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                STLinkUpgradeGui.this.m_mainApp.DisplayError("Can't get result from programming task");
                            }
                            STLinkUpgradeGui.this.m_progressBar.setVisible(false);
                            if (l == 0L) {
                                l = STLinkUpgradeGui.this.m_mainApp.LeaveUpgradeMode(n);
                                STLinkUpgradeGui.this.m_upgradeBtn.setEnabled(false);
                                STLinkUpgradeGui.this.SetFirmwareTypeVisible(false);
                                STLinkUpgradeGui.this.m_setUpdateModeBtn.setEnabled(true);
                                STLinkUpgradeGui.this.m_detectedFirmwareVersion.setText(STLinkUpgradeGui.this.m_lastFirmwareVersion.getText());
                                if (l != 0L) {
                                    if (l == 4L) {
                                        STLinkUpgradeGui.this.m_mainApp.DisplayError("ST-Link device lost when exiting upgrade mode.");
                                    } else {
                                        STLinkUpgradeGui.this.m_mainApp.DisplayError("Failure exiting upgrade mode (Error " + l + ").");
                                    }
                                } else {
                                    STLinkUpgradeGui.this.m_mainApp.DisplayError("Upgrade successful.");
                                }
                            }
                            STLinkUpgradeGui.this.m_refreshBtn.setEnabled(true);
                            STLinkUpgradeGui.this.m_DevSelCombo.setEnabled(true);
                        }
                    };
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Thread thread = new Thread(swingWorker);
                            thread.start();
                        }
                    });
                }
            }
        });
        this.m_refreshBtn = new JButton();
        this.m_refreshBtn.setText("Refresh device list");
        this.m_refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgradeGui.this.ClearErrorMsg();
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                String string = sTLinkUpgrade == null ? null : sTLinkUpgrade.GetUniqueId();
                STLinkUpgradeGui.this.m_mainApp.EnumDevices();
                STLinkUpgradeGui.this.FillComboList();
                STLinkUpgradeGui.this.SelectDevice(string);
            }
        });
        accessible = new JLabel("Firmware version: ");
        this.m_detectedFirmwareVersion = new JLabel("");
        JLabel jLabel = new JLabel("Last firmware version: ");
        this.m_lastFirmwareVersion = new JLabel("");
        JLabel jLabel2 = new JLabel("ST-Link ID: ");
        this.m_uniqueId = new JLabel("");
        this.m_DevSelCombo = new JComboBox();
        this.FillComboList();
        this.m_DevSelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (STLinkUpgradeGui.this.m_bComboSelectByUser) {
                    STLinkUpgradeGui.this.ClearErrorMsg();
                }
                if ((n = STLinkUpgradeGui.this.m_DevSelCombo.getSelectedIndex()) >= 0) {
                    STLinkUpgrade sTLinkUpgrade = STLinkUpgradeGui.this.m_mainApp.GetDevice(n);
                    STLinkUpgradeGui.this.UpdateGuiAfterDevSel(sTLinkUpgrade);
                }
            }
        });
        this.m_DevSelCombo.setMinimumSize(new Dimension(150, 0));
        this.m_DevSelCombo.setMaximumSize(new Dimension(500, 30));
        this.m_DevSelCombo.setPreferredSize(new Dimension(150, 30));
        if (this.m_DevSelCombo.getItemCount() > 0) {
            this.m_DevSelCombo.setSelectedIndex(0);
        }
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setVisible(false);
        this.m_connectProgressIndicator = new JProgressBar();
        this.m_connectProgressIndicator.setMaximumSize(new Dimension(30, 15));
        this.m_connectProgressIndicator.setVisible(false);
        this.m_statusMsg = new JLabel("");
        ButtonGroup buttonGroup = new ButtonGroup();
        Dimension dimension = new Dimension(150, 300);
        this.m_rbStm32 = new JRadioButton("STM32 only");
        this.m_rbStm32.setMaximumSize(dimension);
        buttonGroup.add(this.m_rbStm32);
        this.m_rbStm32.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    sTLinkUpgrade.SetUpToDateVersion(2);
                    STLinkUpgradeGui.this.m_lastFirmwareVersion.setText(STLinkUpgradeGui.this.FormatVersion(2, sTLinkUpgrade.GetFirmwareUpToDateVersion()));
                }
            }
        });
        this.m_rbStm8 = new JRadioButton("STM8 only");
        this.m_rbStm8.setMaximumSize(dimension);
        buttonGroup.add(this.m_rbStm8);
        this.m_rbStm8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    sTLinkUpgrade.SetUpToDateVersion(3);
                    STLinkUpgradeGui.this.m_lastFirmwareVersion.setText(STLinkUpgradeGui.this.FormatVersion(3, sTLinkUpgrade.GetFirmwareUpToDateVersion()));
                }
            }
        });
        this.m_rbStm32Stm8 = new JRadioButton("STM32+STM8");
        this.m_rbStm32Stm8.setMaximumSize(dimension);
        buttonGroup.add(this.m_rbStm32Stm8);
        this.m_rbStm32Stm8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    sTLinkUpgrade.SetUpToDateVersion(4);
                    STLinkUpgradeGui.this.m_lastFirmwareVersion.setText(STLinkUpgradeGui.this.FormatVersion(4, sTLinkUpgrade.GetFirmwareUpToDateVersion()));
                }
            }
        });
        this.m_rbStm32Msd = new JRadioButton("STM32+MSD+VCP");
        this.m_rbStm32Msd.setMaximumSize(dimension);
        buttonGroup.add(this.m_rbStm32Msd);
        this.m_rbStm32Msd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    sTLinkUpgrade.SetUpToDateVersion(5);
                    STLinkUpgradeGui.this.m_lastFirmwareVersion.setText(STLinkUpgradeGui.this.FormatVersion(5, sTLinkUpgrade.GetFirmwareUpToDateVersion()));
                }
            }
        });
        this.m_rbStm32Audio = new JRadioButton("STM32+Audio");
        this.m_rbStm32Audio.setMaximumSize(dimension);
        buttonGroup.add(this.m_rbStm32Audio);
        this.m_rbStm32Audio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                STLinkUpgrade sTLinkUpgrade = (STLinkUpgrade)STLinkUpgradeGui.this.m_DevSelCombo.getSelectedItem();
                if (sTLinkUpgrade != null) {
                    sTLinkUpgrade.SetUpToDateVersion(6);
                    STLinkUpgradeGui.this.m_lastFirmwareVersion.setText(STLinkUpgradeGui.this.FormatVersion(6, sTLinkUpgrade.GetFirmwareUpToDateVersion()));
                }
            }
        });
        int n = 5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel.add(this.m_DevSelCombo);
        jPanel.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel.add(this.m_refreshBtn);
        jPanel.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel2.add(this.m_setUpdateModeBtn);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel2.add(this.m_connectProgressIndicator);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel3.add(jLabel2);
        jPanel3.add(this.m_uniqueId);
        jPanel3.setAlignmentX(0.0f);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel4.add((Component)((Object)accessible));
        jPanel4.add(this.m_detectedFirmwareVersion);
        jPanel4.setAlignmentX(0.0f);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel5.add(jLabel);
        jPanel5.add(this.m_lastFirmwareVersion);
        jPanel5.setAlignmentX(0.0f);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel6.add(this.m_upgradeBtn);
        jPanel6.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel6.add(this.m_progressBar);
        jPanel6.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel6.setAlignmentX(0.0f);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel7.add(this.m_statusMsg);
        jPanel7.setAlignmentX(0.0f);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(3, 2));
        jPanel8.add(this.m_rbStm32);
        jPanel8.add(this.m_rbStm8);
        jPanel8.add(this.m_rbStm32Stm8);
        jPanel8.add(this.m_rbStm32Msd);
        jPanel8.add(this.m_rbStm32Audio);
        JLabel jLabel3 = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("stm32.jpg");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage != null) {
                object = bufferedImage.getScaledInstance(300, -1, 4);
                jLabel3 = new JLabel(new ImageIcon((Image)object));
            }
        }
        catch (IOException iOException) {
            this.m_mainApp.DisplayError("Failure loading image.");
        }
        int n2 = 10;
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel2);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel3);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel4);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel5);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, n2)));
        ((Container)object).add(jPanel6);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        if (jLabel3 != null) {
            jLabel3.setAlignmentX(0.0f);
            jPanel9.add((Component)jLabel3, "North");
        }
        jPanel9.add((Component)jPanel8, "South");
        jPanel9.setAlignmentX(0.0f);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)object, "Center");
        jPanel10.add((Component)jPanel9, "East");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)jPanel10, "North");
        jPanel11.add((Component)jPanel7, "South");
        this.add(jPanel11);
        this.m_upgradeBtn.setEnabled(false);
        this.SetFirmwareTypeVisible(false);
        if (this.m_mainApp.GetNbDevices() > 0L) {
            this.m_setUpdateModeBtn.setEnabled(true);
        } else {
            this.m_setUpdateModeBtn.setEnabled(false);
        }
        this.pack();
        Dimension dimension2 = ((Component)((Object)accessible)).getSize();
        Dimension dimension3 = jLabel.getSize();
        int n3 = Math.max(dimension2.width, dimension3.width);
        Dimension dimension4 = new Dimension(n3, dimension2.height);
        Dimension dimension5 = new Dimension(n3, dimension3.height);
        ((Component)((Object)accessible)).setSize(dimension4);
        ((JComponent)((Object)accessible)).setMaximumSize(dimension4);
        jLabel.setSize(dimension5);
        jLabel.setMaximumSize(dimension5);
        this.pack();
        Dimension dimension6 = this.getSize();
        dimension6.height += 40;
        this.setMinimumSize(dimension6);
        this.setMaximumSize(new Dimension(dimension6.width + 200, dimension6.height + 50));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void SetFirmwareTypeVisible(boolean bl) {
        if (this.m_rbStm32 != null) {
            this.m_rbStm32.setVisible(bl);
            this.m_rbStm8.setVisible(bl);
            this.m_rbStm32Stm8.setVisible(bl);
            this.m_rbStm32Msd.setVisible(bl);
            this.m_rbStm32Audio.setVisible(bl);
            if (!bl) {
                this.m_rbStm32.setSelected(false);
                this.m_rbStm8.setSelected(false);
                this.m_rbStm32Stm8.setSelected(false);
                this.m_rbStm32Msd.setSelected(false);
                this.m_rbStm32Audio.setSelected(false);
            }
        }
    }

    protected void FillComboList() {
        this.m_DevSelCombo.removeAllItems();
        int n = 0;
        while ((long)n < this.m_mainApp.GetNbDevices()) {
            this.m_DevSelCombo.addItem(this.m_mainApp.GetDevice(n));
            ++n;
        }
    }

    protected void SelectDevice(String string) {
        STLinkUpgrade sTLinkUpgrade = null;
        if (string != null) {
            int n = 0;
            while ((long)n < this.m_mainApp.GetNbDevices()) {
                STLinkUpgrade sTLinkUpgrade2 = this.m_mainApp.GetDevice(n);
                if (string.equals(sTLinkUpgrade2.GetUniqueId())) {
                    this.m_DevSelCombo.setSelectedIndex(n);
                    sTLinkUpgrade = sTLinkUpgrade2;
                }
                ++n;
            }
        }
        if (sTLinkUpgrade == null && this.m_DevSelCombo.getItemCount() > 0) {
            this.m_DevSelCombo.setSelectedIndex(0);
            sTLinkUpgrade = (STLinkUpgrade)this.m_DevSelCombo.getSelectedItem();
            if (string != null) {
                this.DisplayError("Device " + string + " not found. Selecting first one in the list.");
            }
        }
        if (sTLinkUpgrade == null && string != null) {
            this.DisplayError("Device " + string + " not found. No device connected.");
        }
        this.UpdateGuiAfterDevSel(sTLinkUpgrade);
    }

    protected void UpdateGuiAfterDevSel(STLinkUpgrade sTLinkUpgrade) {
        if (sTLinkUpgrade == null) {
            this.m_DevSelCombo.setSelectedIndex(-1);
            this.m_setUpdateModeBtn.setEnabled(false);
            this.m_upgradeBtn.setEnabled(false);
            this.m_detectedFirmwareVersion.setText("");
            this.m_lastFirmwareVersion.setText("");
            this.m_uniqueId.setText("");
            this.SetFirmwareTypeVisible(false);
            if (this.m_progressBar != null) {
                this.m_progressBar.setVisible(false);
            }
        } else {
            if (sTLinkUpgrade.IsUpdating()) {
                this.m_setUpdateModeBtn.setEnabled(false);
                if (this.m_progressBar != null) {
                    this.m_progressBar.setVisible(true);
                }
            } else {
                this.m_setUpdateModeBtn.setEnabled(true);
                if (this.m_progressBar != null) {
                    this.m_progressBar.setVisible(false);
                }
            }
            this.m_uniqueId.setText(sTLinkUpgrade.GetUniqueId());
            if (!sTLinkUpgrade.IsConnected() || sTLinkUpgrade.IsUpdating()) {
                this.m_upgradeBtn.setEnabled(false);
            } else {
                this.m_upgradeBtn.setEnabled(true);
            }
            this.m_lastFirmwareVersion.setText(this.FormatVersion(sTLinkUpgrade.GetFirmwareType(), sTLinkUpgrade.GetFirmwareUpToDateVersion()));
            this.m_detectedFirmwareVersion.setText(this.FormatVersion(sTLinkUpgrade.GetFirmwareType(), sTLinkUpgrade.GetFirmwareVersion()));
            if (sTLinkUpgrade.GetFirmwareType() == 1) {
                this.SetFirmwareTypeVisible(true);
            } else {
                this.SetFirmwareTypeVisible(false);
            }
        }
    }

    protected char GetFirmwareIdentChar(int n) {
        char c = 'S';
        if (n == 6) {
            c = 'A';
        }
        if (n == 5) {
            c = 'M';
        }
        return c;
    }

    public String FormatVersion(int n, STLinkDevVersion sTLinkDevVersion) {
        if (sTLinkDevVersion == null) {
            return "Unknown";
        }
        if (n == 1 || n == 0) {
            return "V0J0S0";
        }
        return "V" + sTLinkDevVersion.m_majorVer + "J" + sTLinkDevVersion.m_jtagVer + this.GetFirmwareIdentChar(n) + sTLinkDevVersion.m_swimVer;
    }

    public void SetProgressBarRange(int n) {
        if (this.m_progressBar != null) {
            this.m_progressBar.setMaximum(n);
            this.m_progressBar.setValue(0);
            this.m_progressBar.setIndeterminate(false);
            this.m_progressBar.setVisible(true);
        }
    }

    public void SetProgressBar(final int n) {
        if (this.m_progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (n >= 0) {
                        STLinkUpgradeGui.this.m_progressBar.setVisible(true);
                        STLinkUpgradeGui.this.m_progressBar.setValue(n);
                    } else {
                        STLinkUpgradeGui.this.m_progressBar.setVisible(false);
                    }
                }
            });
        }
    }

    protected void GuiConnectStlink(final STLinkUpgrade sTLinkUpgrade) {
        if (sTLinkUpgrade != null) {
            final String string = sTLinkUpgrade.GetUniqueId();
            final SwingWorker<Long, Void> swingWorker = new SwingWorker<Long, Void>(){

                @Override
                protected Long doInBackground() throws Exception {
                    long l = STLinkUpgradeGui.this.m_mainApp.ConnectStlink(sTLinkUpgrade);
                    return l;
                }

                @Override
                public void done() {
                    long l = 28L;
                    try {
                        l = (Long)this.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        STLinkUpgradeGui.this.m_mainApp.DisplayError("Can't get result from connecting task");
                    }
                    STLinkUpgradeGui.this.m_connectProgressIndicator.setVisible(false);
                    STLinkUpgradeGui.this.m_mainApp.EnumDevices();
                    STLinkUpgradeGui.this.m_bComboSelectByUser = false;
                    STLinkUpgradeGui.this.FillComboList();
                    STLinkUpgradeGui.this.SelectDevice(string);
                    STLinkUpgradeGui.this.m_bComboSelectByUser = true;
                    if (l == 0L) {
                        STLinkUpgradeGui.this.m_upgradeBtn.setEnabled(true);
                    } else {
                        STLinkUpgradeGui.this.m_upgradeBtn.setEnabled(false);
                    }
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Thread thread = new Thread(swingWorker);
                    thread.start();
                }
            });
        }
    }

    private void ClearErrorMsg() {
        if (this.m_statusMsg != null) {
            this.m_statusMsg.setText("");
        }
    }

    public void DisplayError(final String string) {
        if (this.m_statusMsg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String string2 = STLinkUpgradeGui.this.m_statusMsg.getText();
                    if (string2.equals("")) {
                        STLinkUpgradeGui.this.m_statusMsg.setText(string);
                    } else {
                        STLinkUpgradeGui.this.m_statusMsg.setText("<html>" + string2 + "<BR>" + string + "</html>");
                    }
                }
            });
        }
    }
}

