uniform sampler2DRect	samplerA;
//uniform sampler2DRect	edgeSampler;
uniform sampler3D		lut;
//uniform float			lutGridSize;

uniform float			saturationAmt;
uniform float			brightnessAmt;
uniform float			contrastAmt;

vec3 adjust(vec3 color, float brightness, float saturation, float contrast)
{	
	// WARNING: adjust() also exists in reflection2.fp

	const vec3 lumCoeff 	= 	vec3(0.2125, 0.7154, 0.0721);
	vec3 brightnessColor 	= 	color * brightness;
	vec3 intensity 			= 	vec3(dot(brightnessColor, lumCoeff));
	vec3 saturationColor 	= 	mix(intensity, brightnessColor, saturation);
	vec3 finalColor	 		= 	mix(vec3(0.5), saturationColor, contrast);
	return finalColor;
}

void main()
{
	vec4			color		=	texture2DRect(samplerA, vec2(gl_TexCoord[0]));
	vec4			edge		=	vec4(1.0); // texture2DRect(edgeSampler, vec2(gl_TexCoord[1]));
	vec3			corrected	=	texture3D(lut, color.bgr).rgb;
	vec3			meColor		=	adjust(corrected, brightnessAmt, saturationAmt, contrastAmt);

	gl_FragColor	=	 vec4(meColor, color.a) * edge * gl_Color;
}
