uniform sampler2DRect tex1;
uniform sampler2D tex2;
uniform sampler2DRect tex3;
uniform float time;
uniform float height;
uniform float width;

void main()
{
    vec2 cord1 = gl_TexCoord[0].st; 
    cord1.x = cord1.x / width;
    cord1.y = cord1.y / height;

	vec4 col2 =  texture2D(tex2, cord1);

	vec2 c2;
	c2.x = 0.0; 
	c2.y = col2.x * col2.x * col2.x * (time * height) + (time * height);
    
    vec2 cord = gl_TexCoord[0].st + c2.xy; 

	vec4 col1 =  texture2DRect(tex1, cord);
	vec4 col3 =  texture2DRect(tex3, gl_TexCoord[0].st);

    if (cord.y > (height - 2.0))
    {
        // New picture
		float alpha = ((cord.y - (height - 2.0)) / 2.0);		
        col1 = col1 * (1.0 - alpha) + col3 * alpha;
    }

    if (cord.y > height)
    {
        // New picture
        col1 = col3;
    }

	gl_FragColor = col1;
}

