uniform sampler2DRect	samplerA;
varying float			nomY;
uniform float			offset;
uniform float			hq_offset_y;

uniform float			saturationAmt;
uniform float			brightnessAmt;
uniform float			contrastAmt;

vec3 adjust(vec3 color, float brightness, float saturation, float contrast)
{	
	// WARNING: adjust() also exists in colorAdjustments.fs
	
	const vec3 lumCoeff 	= 	vec3(0.2125, 0.7154, 0.0721);
	vec3 brightnessColor 	= 	color * brightness;
	vec3 intensity 			= 	vec3(dot(brightnessColor, lumCoeff));
	vec3 saturationColor 	= 	mix(intensity, brightnessColor, saturation);
	vec3 finalColor	 		= 	mix(vec3(0.5), saturationColor, contrast);
	return finalColor;
}

void main()
{
	float			blend		=	(nomY - offset) * nomY;
	vec4			color		=	texture2DRect(samplerA, vec2(gl_TexCoord[0]));
	vec3			meColor		=	adjust(color.rgb, brightnessAmt, saturationAmt, contrastAmt);
	
	gl_FragColor = vec4(meColor, color.a) * blend * gl_Color;
}
