/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.SunGraphicsEnvironment;

public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient long pNativeFont;
    private transient int numGlyphs = -1;
    private transient int missingGlyph = -1;
    private transient int canRotate = -1;
    private transient double[] matrix;
    private static final long serialVersionUID = -4206021311591459213L;
    private int fontSerializedDataVersion = 1;
    private static final String systemBundle = "java.text.resources.LocaleElements";

    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name, this.style);
        }
        return this.peer;
    }

    private void initializeFont(Hashtable hashtable) {
        if (this.name == null) {
            this.name = "Default";
        }
        if (hashtable == null) {
            this.fRequestedAttributes = new Hashtable(5, 0.9f);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, new TransformAttribute(new AffineTransform()));
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            if ((this.style & 1) != 0) {
                this.fRequestedAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if ((this.style & 2) != 0) {
                this.fRequestedAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        } else {
            this.fRequestedAttributes = Font.ffApply(this.style, (Map)hashtable);
        }
        SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = sunGraphicsEnvironment.mapFamilyName(this.name, this.style);
        NativeFontWrapper.initializeFont((Font)this, (String)string, (int)this.style);
    }

    public Font(String string, int n, int n2) {
        this.name = string;
        this.style = n;
        this.size = n2;
        this.pointSize = n2;
        this.initializeFont(null);
    }

    private Font(String string, int n, float f) {
        this.name = string;
        this.style = n;
        this.size = (int)((double)f + 0.5);
        this.pointSize = f;
        this.initializeFont(null);
    }

    public Font(Map map) {
        this.pointSize = 12.0f;
        this.size = 12;
        if (map != null && !map.equals(EMPTY_MAP)) {
            this.fRequestedAttributes = new Hashtable(map);
            Object object = map.get(TextAttribute.FAMILY);
            if (object != null) {
                this.name = (String)object;
            }
            if ((object = map.get(TextAttribute.WEIGHT)) != null && object.equals(TextAttribute.WEIGHT_BOLD)) {
                this.style |= 1;
            }
            if ((object = map.get(TextAttribute.POSTURE)) != null && object.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((object = map.get(TextAttribute.SIZE)) != null) {
                this.pointSize = ((Float)object).floatValue();
                this.size = (int)((double)this.pointSize + 0.5);
            }
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return new Font(map);
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        if (n != 0) {
            throw new IllegalArgumentException("font format not recognized");
        }
        File file = null;
        file = File.createTempFile("font", ".ttf", null);
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        int n2 = 0;
        int n3 = 8192;
        byte[] byArray = new byte[n3];
        while (n2 != -1) {
            n2 = bufferedInputStream.read(byArray, 0, n3);
            if (n2 == -1) continue;
            fileOutputStream.write(byArray, 0, n2);
        }
        SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = SunGraphicsEnvironment.createFont((File)file);
        if (string == null) {
            throw new FontFormatException("Unable to create font - bad font data");
        }
        Font font = new Font(string, 0, 1);
        return font;
    }

    public AffineTransform getTransform() {
        Object object = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
        if (object != null) {
            if (object instanceof TransformAttribute) {
                return ((TransformAttribute)object).getTransform();
            }
            if (object instanceof AffineTransform) {
                return new AffineTransform((AffineTransform)object);
            }
        } else {
            object = new AffineTransform();
        }
        return (AffineTransform)object;
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFamily(Locale locale) {
        short s = this.getLcidFromLocale(locale);
        return NativeFontWrapper.getFamilyName((Font)this, (short)s);
    }

    public String getPSName() {
        return this.getFontName();
    }

    public String getName() {
        return new String(this.name);
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getFontName(Locale locale) {
        short s = this.getLcidFromLocale(locale);
        return NativeFontWrapper.getFullName((Font)this, (short)s);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        String string2 = string;
        int n = 12;
        int n2 = 0;
        if (string == null) {
            return new Font("dialog", n2, n);
        }
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            string = string.substring(n3 + 1);
            int n4 = (string = string.toLowerCase()).indexOf("bold-italic");
            if (n4 != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string.indexOf("bolditalic")) != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n4 == -1 && (n4 = string.indexOf("italic")) != -1) {
                n2 = 2;
            }
            if ((n4 = string.lastIndexOf("-")) != -1) {
                string = string.substring(n4 + 1);
            }
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n3 == -1) {
            n2 = 0;
            n = 12;
            int n5 = (string = string.toLowerCase()).indexOf("bolditalic");
            if (n5 != -1) {
                n2 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bold italic")) != -1) {
                n2 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n5 == -1 && (n5 = string.indexOf("italic")) != -1) {
                n2 = 2;
            }
            if (n5 != -1) {
                string2 = string2.substring(0, n5);
                string2 = string2.trim();
            }
            if ((n5 = string.lastIndexOf(" ")) != -1) {
                String string3 = string.substring(n5);
                string3 = string3.trim();
                try {
                    n = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new Font(string2, n2, n);
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                double[] dArray = this.getMatrix();
                double[] dArray2 = font.getMatrix();
                return this.size == font.size && this.pointSize == font.pointSize && this.style == font.style && this.name.equals(font.name) && dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3];
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = NativeFontWrapper.getNumGlyphs((Font)this);
        }
        return this.numGlyphs;
    }

    public int getMissingGlyphCode() {
        if (this.missingGlyph == -1) {
            this.missingGlyph = NativeFontWrapper.getMissingGlyphCode((Font)this);
        }
        return this.missingGlyph;
    }

    private double[] getMatrix() {
        if (this.matrix == null) {
            float f = this.getSize2D();
            AffineTransform affineTransform = this.getTransform();
            affineTransform.scale(f, f);
            this.matrix = new double[]{affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY()};
        }
        return this.matrix;
    }

    public byte getBaselineFor(char c) {
        return NativeFontWrapper.getBaselineFor((Font)this, (char)c);
    }

    public Map getAttributes() {
        return (Map)this.fRequestedAttributes.clone();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE};
        return attributeArray;
    }

    public Font deriveFont(int n, float f) {
        return new Font(Font.ffApply(n, (Map)Font.ffApply(f, (Map)this.fRequestedAttributes)));
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        return new Font(Font.ffApply(n, (Map)Font.ffApply(affineTransform, (Map)this.fRequestedAttributes)));
    }

    public Font deriveFont(float f) {
        return new Font(Font.ffApply(f, (Map)this.fRequestedAttributes));
    }

    public Font deriveFont(AffineTransform affineTransform) {
        return new Font(Font.ffApply(affineTransform, (Map)this.fRequestedAttributes));
    }

    public Font deriveFont(int n) {
        return new Font(Font.ffApply(n, (Map)this.fRequestedAttributes));
    }

    public Font deriveFont(Map map) {
        Hashtable hashtable = new Hashtable(this.getAttributes());
        AttributedCharacterIterator.Attribute[] attributeArray = this.getAvailableAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            Object object = map.get(attributeArray[n]);
            if (object != null) {
                hashtable.put(attributeArray[n], object);
            }
            ++n;
        }
        return new Font(hashtable);
    }

    public boolean canDisplay(char c) {
        return NativeFontWrapper.canDisplay((Font)this, (char)c);
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        while (n < n2 && this.canDisplay(cArray[n])) {
            ++n;
        }
        return n;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        char c = characterIterator.setIndex(n);
        while (characterIterator.getIndex() < n2 && this.canDisplay(c)) {
            c = characterIterator.next();
        }
        return characterIterator.getIndex();
    }

    public float getItalicAngle() {
        double[] dArray = this.getMatrix();
        return NativeFontWrapper.getItalicAngle((Font)this, (double[])dArray, (boolean)false, (boolean)false);
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = new FontLineMetrics();
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics((Font)this, (double[])dArray, (boolean)fontRenderContext.isAntiAliased(), (boolean)fontRenderContext.usesFractionalMetrics(), (float[])fArray);
        fontLineMetrics.ascent = fArray[0];
        fontLineMetrics.descent = fArray[1];
        fontLineMetrics.leading = fArray[2];
        fontLineMetrics.height = fArray[0] + fArray[1] + fArray[2];
        fontLineMetrics.baselineIndex = 0;
        fontLineMetrics.baselineOffsets = new float[3];
        fontLineMetrics.baselineOffsets[0] = 0.0f;
        fontLineMetrics.strikethroughOffset = -(fontLineMetrics.ascent / 3.0f);
        fontLineMetrics.strikethroughThickness = this.pointSize / 12.0f;
        fontLineMetrics.underlineOffset = 0.0f;
        fontLineMetrics.underlineThickness = this.pointSize / 12.0f;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n, n2);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        boolean bl = true;
        int n3 = n;
        while (n3 < n2) {
            char c = cArray[n3];
            if (c >= '\u0590' && c <= '\u206f') {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n, n2 - n, fontRenderContext);
            return standardGlyphVector.getLogicalBounds();
        }
        String string = new String(cArray, n, n2 - n);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getAscent() + textLayout.getLeading());
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        if (n < n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > n4) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        char[] cArray = new char[n2 - n];
        characterIterator.setIndex(n);
        int n5 = 0;
        while (n5 < cArray.length) {
            cArray[n5] = characterIterator.current();
            characterIterator.next();
            ++n5;
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics((Font)this, (double[])dArray, (boolean)fontRenderContext.isAntiAliased(), (boolean)fontRenderContext.usesFractionalMetrics(), (float[])fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    private static Hashtable ffApply(String string, Map map) {
        Hashtable hashtable = new Hashtable(map);
        hashtable.put(TextAttribute.FAMILY, string);
        return hashtable;
    }

    private static Hashtable ffApply(AffineTransform affineTransform, Map map) {
        Hashtable hashtable = new Hashtable(map);
        hashtable.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        return hashtable;
    }

    private static Hashtable ffApply(int n, Map map) {
        Hashtable hashtable = new Hashtable(map);
        if ((n & 1) != 0) {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            hashtable.remove(TextAttribute.WEIGHT);
        }
        if ((n & 2) != 0) {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            hashtable.remove(TextAttribute.POSTURE);
        }
        return hashtable;
    }

    private static Hashtable ffApply(float f, Map map) {
        Hashtable hashtable = new Hashtable(map);
        hashtable.put(TextAttribute.SIZE, new Float(f));
        return hashtable;
    }

    private static Hashtable ffApply(String string, int n, float f, Map map) {
        return Font.ffApply(string, (Map)Font.ffApply(n, (Map)Font.ffApply(f, map)));
    }

    private static native void initIDs();

    private native void pDispose();

    protected void finalize() throws Throwable {
        if (this.peer != null) {
            this.pDispose();
        }
        super.finalize();
    }

    private short getLcidFromLocale(Locale locale) {
        String string;
        short s = 1033;
        if (locale.equals(Locale.US)) {
            return s;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(systemBundle, locale);
            string = resourceBundle.getString("LocaleID");
        }
        catch (MissingResourceException missingResourceException) {
            return s;
        }
        try {
            s = (short)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return s;
    }

    static {
        Toolkit.loadLibraries();
        Font.initIDs();
        EMPTY_MAP = new Hashtable(5, 0.9f);
    }

    private final class FontLineMetrics
    extends LineMetrics {
        int numchars;
        float ascent;
        float descent;
        float leading;
        float height;
        int baselineIndex;
        float[] baselineOffsets;
        float strikethroughOffset;
        float strikethroughThickness;
        float underlineOffset;
        float underlineThickness;

        private FontLineMetrics() {
        }

        public final int getNumChars() {
            return this.numchars;
        }

        public final float getAscent() {
            return this.ascent;
        }

        public final float getDescent() {
            return this.descent;
        }

        public final float getLeading() {
            return this.leading;
        }

        public final float getHeight() {
            return this.height;
        }

        public final int getBaselineIndex() {
            return this.baselineIndex;
        }

        public final float[] getBaselineOffsets() {
            return this.baselineOffsets;
        }

        public final float getStrikethroughOffset() {
            return this.strikethroughOffset;
        }

        public final float getStrikethroughThickness() {
            return this.strikethroughThickness;
        }

        public final float getUnderlineOffset() {
            return this.underlineOffset;
        }

        public final float getUnderlineThickness() {
            return this.underlineThickness;
        }

        public final boolean equals(Object object) {
            if (object != null) {
                if (this == object) {
                    return true;
                }
                try {
                    FontLineMetrics fontLineMetrics = (FontLineMetrics)object;
                    return this.ascent == fontLineMetrics.ascent && this.descent == fontLineMetrics.descent && this.leading == fontLineMetrics.leading && this.baselineIndex == fontLineMetrics.baselineIndex && this.baselineOffsets[0] == fontLineMetrics.baselineOffsets[0] && this.baselineOffsets[1] == fontLineMetrics.baselineOffsets[1] && this.baselineOffsets[2] == fontLineMetrics.baselineOffsets[2] && this.strikethroughOffset == fontLineMetrics.strikethroughOffset && this.strikethroughThickness == fontLineMetrics.strikethroughThickness && this.underlineOffset == fontLineMetrics.underlineOffset && this.underlineThickness == fontLineMetrics.underlineThickness;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

