/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    BufferedImageOp bufferedImageOp;
    ColorModel model;
    int width;
    int height;
    byte[] bytePixels;
    int[] intPixels;

    public BufferedImageFilter(BufferedImageOp bufferedImageOp) {
        this.bufferedImageOp = bufferedImageOp;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.bufferedImageOp;
    }

    public void setDimensions(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            this.imageComplete(3);
            return;
        }
        this.width = n;
        this.height = n2;
    }

    public void setColorModel(ColorModel colorModel) {
        this.model = colorModel;
    }

    private void convertToRGB() {
        int n = this.width * this.height;
        int[] nArray = new int[n];
        if (this.bytePixels != null) {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.model.getRGB(this.bytePixels[n2] & 0xFF);
                ++n2;
            }
        } else if (this.intPixels != null) {
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = this.model.getRGB(this.intPixels[n3]);
                ++n3;
            }
        }
        this.bytePixels = null;
        this.intPixels = nArray;
        this.model = ColorModel.getRGBdefault();
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        int n8;
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Width (" + n3 + ") and height (" + n4 + ") must be > 0");
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (n2 < 0) {
            n8 = -n2;
            if (n8 >= n4) {
                return;
            }
            n5 += n6 * n8;
            n2 += n8;
            n4 -= n8;
        }
        if (n2 + n4 > this.height && (n4 = this.height - n2) <= 0) {
            return;
        }
        if (n < 0) {
            n8 = -n;
            if (n8 >= n3) {
                return;
            }
            n5 += n8;
            n += n8;
            n3 -= n8;
        }
        if (n + n3 > this.width && (n3 = this.width - n) <= 0) {
            return;
        }
        n8 = n2 * this.width + n;
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.width * this.height];
                this.model = colorModel;
            } else if (this.model != colorModel) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                n7 = n4;
                while (n7 > 0) {
                    System.arraycopy(byArray, n5, this.bytePixels, n8, n3);
                    n5 += n6;
                    n8 += this.width;
                    --n7;
                }
            }
        }
        if (this.intPixels != null) {
            n7 = this.width - n3;
            int n9 = n6 - n3;
            int n10 = n4;
            while (n10 > 0) {
                int n11 = n3;
                while (n11 > 0) {
                    this.intPixels[n8++] = colorModel.getRGB(byArray[n5++] & 0xFF);
                    --n11;
                }
                n5 += n9;
                n8 += n7;
                --n10;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Width (" + n3 + ") and height (" + n4 + ") must be > 0");
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (n2 < 0) {
            n7 = -n2;
            if (n7 >= n4) {
                return;
            }
            n5 += n6 * n7;
            n2 += n7;
            n4 -= n7;
        }
        if (n2 + n4 > this.height && (n4 = this.height - n2) <= 0) {
            return;
        }
        if (n < 0) {
            n7 = -n;
            if (n7 >= n3) {
                return;
            }
            n5 += n7;
            n += n7;
            n3 -= n7;
        }
        if (n + n3 > this.width && (n3 = this.width - n) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.width * this.height];
                this.model = colorModel;
            } else {
                this.convertToRGB();
            }
        }
        n7 = n2 * this.width + n;
        if (this.model == colorModel) {
            int n8 = n4;
            while (n8 > 0) {
                System.arraycopy(nArray, n5, this.intPixels, n7, n3);
                n5 += n6;
                n7 += this.width;
                --n8;
            }
        } else {
            if (this.model != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int n9 = this.width - n3;
            int n10 = n6 - n3;
            int n11 = n4;
            while (n11 > 0) {
                int n12 = n3;
                while (n12 > 0) {
                    this.intPixels[n7++] = colorModel.getRGB(nArray[n5++]);
                    --n12;
                }
                n5 += n10;
                n7 += n9;
                --n11;
            }
        }
    }

    public void imageComplete(int n) {
        switch (n) {
            case 1: 
            case 4: {
                this.model = null;
                this.width = -1;
                this.height = -1;
                this.intPixels = null;
                this.bytePixels = null;
                break;
            }
            case 2: 
            case 3: {
                Object object;
                Object object2;
                WritableRaster writableRaster;
                if (this.width <= 0 || this.height <= 0) break;
                if (this.model instanceof DirectColorModel) {
                    if (this.intPixels == null) break;
                    writableRaster = this.createDCMraster();
                } else if (this.model instanceof IndexColorModel) {
                    object2 = new int[]{0};
                    if (this.bytePixels == null) break;
                    object = new DataBufferByte(this.bytePixels, this.width * this.height);
                    writableRaster = Raster.createInterleavedRaster((DataBuffer)object, this.width, this.height, this.width, 1, (int[])object2, null);
                } else {
                    this.convertToRGB();
                    if (this.intPixels == null) break;
                    writableRaster = this.createDCMraster();
                }
                object2 = new BufferedImage(this.model, writableRaster, this.model.isAlphaPremultiplied(), null);
                object2 = this.bufferedImageOp.filter((BufferedImage)object2, null);
                object = ((BufferedImage)object2).getRaster();
                ColorModel colorModel = ((BufferedImage)object2).getColorModel();
                int n2 = ((Raster)object).getWidth();
                int n3 = ((Raster)object).getHeight();
                this.consumer.setDimensions(n2, n3);
                this.consumer.setColorModel(colorModel);
                if (colorModel instanceof DirectColorModel) {
                    DataBufferInt dataBufferInt = (DataBufferInt)((Raster)object).getDataBuffer();
                    this.consumer.setPixels(0, 0, n2, n3, colorModel, dataBufferInt.getData(), 0, n2);
                    break;
                }
                if (colorModel instanceof IndexColorModel) {
                    DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
                    this.consumer.setPixels(0, 0, n2, n3, colorModel, dataBufferByte.getData(), 0, n2);
                    break;
                }
                throw new InternalError("Unknown color model " + colorModel);
            }
        }
        this.consumer.imageComplete(n);
    }

    private final WritableRaster createDCMraster() {
        DirectColorModel directColorModel = (DirectColorModel)this.model;
        boolean bl = this.model.hasAlpha();
        int[] nArray = new int[3 + (bl ? 1 : 0)];
        nArray[0] = directColorModel.getRedMask();
        nArray[1] = directColorModel.getGreenMask();
        nArray[2] = directColorModel.getBlueMask();
        if (bl) {
            nArray[3] = directColorModel.getAlphaMask();
        }
        DataBufferInt dataBufferInt = new DataBufferInt(this.intPixels, this.width * this.height);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, this.width, this.height, this.width, nArray, null);
        return writableRaster;
    }
}

