/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.Operation;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.server.RemoteProxy;

public class ActivatableRef
implements RemoteRef {
    protected ActivationID id;
    protected RemoteRef ref;
    transient boolean force = false;
    private static final int MAX_RETRIES = 3;
    private static final String versionComplaint = "activation requires 1.2 stubs";

    public ActivatableRef() {
    }

    public ActivatableRef(ActivationID activationID, RemoteRef remoteRef) {
        this.id = activationID;
        this.ref = remoteRef;
    }

    public static RemoteStub getStub(ActivationDesc activationDesc, ActivationID activationID) throws StubNotFoundException {
        String string = activationDesc.getClassName();
        try {
            Class<?> clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
            Class clazz2 = RemoteProxy.getRemoteClass(clazz);
            return RemoteProxy.getStub(clazz2.getName(), clazz2, new ActivatableRef(activationID, null));
        }
        catch (Exception exception) {
            throw new StubNotFoundException("unable to load class: " + string, exception);
        }
    }

    public Object invoke(Remote remote, Method method, Object[] objectArray, long l) throws Exception {
        RemoteRef remoteRef;
        boolean bl = false;
        RemoteException remoteException = null;
        ActivatableRef activatableRef = this;
        synchronized (activatableRef) {
            if (this.ref == null) {
                remoteRef = this.activate(bl);
                bl = true;
            } else {
                remoteRef = this.ref;
            }
        }
        int n = 3;
        while (n > 0) {
            try {
                return remoteRef.invoke(remote, method, objectArray, l);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                remoteException = noSuchObjectException;
            }
            catch (ConnectException connectException) {
                remoteException = connectException;
            }
            catch (UnknownHostException unknownHostException) {
                remoteException = unknownHostException;
            }
            catch (ConnectIOException connectIOException) {
                remoteException = connectIOException;
            }
            catch (MarshalException marshalException) {
                throw marshalException;
            }
            catch (ServerError serverError) {
                throw serverError;
            }
            catch (ServerException serverException) {
                throw serverException;
            }
            catch (RemoteException remoteException2) {
                ActivatableRef activatableRef2 = this;
                synchronized (activatableRef2) {
                    if (remoteRef == this.ref) {
                        this.ref = null;
                    }
                }
                throw remoteException2;
            }
            if (n > 1) {
                ActivatableRef activatableRef3 = this;
                synchronized (activatableRef3) {
                    if (remoteRef.equals(this.ref) || this.ref == null) {
                        RemoteRef remoteRef2 = this.activate(bl);
                        if (remoteRef2.equals(remoteRef) && remoteException instanceof NoSuchObjectException && !bl) {
                            remoteRef2 = this.activate(true);
                        }
                        remoteRef = remoteRef2;
                        bl = true;
                    } else {
                        remoteRef = this.ref;
                        bl = false;
                    }
                }
            }
            --n;
        }
        throw remoteException;
    }

    private synchronized RemoteRef getRef() throws RemoteException {
        if (this.ref == null) {
            this.ref = this.activate(false);
        }
        return this.ref;
    }

    private RemoteRef activate(boolean bl) throws RemoteException {
        this.ref = null;
        try {
            ActivatableRef activatableRef = (ActivatableRef)((RemoteStub)this.id.activate(bl)).getRef();
            this.ref = activatableRef.ref;
            return this.ref;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (UnknownObjectException unknownObjectException) {
            throw new NoSuchObjectException("activatable object no longer registered");
        }
        catch (Exception exception) {
            throw new ActivateFailedException("failed to activate object", exception);
        }
    }

    public synchronized RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n, long l) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        throw new UnsupportedOperationException(versionComplaint);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "ActivatableRef";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        RemoteRef remoteRef = this.ref;
        objectOutput.writeObject(this.id);
        if (remoteRef == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(remoteRef.getRefClass(objectOutput));
            remoteRef.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ActivationID)objectInput.readObject();
        this.ref = null;
        String string = objectInput.readUTF();
        if (string.equals("")) {
            return;
        }
        try {
            Class clazz = Class.forName("sun.rmi.server." + string);
            this.ref = (RemoteRef)clazz.newInstance();
            this.ref.readExternal(objectInput);
        }
        catch (InstantiationException instantiationException) {
            throw new UnmarshalException("Unable to create remote reference", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnmarshalException("Illegal access creating remote reference");
        }
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.id.hashCode();
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof ActivatableRef) {
            return this.id.equals((Object)((ActivatableRef)remoteRef).id);
        }
        return false;
    }
}

