﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Accessories.PayPlatformManage" CodeBehind="PayPlatformManage.aspx.cs" Title="在线支付平台管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <pe:ExtendedGridView ID="EgvPayPlatform" runat="server" AutoGenerateColumns="False"
        DataSourceID="OdsPayPlatform" DataKeyNames="PayPlatformId" OnRowCommand="EgvPayPlatform_RowCommand"
        ItemName="平台" ItemUnit="个" OnRowDataBound="EgvPayPlatform_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        RowDblclickBoundField="PayPlatformId" RowDblclickUrl="PayPlatform.aspx?Action=Modify&amp;ID={$Field}"
        SerialText="">
        <Columns>
            <pe:BoundField DataField="PayPlatformId" HeaderText="ID" SortExpression="PayPlatformId">
                <HeaderStyle Width="4%" />
            </pe:BoundField>
            <pe:BoundField DataField="PayPlatformName" HeaderText="名称" SortExpression="PayPlatformName">
            </pe:BoundField>
            <pe:BoundField DataField="AccountsId" HeaderText="商户ID" SortExpression="AccountsId">
                <HeaderStyle Width="20%" />
            </pe:BoundField>
            <pe:TemplateField SortExpression="Rate" HeaderText="手续费率">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# Eval("Rate") + "%"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="是否默认" SortExpression="Disabled">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDefault") == true ? "√":""%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="Disabled">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDisabled") == true ? "<font color=red>×</font>" : "<font color=green>√</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="23%" />
                <ItemTemplate>
                    <asp:HyperLink ID="HlnkApply" runat="server" Target="_blank">申请商户</asp:HyperLink>
                    <asp:LinkButton ID="LbtnSetDefault" runat="server" CommandName='<%# (bool)Eval("IsDefault") == false ? "SetDefault" : ""%>'
                        CommandArgument='<%# Eval("PayPlatformID") %>'>默认</asp:LinkButton>
                    <asp:LinkButton ID="LbtnDisabled" runat="server" CommandName='<%# (bool)Eval("IsDisabled")? "Enabled" : "Disabled"%>'
                        CommandArgument='<%# Eval("PayPlatformID") %>'><%# (bool)Eval("IsDisabled") == true ? "启用" : "禁用"%></asp:LinkButton>
                    <a href='<%# Eval("PayPlatformID","PayPlatform.aspx?Action=Modify&ID={0}") %>'>修改</a>
                    <asp:LinkButton ID="LbtnDel" CommandName="Del" CommandArgument='<%# Eval("PayPlatformId") %>'
                        runat="server">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="排序操作" SortExpression="Disabled">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    &nbsp;<asp:DropDownList ID="DropOrderId" runat="server">
                    </asp:DropDownList>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <asp:ObjectDataSource ID="OdsPayPlatform" runat="server" SelectCountMethod="Count"
        SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform"></asp:ObjectDataSource>
    <div style="text-align: center;">
        <asp:Button ID="BtnSaveSort" runat="server" OnClick="BtnSaveSort_Click" Text="保存排序" />
    </div>
    <br />
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        
        <a>支付宝最新1.5%费率接口说明</a>
        <a>删除支付接口说明</a>
        <a>添加新支付接口说明</a>
        <span class="right-line"></span></dt>  
        <dd class="prompt-note-con">
          <p>
            支付宝1.5%费率担保交易接口无需预付交易手续费，按照每笔交易1.5%的比例自动扣除手续费。 如果您希望在网店里体验使用支付宝进行收付款，但是又不想使用预付费或包量型的支付宝接口，那么1.5%费率的担保交易接口是您最好的选择！
        </p>
        </dd> 
        <dd class="prompt-note-con" style="display:none;">
          <p>
            系统内置的支付接口不允许删除，如果不使用的话，可以设置为“禁用”。“禁用”状态的支付接口，前台不会显示。
        </p>
        </dd>  
        <dd class="prompt-note-con" style="display:none;">
            <p>
                在支付平台管理中添加了新的支付平台后，还需要自己添加支付接口程序。</p>
            <p>
                添加新支付接口步骤说明：
                <li>添加平台：在支付平台管理中添加新的支付平台，注意添加后的平台ID，这个ID在程序中判断是哪个平台时会用到。</li>
                <li>添加发送接口程序：发送接口程序在PayOnline.aspx（网站目录/PayOnline/PayOnline.aspx）文件中，根据在线支付商提供的接口开发文档在该文件中添加对应的接口程序。</li>
                <li>添加接收接口程序：接收接口需要在PayOnline目录中添加一个新文件，在新文件中添加上接收程序，里面调用的方法可以参照系统内置支付平台的接收文件，如：快钱的接收文件（PayResult99bill.aspx）。</li>
            </p>
        </dd>  
        <div class="clearbox"></div>
        </dl>
    </div>
</asp:Content>
