﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="RssConfig.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Configuration.RssConfigUI"
    Title="RSS/WAP参数配置" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>RSS/WAP参数配置</strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 50%">
                <strong>是否启用RSS功能：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RssEnable" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    <asp:ListItem Selected="True" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用WAP功能：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="WapEnable" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                    <asp:ListItem Selected="True" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否开启WAP单独域名：</strong><br />
            </td>
            <td>
                <asp:RadioButtonList ID="RadWapSiteStatus" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>WAP域名：</strong>
            </td>
            <td>
                <asp:TextBox ID="txtWapSiteUrl" runat="server" Columns="30" Width="200px"></asp:TextBox>
                <pe:RegexValidator ValidateType="Url" ID="rvtxtWapSiteUrl" ControlToValidate="txtWapSiteUrl" runat="server"
                 Display="Dynamic" ErrorMessage="URL格式不对！"></pe:RegexValidator>
                例如：http://wap.powereasy.net/
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>生成WAP图片的大小（单位px）：</strong>
            </td>
            <td>
                高：<asp:TextBox ID="txtImageHeight" runat="server" Columns="30" Width="50px"></asp:TextBox>
                宽：<asp:TextBox ID="txtImageWidth" runat="server" Columns="30" Width="50px"></asp:TextBox>
            </td>
        </tr>
         <tr class="tdbg">
            <td class="tdbgleft">
                <strong>生成WAP图片的方式：</strong>
            </td>
            <td>
                <asp:DropDownList ID="dropThumbsMode" runat="server">
                    <asp:ListItem Text="指定高宽缩放" Value="0"></asp:ListItem>
                    <asp:ListItem Text="指定宽，高按比例" Value="1"></asp:ListItem>
                    <asp:ListItem Text="指定高，宽按比例" Value="2" Selected="True"></asp:ListItem>
                    <asp:ListItem Text="指定高宽裁减" Value="3"></asp:ListItem>
                    <asp:ListItem Text="补充法指定宽高" Value="4"></asp:ListItem>
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存设置" OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
