﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="SiteOption.aspx.cs" EnableEventValidation="false" Inherits="PowerEasy.Module.General.WebSite.Admin.Configuration.SiteOptionUI"
    Title="网站参数配置" ValidateRequest="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>网站参数配置</strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 45%">
                <strong>后台管理目录：</strong><br />
                为了安全，您可以在此修改后台管理目录名称，<br />
                为空时默认为Admin，实际文件夹名不需更改。<br />
                <span style="color: #FF0000">注意：目录名只能以字母、数字及下划线组成，<br />
                    且目录名不能与系统根目录下文件夹重名（除Admin外）。</span>
            </td>
            <td>
                <asp:TextBox ID="TxtManageDir" Text="Admin" MaxLength="20" TextMode="singleLine"
                    runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="ValeManageDir" runat="server" ControlToValidate="TxtManageDir"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
                <asp:RequiredFieldValidator ID="ValrManageDir" runat="server" ErrorMessage="请输入后台管理目录名"
                    ControlToValidate="TxtManageDir"></asp:RequiredFieldValidator>
                <asp:HiddenField ID="HdnManageDir" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员身份验证票过期时间：</strong><br />
                管理员登录后台后，在不操作的情况下自动保持登录状态的时间设置。<br />
                <span style="color: #FF0000">注意：如果为0则在当前浏览器保持登录状态。<br />
                    修改管理员身份验证票过期时间，必须在下次登录后台才能生效。 </span>
            </td>
            <td>
                <asp:TextBox ID="TxtTicketTime" runat="server" MaxLength="6" Columns="5"></asp:TextBox>&nbsp;分钟<pe:RegexValidator
                    ValidateType="Number" ID="NumberValidator3" ControlToValidate="TxtTicketTime"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用后台管理认证码：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableSiteManageCode" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="True" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>后台管理认证码：</strong><br />
                <asp:Label ID="LblNotes" runat="server" Text="该后台管理认证码还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label>
            </td>
            <td>
                <asp:TextBox ID="TxtSiteManageCode" runat="server" MaxLength="20"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>升级程序验证码：</strong><br />
                <asp:Label ID="LblUpdateCodeNotes" runat="server" Text="该升级程序验证码还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label>
            </td>
            <td>
                <asp:TextBox ID="TxtUpgradeIdentifyingCode" runat="server" MaxLength="20"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员密码哈希值：</strong><br />
                用于验证管理员密码数据的有效性，防止被非法方式修改。
            </td>
            <td>
                <asp:TextBox ID="TxtSiteHashCode" runat="server" MaxLength="20"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员登录后台是否同时将前台关联用户登录：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminIsLoginUser" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>管理员退出后台是否同时将前台关联用户退出：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminIsLogoutUser" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用强密码策略：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAdminPwdStrongCheck" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Selected="true" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 45%">
                <strong>选择前台语言种类</strong>
            </td>
            <td>
                <asp:CheckBoxList ID="CblCultureName" runat="server" RepeatDirection="Horizontal"
                    onclick="SetDropCultureName(this)">
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台默认语言：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropCultureName" runat="server" onChange="SetHdnCultureName(this);">
                </asp:DropDownList>
                <span id="CultureName" style="display: none">中文(中国) [zh-CN] (默认)</span>
                <asp:HiddenField ID="HdnCultureName" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否使用软键盘输入密码：</strong><br />
                若选择是，则管理员登录后台时使用软键盘输入密码，适合网吧等场所上网使用。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableSoftKey" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站根域名：</strong><br />
                在启用子域名单点登录的情况下，必须要设置此值。
            </td>
            <td>
                <asp:TextBox ID="TxtMainDomain" runat="server" Width="150px"></asp:TextBox>
                <br />
                例如：如果你的网址是http://www.powereasy.net，那么这里就要填写 <span style="color: #FF0000"><strong>powereasy.net</strong></span>
            </td>
        </tr>
		<tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启动移动设备检测：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableMobile" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否对数据库连接字符串加密：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlConnProtecte" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" id="EnablePointMoneyExp" runat="server">
            <td class="tdbgleft">
                <strong>是否启用点券、金额、积分、有效期功能：</strong><br />
                <span style="color: #FF0000">注意：此功能仅限于 “CMS模块”</span>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnablePointMoneyExp" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true" Selected="True">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站广告目录：</strong><br />
                为了不让广告拦截软件拦截网站的广告，<br />
                您可以修改广告JS的存放目录（默认为IAA），改过以后，需要再设置此处
            </td>
            <td>
                <asp:TextBox ID="TxtADDir" Text="IAA" MaxLength="20" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TxtADDir"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站生成目录：</strong><br />
                <span style="color: #FF0000">注意：如果生成在根目录下，请保留为空！</span>
            </td>
            <td>
                <asp:TextBox ID="TxtCreateHtmlPath" Text="html" MaxLength="20" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="TxtCreateHtmlPath"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9/]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>内嵌代码生成路径：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtIncludeFilePath" Text="Include" MaxLength="20" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegularExpressionValidator4" runat="server" ControlToValidate="TxtIncludeFilePath"
                    Display="Dynamic" ErrorMessage="目录名只能以字母、数字及下划线组成" SetFocusOnError="True" ValidationExpression="[_a-zA-Z0-9]{1,}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站模板目录：</strong><br />
                为防止他人猜测到模板存放地址，请修改此处配置并手动修改模板所在目录的目录名与之对应。<br />
                <asp:Label ID="LblTemplateNotes" runat="server" Text="该网站模板目录还是系统默认值，为了网站安全，请及时修改！" ForeColor="red"
                    Visible="false"></asp:Label>
            </td>
            <td>
                <asp:TextBox ID="TxtTemplateDir" Text="#Template" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrTemplateDir" runat="server" Display="Dynamic" ControlToValidate="TxtTemplateDir" ErrorMessage="网站模板目录不允许为空！" SetFocusOnError="true"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>布局模板目录：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtLayoutDir" Text="Layout" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>标签库目录：</strong><br />
                标签库目录必须配置成上面模板根目录下的目录。如“标签库”<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtLabelDirConfig" Text="标签库" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>分页标签库目录：</strong><br />
                分页标签库目录必须配置成上面模板根目录下的目录。如“分页标签库”<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtPagerLabelDirConfig" Text="分页标签库" Columns="40" MaxLength="40"
                    runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>代码片断库目录：</strong><br />
                代码片断库目录必须配置成上面模板根目录下的目录。如“代码片断库”<br />
                <span style="color: Blue">如果服务器支持中文目录，请不要轻易更改默认值</span>
            </td>
            <td>
                <asp:TextBox ID="TxtCodeSnippetDirConfig" Text="代码片断库" Columns="40" MaxLength="40"
                    runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台模板风格目录：</strong><br />
                前台模板风格目录对应网站根目录下的Skin目录下的文件夹。<br />
                在模板中使用<span style="color: Blue">{PE.SiteConfig.SkinPath/}</span>来表示。
            </td>
            <td>
                <asp:TextBox ID="TxtSkinDirConfig" Text="Default" Columns="40" MaxLength="40" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用内容自动签收：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlIsAutoSignin" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>自动签收内容时间：</strong><br />
                单位：秒。启用自动签收后，此设置才起作用。
            </td>
            <td>
                <asp:TextBox ID="TxtAutoSigninTime" Text="10" MaxLength="20" runat="server"></asp:TextBox><pe:RegexValidator
                    ValidateType="Number" ID="NumValTxtAutoSigninTime" ControlToValidate="TxtAutoSigninTime"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>防刷新队列长度：</strong><br />
                队列长度越长，防止用户恶意刷新提交重复表单越有效。
            </td>
            <td>
                <asp:TextBox ID="TxtRefreshQueueSize" Text="10" MaxLength="20" runat="server"></asp:TextBox><pe:RegexValidator
                    ValidateType="Number" ID="NumValTxtRefreshQueueSize" ControlToValidate="TxtRefreshQueueSize"
                    runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>采集休眠时间：</strong><br />
                每采集5篇信息服务器强制休眠指定秒数，不休眠可以填写0。
            </td>
            <td>
                <asp:TextBox ID="TxtCollectionSleep" Text="0" Columns="5" MaxLength="5" runat="server"></asp:TextBox>
                <asp:RegularExpressionValidator ID="ValgCollectionSleep" runat="server" ControlToValidate="TxtCollectionSleep"
                    ErrorMessage="只能输入正整数" ValidationExpression="^([0-9])(\d{0,})(\d{0,})$" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用防恶意刷新点击数功能：</strong><br />
                启用此功能后同一用户每刷新一次并不会增加点击数，只有重新打开浏览器才会被统计到。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableRefreshHits" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否记录新增的搜索关键字：</strong><br />                
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableAddNewKeyword" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否提示版本升级通知：</strong><br />
                启用此功能，有新版本发布时，后台将会弹出版本升级通知。
            </td>
            <td>
                <asp:RadioButtonList ID="RadlIsCheckNewVersion" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站当前状态：</strong><br />
                维护期间可设置关闭状态
            </td>
            <td>
                <asp:RadioButtonList ID="RadSiteStatus" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="true">打开</asp:ListItem>
                    <asp:ListItem Selected="True" Value="false">关闭</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>邮件确认模板管理：</strong><br />
                标签含义：<br />
                {$ConfirmSubscribeEmail}：订阅
            </td>
            <td>
                <pe:CKeditor ID="TxtConfirmSubscribeEmail" runat="server" Toolbar="Basic" Width="80%"
                    Height="200px">
                </pe:CKeditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>邮件退订模板管理：</strong><br />
                标签含义：<br />
                {$UnsubscribeEmail}：退订
            </td>
            <td>
                <pe:CKeditor ID="TxtUnsubscribeEmail" runat="server" Toolbar="Basic" Width="80%"
                    Height="200px">
                </pe:CKeditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>维护说明：</strong><br />
                在网站关闭状态下显示，支持html语法
            </td>
            <td>
                <asp:TextBox ID="TxtSiteMaintainDescription" TextMode="MultiLine" runat="server"
                    Height="80px" Width="400px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存设置" OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">

        function SetDropCultureName(object) {
            var tDropDownList = document.getElementById('<%=DropCultureName.ClientID %>');
            var chkInput = object.getElementsByTagName("INPUT");
            var chkLable = object.getElementsByTagName("Label");
            for (var i = 0; i < chkInput.length; i++) {
                if (chkInput[i].checked) {
                    var content = chkLable[i].innerHTML;
                    var isIn = false;
                    for (var j = 0; j < tDropDownList.options.length; j++) {
                        if (content == tDropDownList.options[j].text) {
                            isIn = true;
                            break;
                        }
                    }
                    if (!isIn) {
                        var opt = document.createElement("option");
                        opt.value = content;
                        opt.text = content;
                        tDropDownList.options.add(opt);
                    }
                }
                else {
                    var content = chkLable[i].innerHTML;
                    for (var j = 0; j < tDropDownList.options.length; j++) {
                        if (content == tDropDownList.options[j].text) {
                            tDropDownList.options[j] = null;
                            break;
                        }
                    }
                }
            }
            SetHdnCultureName(tDropDownList)
        }

        function SetHdnCultureName(object) {
            if (object.selectedIndex == 0) {
                var hdnCultureName = document.getElementById(object.id).options[object.selectedIndex].text + ",";
                for (var j = 0; j < object.options.length; j++) {
                    if (hdnCultureName.indexOf(object.options[j].text) < 0) {
                        hdnCultureName += object.options[j].text + ",";
                    }
                }
                document.getElementById('<%=HdnCultureName.ClientID %>').value = hdnCultureName.substr(0, hdnCultureName.length - 1);
            }
            IsShowCultureName(object);
        }

        function IsShowCultureName(object) {
            if (object.selectedIndex < 0) {
                document.getElementById('<%=DropCultureName.ClientID %>').style.display = "none";
                document.getElementById("CultureName").style.display = "block";
            }
            else {
                document.getElementById('<%=DropCultureName.ClientID %>').style.display = "block";
                document.getElementById("CultureName").style.display = "none";
            }
        }
        IsShowCultureName(document.getElementById('<%=DropCultureName.ClientID %>'));
    </script>
</asp:Content>
