﻿<%@ Page Title="撰写短消息" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="MessageSend.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Profile.MessageSend" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <asp:Localize ID="Localize1" Text="撰写短消息"
                        runat="server" /></b>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" style="width: 25%">
                <asp:Localize ID="Localize2" Text="收件人："
                    runat="server" />
            </td>
            <td>
                <asp:ScriptManager ID="scriptManage1" runat="server">
                </asp:ScriptManager>
                <asp:UpdatePanel ID="updatepannel1" runat="server">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtInceptUser" runat="server" Width="130px" />
                        <asp:DropDownList ID="dropFriendGroups" runat="server" AutoPostBack="true" DataTextField="FriendGroupName"
                            DataValueField="FriendGroupID" />
                        <asp:DropDownList ID="DropFriends" runat="server" />
                        <pe:RequiredFieldValidator ID="ValrInceptUser" runat="server" ControlToValidate="TxtInceptUser"
                            ErrorMessage="收件人不能为空" Display="Dynamic" />
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right">
                <asp:Localize ID="Localize3" Text="短消息主题："
                    runat="server" />
            </td>
            <td>
                <asp:TextBox ID="TxtTitle" runat="server" Width="300" MaxLength="50" />
                <pe:RequiredFieldValidator ID="ValrTitle" runat="server" ControlToValidate="TxtTitle"
                    ErrorMessage="短消息主题不能为空" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right">
                <asp:Localize ID="Localize4" Text="短消息内容："
                    runat="server" />
            </td>
            <td>
                <pe:CKeditor ID="EditorContent" runat="server" Width="580px" Height="300px" Toolbar="Basic"
                    ImageUpload="false" FlashUpload="false" ModuleName="message" FileRecord="true" />
                <pe:CKeditorValidator ID="ValrContent" runat="server" ControlToValidate="EditorContent"
                    ErrorMessage="短消息内容不能为空" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:HiddenField ID="HdnMessageID" runat="server" />
                <asp:Button ID="BtnSend" runat="server" Text="发送"
                    CommandName="Send" OnClick="BtnSend_Click" />
                <asp:Button ID="BtnSave" runat="server" Text="保存"
                    CommandName="Save" OnClick="BtnSave_Click" />
                <input name="Cancel" type="button" class="inputbutton" id="Button1" value="清除" onclick="javascript:return ResetContent()" />
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td colspan="2" style="text-align: left">
                <asp:Localize ID="Localize5" Text="1、可以用英文状态下的逗号将用户名隔开实现群发，最多"
                    runat="server" /><b><asp:Label ID="LblMaxSendNum" runat="server" Text="" /></b><asp:Localize
                        ID="Localize6" Text="个用户。" runat="server" /><br />
                <asp:Localize ID="Localize7" Text="2、标题最多"
                    runat="server" /><b><%=TxtTitle.MaxLength.ToString()%></b><asp:Localize ID="Localize8"
                        Text="个字符，内容最多" runat="server" /><b><%=MaxContentLength%></b><asp:Localize
                            ID="Localize9" Text="个字符。" runat="server" /><br />
                <asp:Label ID="Label1" runat="server" Text="3、在添加了好友之后，可以在收件人下拉框选择好友为收件人。"></asp:Label><br />
            </td>
        </tr>
    </table>

    <script type="text/javascript">
        
                   
            function SelectFromFriend()
            {
                var txtInceptUser = document.getElementById('<%=TxtInceptUser.ClientID %>');
                var dropFriends = document.getElementById('<%=DropFriends.ClientID %>'); 
                if(dropFriends.selectedIndex==0)
                {
                    return false;
                }
                var selectedFriend = dropFriends.value;
                
                if(txtInceptUser.value !='')
                {
                    var users = txtInceptUser.value.split(',');
                    for(var i=0;i<users.length;i++)
                    {
                        if(users[i]==selectedFriend)
                        {
                            return false;
                        }
                    }
                    txtInceptUser.value +=","+selectedFriend;
                }
                else
                {
                    txtInceptUser.value =selectedFriend;
                }
            }

            function ResetContent() {
                var TxtInceptUser = document.getElementById('<%=TxtInceptUser.ClientID %>');
                var TxtTitle = document.getElementById('<%=TxtTitle.ClientID %>');
                var EditorContent = document.getElementById('<%=EditorContent.ClientID %>');
                TxtInceptUser.value = '';
                TxtTitle.value = '';
                <%=EditorContent.ClientID %>$$ckeditor$$obj.setData('');
             }
    </script>

</asp:Content>
