﻿<%@ Page Title="我的短消息" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="MyMessageManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Profile.MyMessageManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
   <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有短消息</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitNoRead" />>    
                       <asp:LinkButton ID="LinkNoRead" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>未读短消息</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitIsRead" />>    
                       <asp:LinkButton ID="LinkIsRead" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>已读短消息</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="GdvMessageList" runat="server" DataKeyNames="MessageId"
        AllowPaging="True" ItemName="短消息" AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="True"
        OnRowDataBound="GdvMessageList_RowDataBound" OnRowCommand="GdvMessageList_RowCommand" DataSourceID="OdsMessageList"
        CheckBoxFieldHeaderWidth="3%" SerialText="" OnDataBound="GdvMessageList_DataBound">
        <Columns>
            <pe:TemplateField HeaderText="短消息主题" ShowHeader="False">
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" ID="HlnkMessage" Text='<%# Eval("Title") %>' NavigateUrl='<%# Eval("MessageID","~/Admin/Profile/MessageRead.aspx?MessageID={0}") %>'></asp:HyperLink></ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Incept" HeaderText="收件人" />
            <pe:BoundField DataField="Sender" HeaderText="发件人" />
            <pe:TemplateField HeaderText="发送日期" SortExpression="SendTime">
                <ItemTemplate>
                    <%# Eval("SendTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="大小" SortExpression="Content">
                <ItemStyle HorizontalAlign="Right" />
                <ItemTemplate>
                    <%# Eval("Content").ToString().Length +" Byte"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已读">
                <ItemTemplate>
                    <%# Convert.ToInt32(Eval("IsRead")) == 0 ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("MessageID") %>'
                        CommandName="Del" OnClientClick='return confirm("是否删除此短消息?")' Text="删除"></asp:LinkButton>
                        <asp:HyperLink ID="lnkReply" runat="server" Text="回复" Visible="false" NavigateUrl=""></asp:HyperLink>
                        <asp:HyperLink ID="lnkForward" runat="server" Text="转发" Visible="false" NavigateUrl=""></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><asp:Localize
        ID="Localize1" Text="选中本页显示的所有短消息" runat="server" />
    <asp:Button ID="BtnDelete" runat="server" Text="删除选定的短消息" OnClientClick='return confirm("是否删除所选定的短消息?")'
        OnClick="BtnDelete_Click" CausesValidation="False" />
    <asp:Button ID="BtnDeleteAll" runat="server" Text="清空所有短消息" OnClick="BtnDeleteAll_Click"
        OnClientClick="return confirm('确定要清空短消息吗？')" />&nbsp;<br />
    <asp:HiddenField ID="HdnSearchField" runat="server" />
    <asp:HiddenField ID="HdnKeyword" runat="server" />
    <asp:ObjectDataSource ID="OdsMessageList" runat="server" SelectMethod="GetMessageList"
        SelectCountMethod="Count" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Message"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnSearchField" DefaultValue="0" Name="searchField"
                PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnManageType" runat="server" Value="0" />
    <br />
    <br />
    <table width="100%" cellpadding="3" cellspacing="0" class="border">
        <tr class="tdbg">
            <td align="right" style="width: 15%;">
                <strong>短消息搜索：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropSearch" runat="server">
                    <asp:ListItem Value="0">搜索类型</asp:ListItem>
                    <asp:ListItem Value="1">短消息主题</asp:ListItem>
                    <asp:ListItem Value="2">短消息内容</asp:ListItem>
                    <asp:ListItem Value="3">收件人</asp:ListItem>
                    <asp:ListItem Value="4">发件人</asp:ListItem>
                    <asp:ListItem Value="5">某个人</asp:ListItem>
                </asp:DropDownList>
                <asp:TextBox ID="TxtKeyword" runat="server">关键字</asp:TextBox>
                <asp:Button ID="BtnSubmit" runat="server" Text="搜索" OnClick="BtnSubmit_Click" />
                <pe:RequiredFieldValidator ID="ValrKeyword" runat="server" ControlToValidate="TxtKeyWord"
                    ErrorMessage="RequiredFieldValidator" SetFocusOnError="True" ShowRequiredText="false">请输入搜索的关键字！</pe:RequiredFieldValidator>
            </td>
        </tr>
    </table>
    <br />
</asp:Content>
