﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    CodeBehind="CategoryManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.RedirectUrl.RedirectCategoryManage"
    Title="链接类别管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvCategory" runat="server" AllowPaging="True" AutoGenerateCheckBoxColumn="True"
        AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%" IsHoldState="True"
        DataKeyNames="CategoryId" SerialText="" DataSourceID="OdsRedirectCategory" OnRowCommand="EgvCategory_RowCommand">
        <Columns>
            <pe:BoundField DataField="CategoryId" HeaderText="ID" SortExpression="CategoryId">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="类别名称" SortExpression="CategoryName">
                <ItemTemplate>
                    <a href='RedirectUrlManage.aspx?CategoryID=<%#Eval("CategoryID") %>'>
                        <%# Eval("CategoryName").ToString()%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="CategoryDescription" HeaderText="类别描述" SortExpression="CategoryDescription">
                <HeaderStyle Width="55%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ELbtnModify" IsChecked="true" OperateCode="RedirectUrl" href='<%# "Category.aspx?Action=Modify&CategoryName="+Eval("CategoryName")+"&CategoryID=" + Eval("CategoryId")%>'
                        runat="server">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ELbtnDelete" Text="删除" IsChecked="true" OperateCode="RedirectUrl"
                        OnClientClick="return confirm('是否删除此链接类别吗？')" runat="server" CommandArgument='<%# Bind("CategoryId") %>'
                        CommandName="Del" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsRedirectCategory" runat="server" SelectMethod="GetRedirectCategoryList"
        TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.RedirectCategory" SelectCountMethod="GetTotalOfRedirectCategory"
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="listType" QueryStringField="ListType"
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <asp:Button ID="Button1" runat="server" Text="批量删除选定链接类别" CausesValidation="False"
        OnClientClick="return confirm('确实要删除选中的链接类别？');" OnClick="BtnCategoryList_OnClick" />
    &nbsp;&nbsp;
    <input type='button' value='链接类别排序' onclick="location.href='CategoryOrder.aspx'" />
</asp:Content>
