﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="AdministratorManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.AdministratorManage"
    Title="管理员管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>全部</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblMonthChangePwd" />>    
                       <asp:LinkButton ID="LinkMonthChangePwd" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>一个月未修改密码的</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblTwentyFourLogin" />>    
                       <asp:LinkButton ID="LinkTwentyFourLogin" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>24小时登录的</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblLock" />>    
                       <asp:LinkButton ID="LinkLock" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>锁定的</span></asp:LinkButton>
                    </li>
                   <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblLogin" />>    
                       <asp:LinkButton ID="LinkLogin" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>允许多人登录的</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="Egv" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataSourceID="ObjectDataSource1" SerialText=""
        OnRowDataBound="Egv_RowDataBound" OnRowCommand="Egv_RowCommand"
        RowDblclickBoundField="AdminId" 
        RowDblclickUrl="Administrator.aspx?Action=Modify&amp;AdminId={$Field}">
        <Columns>
            <pe:TemplateField HeaderText="操作">
            <HeaderStyle Width="100" />
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu" ShowShortcut='true'>
                        <pe:ButtonMenuItem ID="LnkModify" CommandName="ModifyAdmin" CommandArgument='<%# Eval("AdminId")%>' runat="server" SkinID="Edit" />
                        <pe:LinkMenuItem ID="lnkLook" SkinID="View" Text="查看权限" runat="server" />
                        <pe:ButtonMenuItem ID="LnkLock" runat="server" CommandName="LockAdmin" CommandArgument='<%# Eval("AdminId")%>' Text="禁用" />
                        <pe:ButtonMenuItem ID="LnkDelete" CommandName="DeleteAdmin" OnClientClick="if(!this.disabled) return confirm('确实要删除此管理员吗？');"
                    CommandArgument='<%# Eval("AdminId")%>' runat="server" SkinID="Delete" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="AdminId" HeaderText="ID" HeaderStyle-Width="4%" />
            <pe:TemplateField HeaderText="管理员名">
                <ItemTemplate>
                    <asp:HyperLink ID="LnkManageName" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="前台用户名">
                <ItemTemplate>
                    <pe:ExtendedHyperLink ID="HypUserName" runat="server"></pe:ExtendedHyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="所属角色">
                <ItemStyle HorizontalAlign="left" />
                <ItemTemplate>
                    <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LabRoleList"></pe:ExtendedLiteral>
                    <pe:ExtendedLiteral HtmlEncode="false" ID="LtrRoleList" runat="server"></pe:ExtendedLiteral>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="所属部门">
                <ItemTemplate>
                    <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitDepartment"></pe:ExtendedLiteral>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="多人登录">
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LabEnableMultiLogin"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
           <%-- <pe:BoundField DataField="LastLoginIP" HeaderText="最后登录IP" />--%>
            <pe:TemplateField HeaderText="最后登录IP<br/>最后登录时间">
                <ItemTemplate>
                    <asp:Label runat="server" ID="LabLastLoginIp"></asp:Label><br />
                    <asp:Label runat="server" ID="LabLastLoginTime"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="上次修改密码时间">
                <ItemTemplate>
                    <asp:Label runat="server" ID="LabLastModifyPasswordTime"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="LogOnTimes" HeaderText="登录次数" />
          
            <pe:TemplateField HeaderText="管理员状态">
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LabIsLock"></pe:ExtendedLabel>
                    
                </ItemTemplate>
            </pe:TemplateField>
            <%--<pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <asp:LinkButton ID="lnkLook" runat="server">查看</asp:LinkButton>
                    <asp:LinkButton ID="LnkLock" CommandName="LockAdmin" CommandArgument='<%# Eval("AdminId")%>'
                        runat="server">禁用</asp:LinkButton>
                    <asp:LinkButton ID="LnkModify" CommandName="ModifyAdmin" CommandArgument='<%# Eval("AdminId")%>'
                        runat="server">修改</asp:LinkButton>
                    <asp:LinkButton ID="LnkDelete" CommandName="DeleteAdmin" OnClientClick="if(!this.disabled) return confirm('确实要删除此管理员吗？');"
                        CommandArgument='<%# Eval("AdminId")%>' runat="server">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>--%>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnRoleId" runat="server" Value="-1" />
    <asp:HiddenField ID="HdnListType" runat="server" Value="0" />
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" EnablePaging="true" SelectMethod="AdminList"
        TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.Administrators" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows" SelectCountMethod="GetTotalOfAdmin">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnRoleId" Type="Int32" Name="roleId" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="listType" PropertyName="Value" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
