﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserList.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.UserList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>用户列表页</title>
    <base target="_self" />
</head>
<% UserInput = Request.QueryString["OpenerText"];%>
<body>
    <form id="myform" runat="server">
    <div>
        <table width="100%" border="0" cellpadding="2" cellspacing="0" class="border">
            <tr class="title" style="height: 22">
                <td align="left">
                    <b>已经选定的用户：</b>
                </td>
                <td align="right">
                </td>
            </tr>
            <tr class="tdbg">
                <td align="left">
                    <input type="text" id="UserNameList" size="60" maxlength="200" readonly="readonly"
                        class="inputtext" />
                    <input type="hidden" name="HdnUserName" id="HdnUserName" value="" />
                </td>
                <td align="center">
                    <input type="button" class="inputbutton" name="del1" onclick="del(1)" value="删除最后" />
                    <input type="button" class="inputbutton" name="del2" onclick="del(0)" value="删除全部" />
                </td>
            </tr>
        </table>
        <br />
        <table width="100%" border="0" cellpadding="2" cellspacing="0" class="border">
            <tr class="title">
                <td align="left">
                    <pe:ExtendedLabel ID="LblTitleAll" runat="server" Text="全部用户"></pe:ExtendedLabel>
                    <asp:Repeater ID="RptUserGroupName" runat="server" DataSourceID="OdsUserGroupName"
                        OnItemDataBound="RepUserGroup_ItemDataBound">
                        <ItemTemplate>
                            <pe:ExtendedLabel ID="LblTitle" runat="server" Text="Label"></pe:ExtendedLabel>
                        </ItemTemplate>
                    </asp:Repeater>
                </td>
            </tr>
        </table>
        <asp:ObjectDataSource ID="OdsUserGroupName" runat="server" SelectMethod="GetUserGroupList"
            TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserGroups">
            <SelectParameters>
                <asp:Parameter Name="startRowIndexId" Type="Int32" />
                <asp:Parameter Name="maxNumberRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <br />
        <table width="100%" border="0" cellpadding="2" cellspacing="0" class="border">
            <tr class="title">
                <td align="left">
                    <b>会员列表：</b>
                </td>
                <td align="right">
                    <asp:TextBox ID="TxtKeyWord" runat="server"></asp:TextBox>&nbsp;&nbsp;<asp:Button
                        ID="BtnSearch" runat="server" Text="查找" />
                </td>
            </tr>
            <tr>
                <td valign="top" colspan="2">
                    <div id="DivUserName" runat="server" visible="false">
                        未找到任何用户！</div>
                    <asp:Repeater ID="RepUser" runat="server" OnItemDataBound="RepUser_ItemDataBound">
                        <HeaderTemplate>
                            <table width="100%" border="0" cellspacing="1" cellpadding="1" class="border">
                                <tr>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <td align="center">
                                <a href="javascript:" onclick="<%# "add('" + Container.DataItem + "')"%>">
                                    <%# Container.DataItem%>
                                </a>
                            </td>
                            <% 
                                i++; %>
                            <% if (i % 8 == 0 && i > 1)
                               {%>
                            </tr><tr>
                                <%} %>
                        </ItemTemplate>
                        <FooterTemplate>
                            </tr></table>
                        </FooterTemplate>
                    </asp:Repeater>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="center" colspan="2">
                    <div id="DivAdd" runat="server">
                        <a href="javascript:" onclick="add('<%=AllUsers %>')">增加以上所有用户</a></div>
                </td>
            </tr>
        </table>
        <table border="0" align="center" cellpadding="2" cellspacing="0">
            <tr>
                <td align="center">
                    <pe:AspNetPager ID="Pager" runat="server" OnPageChanged="Pager_PageChanged">
                    </pe:AspNetPager>
                </td>
            </tr>
        </table>
    </div>
    <script language="javascript" type="text/javascript">
        var userInput = parent.document.getElementById('<%= UserInput %>');
        var userNameList = document.getElementById('UserNameList');
        var isSingle = "<%= select %>" == "single";
        userNameList.value = userInput.value;

        function add(obj) {
            if (obj == "") { return false; }
            if (isSingle) {
                userInput.value = obj;
                CloseFloatingDialog();
                return;
            }
            if (userInput.value == "") {
                userInput.value = obj;
                userNameList.value = userInput.value;
                return false;
            }
            var ignoreUserName = "";
            if (checkUserName(userInput.value, obj)) {
                ignoreUserName = ignoreUserName + obj + " ";
            }
            else {
                userInput.value = userInput.value + "," + obj;
                userNameList.value = userInput.value;
            }

            if (ignoreUserName != "") {
                alert(ignoreUserName + "用户已经存在，此操作已经忽略！");
            }
        }
        function del(num) {
            if (num == 0 || userInput.value == "" || userInput.value == ",") {
                userInput.value = "";
                userNameList.value = "";
                return false;
            }

            var strDel = userInput.value;
            var s = strDel.split(",");
            userInput.value = strDel.substring(0, strDel.length - s[s.length - 1].length - 1);
            userNameList.value = userInput.value;
        }

        function checkUserName(UserNamelist, thisUserName) {
            if (UserNamelist == thisUserName) {
                return true;
            }
            else {
                var s = UserNamelist.split(",");
                for (j = 0; j < s.length; j++) {
                    if (s[j] == thisUserName)
                        return true;
                }
                return false;
            }
        }

        //关闭浮动窗口
        function CloseFloatingDialog() {
            window.parent.jQuery(".floatingDialog").hide();
            window.parent.jQuery("#jqDnrFloatDivBg").hide();
        }
    </script>
    </form>
</body>
</html>
