﻿<%@ Page Title="WAP类别管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="WapCategoryManage.aspx.cs" Inherits="PowerEasy.Module.Wap.WebSite.Admin.Wap.WapCategoryManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="egvWapCategoryManage" runat="server" DataSourceID="OdsCategory"
        DataKeyNames="WapCategoryId" AllowPaging="true" AutoGenerateCheckBoxColumn="true"
        OnRowCommand="egvWapCategoryManage_OnRowCommand" AutoGenerateColumns="false" OnRowDataBound="egvWapCategoryManage_OnRowDataBound"
        RowDblclickBoundField="WapCategoryId" RowDblclickUrl="WapCategoryAdd.aspx?Action=modify&amp;id={$Field}">
        <Columns>
            <asp:BoundField DataField="WapCategoryId" HeaderText="ID" />
            <asp:BoundField DataField="WapCategoryName" HeaderText="类别名称" />
            <asp:BoundField DataField="TemplatePath" HeaderText="模板路径" />
            <asp:TemplateField HeaderText="评论权限">
                <ItemTemplate>
                    <asp:Literal ID="ltrPurview" runat="server"></asp:Literal>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="评论是否需要审核">
                <ItemTemplate>
                    <pe:ExtendedLiteral ID="ltrNeedCheck" runat="server" HtmlEncode="false"></pe:ExtendedLiteral>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <a href='WapCategoryAdd.aspx?Action=modify&id=<%# Eval("WapCategoryId")%>'>修改</a>
                    <asp:LinkButton ID="lnkDelete" OnClientClick="return confirm('删除类别会删除相应的内容，是否要删除该类别？')" runat="server" CommandName="delete" CommandArgument='<%# Eval("WapCategoryId") %>'
                        Text="删除"></asp:LinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
        for="ChkAll">选中本页显示的所有类别</label>
    &nbsp;&nbsp;
    <asp:Button ID="btnDelete" runat="server" OnClick="btnDelete_Click" OnClientClick="return batchconfirm('删除类别会删除相应的内容，是否要删除选中的类别？')"
        Text="删除选定的类别" />
    <asp:ObjectDataSource ID="OdsCategory" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.Wap.BusinessLogic.WapCategory"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows" SelectCountMethod="GetTotalOfWapCategory">
    </asp:ObjectDataSource>
</asp:Content>
