﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="Company.ascx.cs" Inherits="PowerEasy.Module.General.WebSite.Controls.Company.Company" %>
<tr class="first">
    <td align='right' style="width: 20%;" class="ok_tab">
        <asp:Localize ID="Localize1" Text="<%$ Res: Controls_Company_Company_Localize1 ,企业名称： %>"
            runat="server" />
    </td>
    <td align='left' colspan="3" style="width: 80%;">
        <asp:TextBox ID="TxtCompanyName" runat="server" class="inputxt" Width="300px" MaxLength="200"></asp:TextBox>
        <pe:RequiredFieldValidator ID="ValrCompanyName" runat="server" Display="dynamic"
            ControlToValidate="TxtCompanyName" ErrorMessage="<%$ Res: Controls_Company_Company_TxtCompanyName ,企业名称不能为空！ %>"></pe:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="ValeCompanyName" Display="Dynamic" ControlToValidate="TxtCompanyName"
            ValidationExpression="^[\w\W\u4e00-\u9fa5]{6,100}$" SetFocusOnError="true" runat="server"
            ErrorMessage="<%$ Res: Controls_Company_Company_ValeCompanyName ,企业名称的长度不能小于6位大于100位 %>"></asp:RegularExpressionValidator>
    </td>
</tr>
<tr>
    <td class="ok_tab">
        <asp:Localize ID="Localize2" Text="所属区域：" runat="server" />
    </td>
    <td colspan="3">
        <pe:HorizontalRegion ID="Region1" runat="server" />
    </td>
</tr>
<tr>
    <td class="ok_tab">
        <asp:Localize ID="Localize3" Text="<%$ Res: Controls_Company_Company_Localize3 ,联系地址： %>"
            runat="server" />
    </td>
    <td colspan="3">
        <asp:TextBox ID="TxtAddress" class="inputxt" runat="server" Width="300px" MaxLength="255"></asp:TextBox>
        <pe:RequiredFieldValidator ID="ValrAddress" ControlToValidate="TxtAddress" SetFocusOnError="true" 
            Display="dynamic" runat="server" ErrorMessage="<%$ Res: Controls_Company_Company_ValrAddress ,请输入详细的联系地址 %>"></pe:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="ValeAddress" Display="Dynamic" ControlToValidate="TxtAddress"
            ValidationExpression="^[\w\W\u4e00-\u9fa5]{10,}$" SetFocusOnError="true" runat="server"
            ErrorMessage="<%$ Res: Controls_Company_Company_ValeAddress ,联系地址的长度不能小于10 %>"></asp:RegularExpressionValidator>
    </td>
</tr>
<tr>
    <td class="ok_tab" style="width:17%">
        <asp:Localize ID="Localize4" Text="<%$ Res: Controls_Company_Company_Localize4 ,邮政编码： %>"
            runat="server" />
    </td>
    <td style="width:33%">
        <asp:TextBox ID="TxtZipCode" class="inputxt" runat="server" MaxLength="6"></asp:TextBox><pe:RegexValidator
            ValidateType="ZipCode" ID="VzipZipCode" ControlToValidate="TxtZipCode" SetFocusOnError="true"
            Display="dynamic" runat="server"></pe:RegexValidator>
        <pe:RequiredFieldValidator ID="ValrZipCode" ControlToValidate="TxtZipCode" SetFocusOnError="true"
            Display="dynamic" runat="server" ErrorMessage="<%$ Res: Controls_Company_Company_ValrZipCode ,请输入单位的邮政编码 %>"></pe:RequiredFieldValidator>
    </td>
    <td align='right' style="width:17%" class="ok_tab">
        <asp:Localize ID="Localize5" Text="<%$ Res: Controls_Company_Company_Localize5 ,联系电话： %>"
            runat="server" />
    </td>
    <td align='left' style="width:33%">
        <asp:TextBox ID="TxtPhone" runat="server" class="inputxt" MaxLength="30"></asp:TextBox>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize6" Text="<%$ Res: Controls_Company_Company_Localize6 ,传真号码： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtFax" runat="server" class="inputxt" MaxLength="30"></asp:TextBox>
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize7" Text="<%$ Res: Controls_Company_Company_Localize7 ,开户银行： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtBankOfDeposit" class="inputxt" runat="server" MaxLength="50"></asp:TextBox>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize8" Text="<%$ Res: Controls_Company_Company_Localize8 ,银行帐号： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtBankAccount" class="inputxt" runat="server" MaxLength="50"></asp:TextBox>
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize9" Text="<%$ Res: Controls_Company_Company_Localize9 ,税号： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtTaxNum" runat="server" class="inputxt" MaxLength="20"></asp:TextBox>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize10" Text="<%$ Res: Controls_Company_Company_Localize10 ,网址： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtHomepage" runat="server" class="inputxt" MaxLength="100"></asp:TextBox>
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize13" Text="<%$ Res: Controls_Company_Company_Localize13 ,业务范围： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtBusinessScope" class="inputxt" runat="server" MaxLength="255"></asp:TextBox>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize12" Text="<%$ Res: Controls_Company_Company_Localize12 ,公司规模： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:DropDownList ID="DropCompanySize" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize11" Text="<%$ Res: Controls_Company_Company_Localize11 ,行业地位： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:DropDownList ID="DropStatusInField" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize14" Text="<%$ Res: Controls_Company_Company_Localize14 ,年销售额： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtAnnualSales" runat="server" class="inputxt" MaxLength="20"></asp:TextBox><asp:Localize
            ID="Localize15" Text="<%$ Res: Controls_Company_Company_Localize15 ,万元  %>" runat="server" />
        <asp:CompareValidator ID="ValcAnnualSales" runat="server" ControlToValidate="TxtAnnualSales"
            Display="Dynamic" ErrorMessage="<%$ Res: Controls_Company_Company_ValcAnnualSales ,请输入有效的数值！ %>"
            Operator="GreaterThan" Type="Double" ValueToCompare="0"></asp:CompareValidator>
        &nbsp;
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize16" Text="<%$ Res: Controls_Company_Company_Localize16 ,经营状态： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:DropDownList ID="DropManagementForms" runat="server" DataTextField="DataTextField"
            DataValueField="DataValueField">
        </asp:DropDownList>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize17" Text="<%$ Res: Controls_Company_Company_Localize17 ,注册资本： %>"
            runat="server" />
    </td>
    <td align='left'>
        <asp:TextBox ID="TxtRegisteredCapital" class="inputxt" runat="server" MaxLength="20"></asp:TextBox><asp:Localize
            ID="Localize18" Text="<%$ Res: Controls_Company_Company_Localize18 ,万元  %>" runat="server" /><asp:CompareValidator
                ID="ValcRegisteredCapital" runat="server" ControlToValidate="TxtRegisteredCapital"
                Display="Dynamic" ErrorMessage="<%$ Res: Controls_Company_Company_ValcRegisteredCapital ,请输入有效的数值！ %>"
                Operator="GreaterThan" Type="Double" ValueToCompare="0"></asp:CompareValidator>
        &nbsp;
    </td>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize19" Text="<%$ Res: Controls_Company_Company_Localize19 ,公司照片： %>"
            runat="server" />
    </td>
    <td align='left' colspan="3">
        <asp:TextBox ID="TxtCompanyPic" runat="server" class="inputxt" MaxLength="255" Width="250px"></asp:TextBox>
    </td>
</tr>
<tr>
    <td align='right' class='ok_tab'>
        <asp:Localize ID="Localize20" Text="<%$ Res: Controls_Company_Company_Localize20 ,公司简介： %>"
            runat="server" />
    </td>
    <td align='left' colspan="3">
        <asp:TextBox ID="TxtCompanyIntro" TextMode="MultiLine" class="inputxt" Height="120px"
            runat="server" Width="250px"></asp:TextBox>
    </td>
</tr>
<asp:HiddenField ID="HdnCompanyAction" runat="server" />
