﻿/*===============================================================*/
//脚本名称 ：商城对象类
//注意事项 : 必须先导入jquery.pack.js、jquery.cookie.js、json.js
/*===============================================================*/

//积分商品购物车
var GiftCart ={};	
(function(){
	var _cookieExpires = null;
	var _cookieDomain = ""; 
	var _cookiePath = '/'; 
    var _empty = '{"count":0,"point":0,"gifts":[]}';
    var _cartCookieName = "pe.giftShoppingCart";
    var _isPhysical = false;
    var cart = JSON.parse(jQuery.cookie(_cartCookieName) || _empty);
	
	//获取积分商品数量
	GiftCart.count = function(){ return cart.count; };
    	
	//获取消费积分数量
	GiftCart.point = function(){ return cart.point;};
    
    //获取购物车中的积分商品列表
    GiftCart.gifts = function(){ return cart.gifts};

    //是否有实物 true 代表“有”
    GiftCart.hasPhysical = function(){
        for(var i=0 ; i<cart.gifts.length;i++){
            var ch = parseInt(cart.gifts[i].character);
            if(ch && (ch&1==1)){
                return true;
            }
        }
        return false;
    }

    //清除积分购物车
    GiftCart.clear = function(){ 
        var exp = new Date();
        exp.setTime(exp.getTime() - 1); 
        jQuery.cookie(_cartCookieName , _empty, { path: _cookiePath, expires: exp.toGMTString()}); 
    };

	//添加积分商品
	GiftCart.addGift = function(id, giftname, point,character,qty,pic){
        var amount = parseInt(qty)||1;
        var picpath = pic||'';
        cart.count += amount;
        cart.point += parseInt(point)*amount;
        var index = _getItemIndex(id);			
        if(index > -1){
            cart.gifts[index].qty += amount;
        }else{
		    cart.gifts.push({"id":id , "giftName":giftname , "point":parseInt(point) , "qty":amount, "character": character,"pic":picpath});
        }
		_save();
	};

    //删除积分商品
    GiftCart.remove= function(giftId){
        var index =  _getItemIndex(giftId);	
        if(index >=0){
            var obj = cart.gifts[index];
            cart.count -= obj.qty;
            cart.point -= (obj.point * obj.qty);
            cart.gifts.splice(index,1);
            _save();
        }
    }
    //加1
    GiftCart.addAmount = function(giftId){
        var index = _getItemIndex(giftId);
        if(index >= 0){
            cart.gifts[index].qty += 1;
            cart.count += 1;
            cart.point += cart.gifts[index].point;
            _save();
            return cart.gifts[index];
        }
        return null;
    };
    //减1
    GiftCart.reduceAmount = function(giftId){
        var index = _getItemIndex(giftId);
        if(index >=0 && cart.gifts[index].qty >1){
            cart.gifts[index].qty -= 1;
            cart.count -= 1;
            cart.point -= cart.gifts[index].point;
            _save();
            return cart.gifts[index];  
        }
        return null;
    }

    GiftCart.getGiftById = function(giftId){
        var index = _getItemIndex(giftId);
        if(index >=0){
            return cart.gifts[index]
        }
        return null;
    }

    function _save(){
        jQuery.cookie(_cartCookieName, JSON.stringify(cart), { path: _cookiePath, expires: _cookieExpires });
    }

    function _getItemIndex(giftId){
      for(var i=0 ; i<cart.gifts.length;i++){
		if(cart.gifts[i].id == giftId){ return i ; } 
      }
      return -1;
    }
    	
}());