﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserExpLog.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Info.UserExpLog" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_sate mtop10">
        <ul>
            <li id="li0"><span><a href="UserExpLog.aspx?SearchType=0">
                <asp:Localize ID="Localize1" Text="所有积分记录" runat="server" /></a></span></li>
            <li id="li1"><span><a href="UserExpLog.aspx?SearchType=1">
                <asp:Localize ID="Localize2" Text="增加积分记录" runat="server" /></a></span></li>
            <li id="li2"><span><a href="UserExpLog.aspx?SearchType=2">
                <asp:Localize ID="Localize3" Text="扣除积分记录" runat="server" /></a></span></li>
        </ul>
    </div>

    <script type="text/javascript">
        Request = {
            QueryString: function(item) {
                var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                return svalue ? svalue[1] : svalue;
            }
        }
        var SearchType = Request.QueryString("SearchType");
        document.getElementById("li" + SearchType.toString()).className = "hover";                
    </script>

    <div class="model_info_content">
        <pe:MemberExtendedGridView ID="EgvUserExpLog" runat="server" AutoGenerateColumns="False"
            CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsUserExpLog" SerialText="" AllowPaging="True"
            OnRowDataBound="EgvUserExpLog_RowDataBound" OnDataBound="EgvUserExpLog_DataBound"
            ShowFooter="True">
            <Columns>
                <pe:BoundField DataField="LogTime" HeaderText="<%$ Res: Controls_PointLog_BoundField1 , 消费时间 %>"
                    DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" SortExpression="LogTime" HtmlEncode="False">
                    <HeaderStyle Width="17%" />
                </pe:BoundField>
                <pe:BoundField DataField="IP" HeaderText="<%$ Res: Controls_PointLog_BoundField2 , IP地址 %>"
                    SortExpression="IP">
                    <HeaderStyle Width="13%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="增加" SortExpression="IncomePayOut">
                    <HeaderStyle Width="10%" />
                    <ItemStyle HorizontalAlign="Right" />
                    <ItemTemplate>
                        <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblIncome">
                        </pe:ExtendedLabel>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="扣除" SortExpression="IncomePayOut">
                    <HeaderStyle Width="10%" />
                    <ItemStyle HorizontalAlign="Right" />
                    <ItemTemplate>
                        <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblPayOut">
                        </pe:ExtendedLabel>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="<%$ Res: Controls_PointLog_TemplateField3 , 备注/说明 %>">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:Label ID="labRemark" runat="server"></asp:Label>
                    </ItemTemplate>
                </pe:TemplateField>
            </Columns>
        </pe:MemberExtendedGridView>
    </div>
    <asp:ObjectDataSource ID="OdsUserExpLog" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserExpLog"
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" SelectCountMethod=""
        StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnUserName" DefaultValue="" Name="userName" PropertyName="Value"
                Type="String" />
            <asp:QueryStringParameter QueryStringField="SearchType" Type="Int32" Name="searchType"
                DefaultValue="10" />
            <asp:Parameter DefaultValue="" Name="keyword" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnUserName" runat="server" />
    </form>
</body>
</html>
