﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Security.Cryptography;
using System.Globalization;


public class Common
{
    // Methods
    public static bool IsNumber(string input)
    {
        if (string.IsNullOrEmpty(input))
        {
            return false;
        }
        return Regex.IsMatch(input, "^[0-9]+$");
    }

    public static string MD5(string input)
    {
        using (MD5CryptoServiceProvider provider = new MD5CryptoServiceProvider())
        {
            return BitConverter.ToString(provider.ComputeHash(Encoding.UTF8.GetBytes(input))).Replace("-", "").ToLower(CultureInfo.CurrentCulture);
        }
    }

    public static string MD5GB2312(string input)
    {
        using (MD5CryptoServiceProvider provider = new MD5CryptoServiceProvider())
        {
            return BitConverter.ToString(provider.ComputeHash(Encoding.GetEncoding("gb2312").GetBytes(input))).Replace("-", "").ToLower(CultureInfo.CurrentCulture);
        }
    }

    public static bool ValidateMD5(string password, string md5Value)
    {
        if (string.Compare(password, md5Value, StringComparison.Ordinal) != 0)
        {
            return (string.Compare(password, md5Value.Substring(8, 0x10), StringComparison.Ordinal) == 0);
        }
        return true;
    }
}

