def toggle_units(int)
	model = Sketchup.active_model
	model.options[0][2] = int
	model.active_view.invalidate
	return nil
end

def toggle_units_validation_proc(int)
  if Sketchup.active_model.options[0][2] == int
    return MF_CHECKED
  else
    return MF_UNCHECKED
  end
end

if not file_loaded?("toggle_units.rb")
	tb = UI::Toolbar.new("Units")
	cmd = UI::Command.new("Inch") { toggle_units(0) }
	cmd.small_icon = cmd.large_icon = File.join(File.dirname(__FILE__),"tuin.gif")
	cmd.tooltip = cmd.status_bar_text = "Unity drawing -> Inch"
	cmd.set_validation_proc { toggle_units_validation_proc(0) }
	tb.add_item(cmd)
	cmd = UI::Command.new("Feet") { toggle_units(1) }
	cmd.small_icon = cmd.large_icon = File.join(File.dirname(__FILE__),"tufe.gif")
	cmd.tooltip = cmd.status_bar_text = "Unity drawing -> Feet"
	cmd.set_validation_proc { toggle_units_validation_proc(1) }
	tb.add_item(cmd)
	tb.add_separator
	cmd = UI::Command.new("Millimeter") { toggle_units(2) }
	cmd.small_icon = cmd.large_icon = File.join(File.dirname(__FILE__),"tumm.gif")
	cmd.tooltip = cmd.status_bar_text = "Unity drawing -> Millimeter"
	cmd.set_validation_proc { toggle_units_validation_proc(2) }
	tb.add_item(cmd)
	cmd = UI::Command.new("Centimeter") { toggle_units(3) }
	cmd.small_icon = cmd.large_icon = File.join(File.dirname(__FILE__),"tucm.gif")
	cmd.tooltip = cmd.status_bar_text = "Unity drawing -> Centimeter"
	cmd.set_validation_proc { toggle_units_validation_proc(3) }
	tb.add_item(cmd)
	cmd = UI::Command.new("Meter") { toggle_units(4) }
	cmd.small_icon = cmd.large_icon = File.join(File.dirname(__FILE__),"tume.gif")
	cmd.tooltip = cmd.status_bar_text = "Unity drawing -> Meter"
	cmd.set_validation_proc { toggle_units_validation_proc(4) }
	tb.add_item(cmd)
	
	state = tb.get_last_state 
	if(state == TB_NEVER_SHOWN)
		tb.show 
	elsif (state == TB_VISIBLE)
		tb.restore
	end
end
file_loaded("toggle_units.rb")




