#  -----------------------Copyright 2004, Jim Patrick--------------------------
# Modified by D. Bur
# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies, and modified copies that work 
# are posted to the SketchUp Forum.
#  -----------------------------------------------------------------------------
# Creates a user-defined 3D grid of construction lines at the picked point
# -----------------------------------------------------------------------------
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY WARRANTIES
# *************NO WARRANTY MEANS NO WARRANTY******************
# -----------------------------------------------------------------------------

require 'sketchup.rb'

# -----------------------------------------------------------------------------

 def create_3d_grid
    
    # Prompts and default values.
    prompts = ["Length (along X)", "Width (along Y)", "Interval", "Number of levels", "Height (between levels)"]
    
    values = [100.cm, 100.cm, 10.cm, 1, 100.cm]

    results = inputbox prompts, values, "Grid parameters"
    width, length, interval, nbr, height = results

# -----------------------------------------------------------------------------

    # Start entity creation.
    model = Sketchup.active_model
    model.start_operation "Creer 3D Grille"

    entities = model.active_entities
# -----------------------------------------------------------------------------
    group = entities.add_group
    entities = group.entities
    
    # initialize step (stepped interval) , which will increment by the Interval
    step = []
    step[0] = 0
    step[1] = 0
    
    # Initialize the endpoints of the lines
    pts = []                    
    pts[0] = [0, step[0], 0]
    pts[1] = [width, 0, 0]
    pts[2] = [0, step[0], 0]
    pts[3] = [0, length, 0]
    
    # Start drawing the clines.
    # Note - these lines are made dotted 'cause I like 'em that way
    # To get different linetypes, replace all "." with other stipples.
    # Stipple choice is dashed "-", long dash "_", dashdot "-.-"
    # The quotation marks MUST be included
    
    while length >= (step[0] + interval)
    	line1 = entities.add_cline(pts[0], pts[1], "." )
    	step[0] = step[0] + interval
    	pts[0] = [0, step[0], 0]
    	pts[1] = [width, step[0], 0]
     end
        # Add one more construction line to finish the rectangle
        line1 = entities.add_cline(pts[0], pts[1], "." )

    while 
        width >= (step[1] + interval)
    	line2 = entities.add_cline(pts[2], pts[3], "." )
    	step[1] = step[1] + interval
    	pts[2] = [step[1], 0, 0]
    	pts[3] = [step[1], length, 0]
     end
        # Add one more construction line to finish the rectangle
    	line2 = entities.add_cline(pts[2], pts[3], "." )

# Close/commit group
    model.commit_operation
    
#----------------------------------------------------------------------------- Duplicates 2D grid
if( nbr > 1 )
h = height
  model.start_operation "Duplicate 3D grid"
  2.upto(nbr) do (group)
    transfo = Geom::Transformation.translation (Geom::Vector3d.new(0, 0, h))
    new_group = group.copy
    new_group.move!(transfo)
    h = h + height
  end
  
end  

#----------------------------------------------------------------------------- That's all folks
model.commit_operation
end

# -----------------------------------------------------------------------------

# Add item "Grid" to the Draw menu.
# First check for existing menu load
if( not file_loaded?("3d_grid.rb") )

    # Add a separator to the menu, but only once
    add_separator_to_menu("Plugins")
    UI.menu("Plugins").add_item("3D Grid") { create_3d_grid }

end

# -----------------------------------------------------------------------------
file_loaded("3d_grid.rb")
