#-----------------------------------------------------------------------
# Copyright 2007, TIG
#-----------------------------------------------------------------------
# Permission to use, copy, modify, and distribute this software for           
# any purpose and without fee is hereby granted, provided that the above      
# copyright notice appear in all copies.
#-----------------------------------------------------------------------
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------
# Name :        Script=AddVertex+.rb, Menu=Add Point, class=AddPoint
# Description : Marks All Vertices in Selection (with cPoints) IF any.
#               Adds cPoint at Picked Point on Edge, Face, other - cLine, 
#               Groups/Components etc, using normal inferences.
#               Edge+Shift=Split-Edge, Face+Alt=Split Face.
#               Undoes each step...
# Version :     1.0 20070331 First Issue.
#               1.1 20070331 Tool Tips Added.
#               1.2 20070401 Edge+Shift=Split-Edge, Face+Alt=Split-Face
#                            Renamed in menu and class.
#               1.3 20070403 Key mapping now allows for Macs too.
#-----------------------------------------------------------------------
require 'sketchup.rb'
#-----------------------------------------------------------------------
### class
class AddPoint
###
def initialize
  @edges=[];@vertices=[];@cpoints=[]
  @key=nil
  @status="Add Point:  Pick a New Point on an Edge, Face or another Element:  Edge + SHIFT = Split-Edge:  Face + ALT = Split-Face ..."
end#def
def reset
  @edges=[];@vertices=[]
  @ip=Sketchup::InputPoint.new
end#def
def activate
  self.reset
  @model=Sketchup.active_model
  @entities=@model.active_entities
  @ss=@model.selection
  @ss.each{|e|@edges.push(e) if e.typename=="Edge"}
  @model.start_operation("Add Point Markers")
  @edges.each{|e|e.vertices.each{|v|@vertices.push(v)}}
  @vertices.uniq!
  @vertices.each{|v|cp=@entities.add_cpoint(v.position)
  @cpoints.push(cp)}
  @ss.clear
  @cpoints.each{|cp|@ss.add(cp)}
  @model.commit_operation
  Sketchup.set_status_text(@status)
end#def
def onKeyDown(key,repeat,flags,view)
  @key="shift" if key==CONSTRAIN_MODIFIER_KEY###
  @key="alt" if key==ALT_MODIFIER_KEY###
end#def
def onKeyUp(key,repeat,flags,view)
  @key=nil
end#def
def onMouseMove(flags,x,y,view)
  @ip.pick(view,x,y)
  view.invalidate
  if @ip.valid?
   if @ip.tooltip=="" || @ip.tooltip=="From Point"
    view.tooltip=""
   else
    view.tooltip=("Add Point: "+@ip.tooltip)
   end#if
  end#if
  Sketchup.set_status_text(@status)
end#def
def deactivate(view)
  @ss.clear
  view.invalidate
end#def
def onLButtonDown(flags,x,y,view)
  @model.start_operation("Add Point")
  ph=@model.active_view.pick_helper
  ph.do_pick(x,y)
  picked_edge=ph.picked_edge
  picked_face=ph.picked_face
  picked_element=ph.picked_element
	@ip.pick(view,x,y)
  if @ip.valid?
    @pt=@ip.position
  else
    picked_edge=nil
    picked_face=nil
    picked_element=nil
  end#if
  if((picked_edge||picked_face)||picked_element)
    cp=nil
    if (picked_face && ((picked_face.parent!=@model)||(@pt.on_plane?(picked_face.edges[0].start,picked_face.normal))))###compo-face or NOT off face
      cp=@entities.add_cpoint(@pt)
    elsif not picked_face
      cp=@entities.add_cpoint(@pt)
    else
      UI.beep
	    Sketchup.set_status_text(@status)
	    return
    end#if
    if cp
      @cpoints.push(cp)
      @ss.add(cp)
    end#if
  else
    UI.beep
	  Sketchup.set_status_text(@status)
	  return
  end#if
  Sketchup.set_status_text(@status)
  if picked_edge && @key=="shift"###
    picked_edge.split(@pt)if picked_edge###split select edge at picked point
  end#if
  if (@entities.include?(picked_face))&&(picked_face && @key=="alt")###
    picked_face.edges.each{|e|
      @entities.add_line(@pt,e.start)
      @entities.add_line(@pt,e.end)
    }###split face with new edges
  end#if
  Sketchup.set_status_text(@status)
  @model.commit_operation
end#def
###
end#class
#-----------------------------------------------------------------------
### menu
is_this_file=File.basename(__FILE__)
if not file_loaded?(is_this_file)
  UI.menu.add_separator
  UI.menu("Plugins").add_item("Add Point"){Sketchup.active_model.select_tool(AddPoint.new)}
  file_loaded(is_this_file)
end#if
#-----------------------------------------------------------------------
