#-----------------------------------------------------------------------
# Name :          IncRandomPushPull
# Description :   PushPulls selected faces by incremented random amount 
#				  within a specifed range.
# Author :        TIG (c)2006
# Usage :         Plugins > Incremented Random Push-Pull... 
#				  Set range in current units, with incremented steps; 
#				  if inc=0 then they're random push-pulled; 
#				  if max-min=inc then they're push-pulled all the same.
# Date :          27/02/06
# Type :          Tool
# History:        1.0 	27/02/06	First issue.
#                 1.1   12/04/07  Simplified Units for v6 / Macs.
#-----------------------------------------------------------------------
require 'sketchup.rb'
def incRandomPushPull
	model=Sketchup.active_model
	model.start_operation "Incremented Random Push-Pull"
	ss=model.selection
	if ss.empty? 
  	UI.messagebox("No Selection.")
  	return nil
	end#if
	faces=[]
	got_face=nil
	for i in ss
		if i.typename=="Face"
			got_face=true
			faces.push(i)
		end#if
	end#for
	if not got_face
    UI.messagebox("No Face in Selection.")
  	return nil
	end#if
	### get current units
units="???"
units="inches" if model.options["UnitsOptions"]["LengthUnit"]==0
units="feet" if model.options["UnitsOptions"]["LengthUnit"]==1
units="mm" if model.options["UnitsOptions"]["LengthUnit"]==2
units="cm" if model.options["UnitsOptions"]["LengthUnit"]==3
units="m" if model.options["UnitsOptions"]["LengthUnit"]==4
### show VCB and status info
   Sketchup::set_status_text(("...PARAMETERS ("+units+")..."),SB_PROMPT)
   Sketchup::set_status_text(" ",SB_VCB_LABEL)
   Sketchup::set_status_text(" ",SB_VCB_VALUE)
	### dialog
	if not $ppmax
	 if units==("inch" or "feet")
		$ppmax=48.0.inch
		$ppmin=4.0.inch
		$ppinc=2.0.inch
	 else
		$ppmax=1000.0.mm
		$ppmin=100.0.mm
		$ppinc=50.0.mm
	 end#if
	end#if
	prompts=["Height (max) : ","Height (min) : ","Increment (0=rand) : "]
	value=[$ppmax,$ppmin,$ppinc]
	results=inputbox prompts,value,("Random Push-Pull Range ("+units+")")
	return nil if not results
	$ppmax=results[0].to_l ###
	$ppmin=results[1].to_l ###
	$ppinc=results[2].to_l
	ppchk=$ppmin
	if $ppmin > $ppmax ### make sure max > min
	   $ppmin=$ppmax
	   $ppmax=ppchk
	end#if
	diff=$ppmax-$ppmin
	$ppinc=diff if $ppinc > diff ### make sure inc is < difference
	for f in faces
		ht=$ppmin+(diff*rand)
		if $ppinc != 0
		   steps=(ht/$ppinc).ceil ###rounds up to nearest integer 
		   f.pushpull(steps*$ppinc) if f.valid?
		else
		   f.pushpull(ht) if f.valid?
		end#if
	end#for
	###
	model.commit_operation
end#def
#-----------------------------------------------------------------------
# add menu items
if not $incRandomPushPull_menu_loaded
  UI.menu("Plugins").add_separator
  UI.menu("Plugins").add_item("Incremented Random Push-Pull") { incRandomPushPull }
end
$incRandomPushPull_menu_loaded=true
#-----------------------------------------------------------------------
