# Name:           CrateTool
# Author :        Tim
# Description:    Create a array of Crates in XY plane or XZ plane or YZ plane
# Usage:          Change dialog box settings or accept defaults, click OK
#                 Make anything from Bookshelves to Grilles to Highrise Curtainwalls.
#                 Can be used together with BoxesTool, which fills in the voids of the crates  
# Type:           Tool
# Date:           2004,12,08
# Revised:       
#--------------------------------------------------------------------------
require 'sketchup.rb'
def crates_xy
    Sketchup::set_status_text("<<<<<< Create an array of Crates: along XY Planes >>>>>", SB_PROMPT)
    $xyheight = 100.cm if not $xyheight 
    $xywidth = 100.cm if not $xywidth
    $xydepth = 100.cm if not $xydepth 
    $xynx = 5 if not $xynx
    $xyny = 5 if not $xyny
    $xydist = 10.cm if not $xydist
    $xyzheight = 0.cm if not $xyzheight
   
    prompts = ["Width", "Height", "Depth"]
    values = [$xywidth, $xyheight, $xydepth]
    results = inputbox prompts, values, "Crate Dimensions"
    $xywidth, $xyheight, $xydepth = results
 #-----------------------------------------------------------------------------
    model = Sketchup.active_model
    model.start_operation "Create Crates"
#-----------------------------------------------------------------------------   
    prompts = [ "No. of Crates along X axis ", "No. of Crates along Y axis ", "Distance btw. Crates", "Height above ground"]

    values = [$xynx, $xyny, $xydist, $xyzheight]
    results = inputbox prompts, values, "Crate Array Size"
    $xynx, $xyny, $xydist, $xyzheight = results
        
    if ($xynx <= 0) then $xynx = 1
    end
    if ($xyny <= 0) then $xyny = 1
    end
    
    $x=0
    $y=0
    
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities
    
    base = entities.add_face([$x, $y, $xyzheight], [$x+$xywidth*$xynx+$xydist*$xynx+$xydist, $y, $xyzheight], [$x+$xywidth*$xynx+$xydist*$xynx+$xydist, $y+$xyheight*$xyny+$xydist*$xyny+$xydist, $xyzheight], [$x, $y+$xyheight*$xyny+$xydist*$xyny+$xydist, $xyzheight])
    base.pushpull -$xydepth
        
       0.upto($xynx-1) do |i|                   # Number of crates along X 
        x = ($xywidth*i)+(i*$xydist)
                    
        0.upto($xyny-1) do |j|                 # Number of crates along Y
          y = ($xyheight*j)+(j*$xydist)
              base = entities.add_face([x+$xydist, y+$xydist, $xyzheight], [x+$xydist+$xywidth, y+$xydist, $xyzheight], [x+$xydist+$xywidth, y+$xydist+$xyheight, $xyzheight], [x+$xydist, y+$xydist+$xyheight, $xyzheight])
              base.pushpull -$xydepth
        end
       end
#-----------------------------------------------------------------------------
    view = model.active_view.zoom_extents 
#-----------------------------------------------------------------------------
    model.commit_operation
end
#-----------------------------------------------------------------------------
def crates_xz
    Sketchup::set_status_text("<<<<<< Create an array of Crates: along XZ Planes >>>>>", SB_PROMPT)
    $xzheight = 100.cm if not $xzheight 
    $xzwidth = 100.cm if not $xzwidth
    $xzdepth = 100.cm if not $xzdepth 
    $xznx = 5 if not $xznx
    $xznz = 5 if not $xznz
    $xzdist = 10.cm if not $xzdist
   
    prompts = ["Width", "Height", "Depth"]
    values = [$xzwidth, $xzheight, $xzdepth]
    results = inputbox prompts, values, "Crate Dimensions"
    $xzwidth, $xzheight, $xzdepth = results
#-----------------------------------------------------------------------------
    model = Sketchup.active_model
    model.start_operation "Create Crates"
#-----------------------------------------------------------------------------   
    prompts = [ "No. of Crates along X axis ", "No. of Crates along Z axis ", "Distance btw. Crates"]

    values = [$xznx, $xznz, $xzdist]
    results = inputbox prompts, values, "Crate Array Size"
    $xznx, $xznz, $xzdist = results
    y=0
    
    if ($xznx <= 0) then $xznx = 1
    end
    if ($xznz <= 0) then $xznz = 1
    end
    
    $x=0
    $z=0
    
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities
    
    base = entities.add_face([$x, y, $z], [$x+$xzwidth*$xznx+$xzdist*$xznx+$xzdist, y, $z], [$x+$xzwidth*$xznx+$xzdist*$xznx+$xzdist, y, $z+$xzheight*$xznz+$xzdist*$xznz+$xzdist], [$x, y, $z+$xzheight*$xznz+$xzdist*$xznz+$xzdist])
    base.pushpull -$xzdepth
       
       0.upto($xznx-1) do |i|                   # Number of crates along X 
        x = ($xzwidth*i)+(i*$xzdist)
                   
        0.upto($xznz-1) do |j|                  # Number of crates along Z
          z = ($xzheight*j)+(j*$xzdist)
               base = entities.add_face([x+$xzdist, y, z+$xzdist], [x+$xzdist, y, z+$xzdist+$xzheight], [x+$xzdist+$xzwidth, y, z+$xzdist+$xzheight], [x+$xzdist+$xzwidth, y, z+$xzdist])           
               base.pushpull -$xzdepth
        end
       end
#-----------------------------------------------------------------------------
    view = model.active_view.zoom_extents 
#-----------------------------------------------------------------------------
    model.commit_operation
end
#-----------------------------------------------------------------------------
def crates_yz
    Sketchup::set_status_text("<<<<<< Create an array of Crates: along YZ Planes >>>>>", SB_PROMPT)
    $yzheight = 100.cm if not $yzheight 
    $yzwidth = 100.cm if not $yzwidth
    $yzdepth = 100.cm if not $yzdepth 
    $yzny = 5 if not $yzny
    $yznz = 5 if not $yznz
    $yzdist = 10.cm if not $yzdist
   
    prompts = ["Width", "Height", "Depth"]
    values = [$yzwidth, $yzheight, $yzdepth]
    results = inputbox prompts, values, "Crate Dimensions"
    $yzwidth, $yzheight, $yzdepth = results
#-----------------------------------------------------------------------------
    model = Sketchup.active_model
    model.start_operation "Create Crates"
#-----------------------------------------------------------------------------   
    prompts = [ "No. of Crates along Y axis ", "No. of Crates along Z axis ", "Distance btw. Crates"]

    values = [$yzny, $yznz, $yzdist]
    results = inputbox prompts, values, "Crate Array Size"
    $yzny, $yznz, $yzdist = results
    x=0
    
    if ($yzny <= 0) then $yzny = 1
    end
    if ($yznz <= 0) then $yznz = 1
    end
    
    $y=0
    $z=0
    
    entities = model.active_entities
    group = entities.add_group
    entities = group.entities
    
    base = entities.add_face([x, $y, $z], [x, $y+$yzwidth*$yzny+$yzdist*$yzny+$yzdist, $z], [x, $y+$yzwidth*$yzny+$yzdist*$yzny+$yzdist, $z+$yzheight*$yznz+$yzdist*$yznz+$yzdist], [x, $y, $z+$yzheight*$yznz+$yzdist*$yznz+$yzdist])
    base.pushpull -$yzdepth
       
       0.upto($yzny-1) do |i|                   # Number of crates along Y 
        y = ($yzwidth*i)+(i*$yzdist)
         
        0.upto($yznz-1) do |j|                 # Number of crates along Z
          z = ($yzheight*j)+(j*$yzdist)
               base = entities.add_face([x, y+$yzdist, z+$yzdist], [x, y+$yzdist, z+$yzdist+$yzheight], [x, y+$yzdist+$yzwidth, z+$yzdist+$yzheight], [x, y+$yzdist+$yzwidth, z+$yzdist])           
               base.pushpull -$yzdepth
        end
       end
#-----------------------------------------------------------------------------
    view = model.active_view.zoom_extents 
#-----------------------------------------------------------------------------
    model.commit_operation
end
if( not file_loaded?("CrateTool.rb") )
    utilities_menu = UI.menu("Plugins").add_submenu("CrateTool")
        utilities_menu.add_item("Crates along XY") { crates_xy }
        utilities_menu.add_item("Crates along XZ") { crates_xz }
        utilities_menu.add_item("Crates along YZ") { crates_yz }
    end
#-----------------------------------------------------------------------------
file_loaded("CrateTool.rb")

