#        Name : extrude_lines
# Description : Creates faces along selected lines at a given height
#      Author : Didier Bur
#       Usage : select lines, select "extrude lines" from the Plugins menu, 
#               enter height and here you go
#        Date : 18.Oct.2oo4
#        Type : tool


require 'sketchup.rb'

def extrude_lines

model = Sketchup.active_model
model.start_operation "Extrude lines"
entities = model.active_entities
ss = model.selection
indice_line = 0

if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end

# Selection error checking
others = 0
i = 0
0.upto(ss.length - 1) do |something|
  element = ss[i]
  if( element.typename != "Edge")
    others = others + 1
  end
  i = i + 1
end  #of upto

if( others != 0 )
  UI.messagebox( others.to_s + " objects in the selection aren't lines and will be ignored.")
end

# sets the default setting
$height = 100.cm if not $height
# Dialog box
prompts = ["Extrusion height  "]
values = [$height]
results = inputbox prompts, values, "Extrusion parameters"
return if not results
$height = results[0].to_l


i = 0
0.upto(ss.length - 1) do |something|
  if( ss[i].typename == "Edge" )
    pts = ss[i].vertices
    v1 = pts[0].position
    v2 = pts[1].position
    v1_top = Geom::Point3d.new(v1.x, v1.y, v1.z + $height)
    v2_top = Geom::Point3d.new(v2.x, v2.y, v2.z + $height)
    Sketchup.active_model.active_entities.add_face(v1, v1_top, v2_top, v2)
  end
  #Next line
    i = i + 1
end # of upto


model.commit_operation
end    # of def


if( not file_loaded?("extrude_lines.rb") )

    # This will add a separator to the menu, but only once
    add_separator_to_menu("Plugins")
    
    # To add an item to a menu, you identify the menu, and then
    # provide a title to display and a block to execute.  In this case,
    # the block just calls the create_box function
    UI.menu("Plugins").add_item("Extrude lines") { extrude_lines }

end

#-----------------------------------------------------------------------------
file_loaded("extrude_lines.rb")