# Name :          Helicoidal Ramp 1.0
# Description :   Create  Curve  Helicoidal  Ramp 
# Author :        ODM
# Web:            http://www.AITOP.com
# E-mail:          ODM@AITOP.com  
# MSN:            ODM@AITOP.COM
# Usage :        Choose "Helicoidal Ramp 1.0" from the context menu |AITOPTools  options
# Date :          4.Sep.2oo4
# Type :          Draw
# History:      1.0 ( 4.Sep.2oo4) - first version
#-----------------------------------------------------------------------------

require 'sketchup.rb'

def hel_ramp
	model = Sketchup.active_model
	entities = model.active_entities
	ss = model.selection
	if (not (ss[0].curve && ss[(ss[0].curve.vertices.length)+1].curve))
		UI.messagebox("Please select only 2 curves")
		return nil
	end
	prompts = ["Height","Low"]
        values = [3500.mm,500.mm]
        results = inputbox prompts, values, "Settings"
        return if not results    
        height,low= results
	$ss1=ss[0].curve
	$ss2=ss[(ss[0].curve.vertices.length)+1].curve
	if (($ss1.vertices.length) < ($ss2.vertices.length))
		$curve1 = $ss2
		$curve2 = $ss1
	else
		$curve1 = $ss1
		$curve2 = $ss2
	end
	$c1=$curve1.vertices
	$c2=$curve2.vertices
	$curve1q = $curve1.vertices.length
	$curve2q = $curve2.vertices.length
	$c11=$c1[0]
	$c12=$c2[0]
	lines0=[]
	0.upto($curve1q-1) do |a|
		lines0[lines0.length]=entities.add_line($c1[a],$c2[a])
		entities[entities.length-1].find_faces
	end
	lines0=[]
	lines1=[]
	lines2=[]
	lines3=[]
	lines4=[]
	b=(height-low)/($curve1q-1)
	low=low-b
	1.upto($curve1q) do |a|
	        $c3=[$c1[a-1].position.x,$c1[a-1].position.y,$c1[a-1].position.z+b*a+low]
		$c4=[$c2[a-1].position.x,$c2[a-1].position.y,$c2[a-1].position.z+b*a+low]
	        lines1[lines1.length]=entities.add_line($c3,$c1[a-1])
		lines2[lines2.length]=entities.add_line($c4,$c2[a-1])
		lines3[lines3.length]=entities.add_line($c3,$c4)
	end
	1.upto($curve2q) do |a|
	        lines4=entities.add_line(lines3[a-1].end,lines3[a].end)
		entities[entities.length-1].find_faces
		lines4=entities.add_line(lines3[a-1].start,lines3[a].start)
		entities[entities.length-1].find_faces
		lines4=entities.add_line(lines3[a-1].start,lines3[a].end)
		entities[entities.length-1].find_faces
	end	
	lines5=[]
        lines5=entities.add_line(lines3[$curve2q].start,lines3[$curve2q].end)
	line5.find_faces
	model.commit_operation
end

#-----------------------------------------------------------------------------

if( not file_loaded?("hel_ramp.rb") )
     UI.add_context_menu_handler do |menu|
        menu.add_separator 
        odm_menu=menu.add_submenu("AITOP Tools")
        odm_menu.add_item("Helicoidal Ramp 1.0") { hel_ramp} 
	odm_menu.add_item("About...") { UI.messagebox "Helicoidal Ramp 1.0\nby ODM\n \n    odm@aitop.com\nhttp://www.aitop.com\n "}
     end
end

#-----------------------------------------------------------------------------
file_loaded("hel_ramp.rb")
