# Name:           line2cyl
# Author :        Didier Bur
# Description:    Create cylinders with selected edges 
# Usage:          select lines, enter diameter and precision
#                  
# Type:           Tool
# Date:           2005,13,01
# Revised:        2005,17,01: add the arcs,curves, and circles followme's

require 'sketchup.rb'

def line2cyl

model = Sketchup.active_model
model.start_operation "Convert arcs/circles/lines to cylinders"
entities = model.active_entities
ss = model.selection
ignored = curv = 0
ss_curves = []

# Selection error checking
if ss.empty? 
  UI.messagebox("No selection.")
  return nil
end


prompts = ["Diameter of cylinder(s)", "Precision  "]
values = [20.to_l,30]
results = inputbox prompts, values, "Parameters"
return if not results
diam = results[0]
prec = results[1]

# first: eliminate edges that are part of curves
ss.each do |e|
  if( e.typename == "Edge" )
    if e.curve
      # this is a curve, remove it from current sel
      ss.toggle(e)
      # add it to the curves array
      ss_curves[curv] = e.curve
      curv = curv + 1
    end
  end
end
ss_curves.uniq!
# second: pushpull the edges
ss.each do |e|
  if( e.typename == "Edge" )
      # this is a normal edge
      vec = e.line[1]
      push = e.length
      ext1 = ss[0].vertices[0].position.to_a
      axes = vec.axes
      circle = Sketchup.active_model.active_entities.add_circle(e.vertices[0], vec, (diam / 2), prec)
      base = Sketchup.active_model.active_entities.add_face(circle)
      base.reverse! if base.normal != vec
      base.pushpull push
    else
    ignored = ignored + 1
  end
end
# third: followme's
ss_curves.each do |c|
  edge1 = c.first_edge
  vec = edge1.line[1]
  all_edges = c.edges
  ext1 = edge1.vertices[0].position.to_a
  axes = vec.axes
  circle = Sketchup.active_model.active_entities.add_circle(edge1.vertices[0], vec, (diam / 2), prec)
  base = Sketchup.active_model.active_entities.add_face(circle)
  base.reverse!
  base.followme all_edges
end

if(ignored > 0 )
  UI.messagebox(ignored.to_s + " objects were not edges and were ignored.")
end
end #of def

if( not file_loaded?("line2cyl.rb") )
    add_separator_to_menu("Plugins")
    UI.menu("Plugins").add_item("Convert arcs/circles/lines to cylinders") { line2cyl }
end
file_loaded("line2cyl.rb")