#author: a4chitect
#licence: your only duty is to share any improvements and/or upgrades of this code under this same condition
#version 0.2
class Lsystem
	def Lsystem::start
		model = Sketchup.active_model
		#get currently selected objects
		selection_set = model.selection
		generations = 4
		maxbranchings = 3
		avoid_obs = true
		#iterations = Math.ldexp(1,generations).to_i  #equals 1 * 2 to the power of generations
		Sketchup.active_model.start_operation "LSystem"
		selection_set.each {|edge|
		 if edge.typename == "Edge" then
		   #create an array of all branching points, each point is saved along with its origin point (parent)
		   branchpoints = []
		   newpoints = []
		   root_vect = edge.vertices[1].position - edge.vertices[0].position
			 upvector = Geom::Vector3d.new(0,0,1)
			 angle = root_vect.angle_between upvector
			 if(angle > (Math::PI/2))
				 root_vect = root_vect.reverse
				 #save the upper starting point along with its parent (~root in the tree terminology)
				 branchpoints[0] = [edge.vertices[0].position,root_vect]
			 else
				 #save the upper point
				 branchpoints[0] = [edge.vertices[1].position,root_vect]
			 end
		   #UI.messagebox branchpoints
		   1.upto(generations) do |generation|
		     a = 0
		     0.upto(branchpoints.length - 1) do |i|
		       #define the starting direction and save this to a direction vector
		       currentpair = branchpoints[i]
		       origin = Geom::Point3d.new currentpair[0]
		       dir_vector = Geom::Vector3d.new currentpair[1]
		       #rot_vector = Geom::Vector3d.new(0,0,1)	#z axis rotation in 2d
		       angle = 0.6
		       branchings = maxbranchings
		       spreadangle = 2*Math::PI/branchings
		       rot_vector = Geom::Vector3d.new(1,0,0)	#perpendicular to the dir_vector
		       #UI.messagebox(rot_vector.to_s)
		       1.upto(branchings) do |b| #fixed number of branchings in one point
		         #UI.messagebox "spreadangle = " + spreadangle.to_s
		         spreadtrans = Geom::Transformation.rotation origin, dir_vector, spreadangle
		         rot_vector = rot_vector.transform spreadtrans
		         #rotation of the branch
		         transformation = Geom::Transformation.rotation origin, rot_vector, angle
		         new_vector = dir_vector.transform transformation
		         #shorten this branch by the following factor
		         lengthvar = (8-rand(4)).to_f/10  #results in numbers: 0.9, 0.8, 0.7, 0.6, 0.5
		         new_vector.length = dir_vector.length*lengthvar
		         if(avoid_obs) then #try to avoid any intersection before it occurs by skipping the current branch
		            rt = Sketchup.active_model.raytest(origin,new_vector)
		            if (not rt == nil) then
		              obst_dist = Geom::Vector3d.new(origin,rt[0])
		              if (obst_dist.length > new_vector.length) then
		                create = true
		              else
		                create = false
		              end
		            else
		              create = true
		            end
		         else
		            create = true
		         end
		         if (create) then
		            new_point = origin + new_vector
		            #create new branch
		            Sketchup.active_model.active_entities.add_edges origin, new_point
		            #add this point for later branching (next iteration)
		            newpoints[a] = [new_point, new_vector]
		            a = a + 1
		         end
		       end
		     end
		     #repopulate branchpoints after each generation
		     branchpoints = newpoints.clone
		     newpoints.clear
		   end			
		 end
		}
		Sketchup.active_model.commit_operation
	end #def
end #class
if( not $lsystem_menu_loaded )
	UI.menu("Plugins").add_item("Lsystem") { Lsystem.start }
	$lsystem_menu_loaded = true
end