# Copyright 2004, Rick Wilson 
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Name :          xlines.rb 1.0
# Description :   Convert selected edges to construction lines
# Author :        Rick Wilson
# Usage :         1.	Install into the plugins directory or into the 
#				Plugins/examples directory and manually load from the
#				ruby console "load 'examples/xlines.rb'" 
#                 2.	Select "Convert to xLine" from the context menu after
#				selecting an edge.
# Date :          2008-01-21
# Type :          Tool
# History:
#			1.1 (2008-01-21) - updated to put resultant geometry in the same entity space as the original
#			1.0 (2004-08-20) - first version
# 
require 'sketchup.rb'

def xLine
	model=Sketchup.active_model
	ents=model.active_entities
	sel=model.selection
	lines=[]
	model.start_operation "xLine"
	for e in sel
		if e.class == Sketchup::Edge
			lstart=e.start.position
			lend=e.end.position
			ents.add_cline(lstart,lend)
			lines.push(e)
		end
	end
	if not lines.empty?
		for e in lines
			e.erase! if e.valid? #if e.faces.empty?
 		end
	end
	model.commit_operation
end

def xLine_validate_selection
	Sketchup.active_model.selection.each {|e| return true if e.class == Sketchup::Edge}
	return nil
end


if( not file_loaded?("xLine.rb") )
	UI.add_context_menu_handler do |menu|
		if xLine_validate_selection
			menu.add_separator
			menu.add_item("Convert to xLine") { xLine }
		end
	end
end

#-----------------------------------------------------------------------------
file_loaded("xLine.rb")