# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Name :          xline2line.rb
# Description :   Convert selected xlines to lines
# Author :        TIG - based heavily on Rick Wilson's xline.rb
# Usage :         1.	Install into the Plugins directory.
#                 2.	Select "Edges from Construction Lines" from the 
#						context-menu after selecting xline(s), note 
#						that 'infinitely long' xlines are ignored.
# Date :          Feb 15 06
# Type :          Tool
# History:		
require 'sketchup.rb'
def xLine2Line
	model=Sketchup.active_model
	ents=model.entities
	sel=model.selection
	clines=[]
	model.start_operation "xLine2Line"
	for e in sel
		if e.class == Sketchup::ConstructionLine
			lstart=e.start if e.start
			lend=e.end if e.end
			ents.add_line(lstart,lend) if e.start and e.end
			clines.push(e)
		end
	end
	if not clines.empty?
		for e in clines
			e.erase! if e.valid? and e.start and e.end
 		end
	end
	model.commit_operation
end
def xLine2Line_validate_selection
	Sketchup.active_model.selection.each {|e| return true if e.class == Sketchup::ConstructionLine}
	return nil
end
if( not file_loaded?("xLine2Line.rb") )
	UI.add_context_menu_handler do |menu|
		if xLine2Line_validate_selection
			menu.add_separator
			menu.add_item("Edges from Construction Lines") { xLine2Line }###
		end
	end
end
#-----------------------------------------------------------------------
file_loaded("xLine2Line.rb")

