# auto_centerpoint.rb v1.0
# Copyright (c) 2008 jim.foltz@gmail.com

require "sketchup"
require "ruby/singleton"

class ACPToolsObserver < Sketchup::ToolsObserver
  include Singleton

  def attach
    @eo = EntitiesObserver.new
    Sketchup.active_model.tools.add_observer self
    @last = nil
  end

  def detach
    Sketchup.active_model.tools.remove_observer self
  end

  def onToolStateChanged(*args)
    return unless args[1] == "CircleTool"
    print "onToolStateChanged: "
    p args
    st = args[3]
    if st == 1
      puts "Circle tool activated."
      Sketchup.active_model.active_entities.add_observer @eo
      @eo.start_recording
      @last = st
    else
      if @last == 1
	puts "Circle done."
	@eo.stop_recording
	add_cpoint
      end
      @last = 0
    end
    def add_cpoint
      edge = @eo.q
      @eo.clear
      p edge
      Sketchup.active_model.active_entities.add_cpoint edge.curve.center
      Sketchup.active_model.active_entities.remove_observer @eo
    end
  end
end

class EntitiesObserver < Sketchup::EntitiesObserver
  def initialize
    @st = 0
    @q = []
  end
  def start_recording
    @st = 1
  end
  def stop_recording
    @st = 0
  end
  def clear
    @q = []
  end
  def q
    @q[0]
  end
  def onElementAdded(*args)
    #print "onElementAdded:"
    #p args
    if @st == 1
      @q << args[1] if args[1].is_a? Sketchup::Edge
    end
  end
  def onElementRemoved(*args)
    print "onElementRemoved:"
    p args
  end
  def onContentsModified(*args)
    print "onContentsModified:"
    p args
  end
  def onEraseEntities(*args)
    print "onEraseEntities:"
    p args
  end
  def method_missing(m, *args, &b)
    print "method_missing:"
    p m, args, b
  end
end

file = File.basename __FILE__
unless file_loaded?(file)
  m = UI.menu("Plugins").add_submenu("Auto Centerpoint")
  m.add_item("On") { ACPToolsObserver.instance.attach }
  m.add_item("Off") { ACPToolsObserver.instance.detach }
  file_loaded file
end
