# Copyright(C) 2007-2008, G. Terry Ross
# Portions Copyright 2005, @Last Software, Inc.

# DISCLAIMER OF WARRANTIES
# BECAUSE THIS SOFTWARE IS PROVIDED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE SOFTWARE.
# THE SOFTWARE IS PROVIDED "AS IS" WITH ALL FAULTS AND WITHOUT WARRANTY OF ANY KIND,    
# EITHER EXPRESSED, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES AND/OR CONDITIONS OF MERCHANTABILITY, OF SATISFACTORY QUALITY,
# OF FITNESS FOR A PARTICULAR PURPOSE OR USE, OF ACCURACY, OF QUIET ENJOYMENT,
# AND OF NON-INFRINGEMENT OF THIRD PARTY RIGHTS.
# THERE IS NO WARRANTY AS TO THE SOFTWARE'S PERFORMANCE, AGAINST INTERFERENCE WITH
# YOUR ENJOYMENT OF THE SOFTWARE, THAT THE FUNCTIONS CONTAINED IN THE SOFTWARE
# WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION OF THE SOFTWARE WILL BE
# UNINTERRUPTED OR ERROR-FREE, OR THAT DEFECTS IN THE SOFTWARE WILL BE CORRECTED.
# YOU EXPRESSLY ACKNOWLEDGE AND AGREE THAT USE OF THE SOFTWARE IS AT YOUR SOLE RISK
# AND THAT THE ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY AND EFFORT
# IS WITH YOU.  SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE ENTIRE COST
# OF ALL NECESSARY SERVICING, REPAIR, OR CORRECTION.
# NO ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY THE SOFTWARE PROVIDER
# SHALL CREATE A WARRANTY.

Sketchup::require 'ctsMaker/ctsMaker'
cts_init

if( not file_loaded?( "curve_menu.rb" ) )###
  utilities_menu = UI.menu("Plugins").add_submenu( $ctmStrings.GetString( "Curve Maker" ) )
  utilities_menu.add_item( $ctmStrings.GetString( "Draw a Curve" ) ) { maker( $curve ) }
  utilities_menu.add_item( $ctmStrings.GetString( "Display Curve Data" ) ) { display_data( $curve ) }
  utilities_menu.add_item( $ctmStrings.GetString( "Select Curves by Attribute" ) ) { select_by_attribute_value( $curve ) } 
  utilities_menu.add_item( $ctmStrings.GetString( "About Curve Maker" ) ) { about_maker( $curve ) }

end
#-----------------------------------------------------------------------------
file_loaded( "curve_menu.rb" )###
