=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed April / July 2008 by Fredo6

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   Zloader__OnSurface.rb
# Original Date	:   04 June 2008 - version 1.2
# Type			:   Sketchup Tools
# Description	:   Loader for the Suite of Tools to draw on a surface
# Menu Items	:   Tools --> submenu "Tools on Surface"
# Toolbar		:   Name = "Surface Operations"
# Usage			:   See Tutorial and Quick Ref Card in PDF format
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

require 'sketchup.rb'

module Loader_SUToolsOnSurface

def Loader_SUToolsOnSurface.require_modules
	t0 = Time.now
	subdir = Loader_SUToolsOnSurface.plugin_subdir(__FILE__) + "/"
	
	require subdir + 'LibTraductor_20.rb'
	
	require subdir + 'LibOnSurface.rb'
	require subdir + 'LineOnSurface.rb'
	require subdir + 'ShapeOnSurface.rb'
	require subdir + 'OffsetOnSurface.rb'
	require subdir + 'FreehandOnSurface.rb'
	require subdir + 'EraserOnSurface.rb'
	require subdir + 'PolylineOnSurface.rb'
	
	@@load_time = Time.now - t0
end

def Loader_SUToolsOnSurface.plugin_subdir(filename)
	filepath = File.expand_path filename
	l = filepath.split /\//
	jindex = -1
	for i in 0..l.length - 1
		if l[i] =~ /Plugins/i
			jindex = i
			break
		end
	end
	File.join l[(jindex+1)..-2]
end
	
def Loader_SUToolsOnSurface.get_load_time
	@@load_time
end
	
end	#module _Loader_SUToolsOnSurface

module SUToolsOnSurface

#Constants for the loading environment
TOS_SCRIPT = "Tools on Surface"
TOS_VERSION = "1.31"
TOS_DIR = Loader_SUToolsOnSurface.plugin_subdir(__FILE__)
TOS_TOOLBAR = "Surface Operations"
TOS_MENU_SU = "Tools"
NAMECONV_ICON = "TOS_icon_"
NAMECONV_CURSOR = "TOS_cursor_"
NAMECONV_LINE = "_Line"
NAMECONV_CLINE = "_Cline"
SU_MAJOR_VERSION_6 = (Sketchup.version[0..0] > '5')	

TOS_TITLE_SUBMENU = ["Tools On Surface",
                     "|FR| Outils sur Surface"]


#--------------------------------------------------------------------------------------------------------------
# Public methods of module for EraserOnSurface (Menu and Tool bar)
#--------------------------------------------------------------------------------------------------------------

def SUToolsOnSurface.manage_command

	#Creating the main menu in Tools
	submenu_name = Traductor[TOS_TITLE_SUBMENU]
	family = Traductor::CommandFamily.new TOS_DIR, TOS_MENU_SU, submenu_name, TOS_TOOLBAR, true
	iconconv = NAMECONV_ICON

	#loading line tool
	text = Traductor[STR_Line_Title]
	family.add_command(text, text, TOS_ICON_LINE, iconconv, nil) { SUToolsOnSurface.launch_line }
	family.add_toolbar_separator
	family.add_menu_separator

	#loading all shapes
	SUToolsOnSurface.load_shapes family, iconconv
	family.add_menu_separator
	family.add_toolbar_separator
	
	#loading Offset tool
	title = Traductor[STR_Ofs_Title]
	tooltip = Traductor[STR_Ofs_Tooltip]
	family.add_command(title, tooltip, TOS_ICON_OFFSET, iconconv, nil) { SUToolsOnSurface.launch_offset true }

	#Free hand tool
	text = Traductor[STR_Freehand_Title]
	family.add_command(text, text, TOS_ICON_FREEHAND, iconconv, nil) { SUToolsOnSurface.launch_freehand }
	
	family.add_toolbar_separator
	family.add_menu_separator
	
	#loading Edition tools
	text = Traductor[STR_PolyLine_Title]
	family.add_command(text, text, TOS_ICON_POLYLINE, iconconv, nil) { SUToolsOnSurface.launch_polyline }
	
	text = Traductor[STR_Eraser_Title]
	family.add_command(text, text, TOS_ICON_ERASER, iconconv, nil) { SUToolsOnSurface.launch_eraser }
	
	#Loading help section
	HELP.manage_menu family
	
	family.show_toolbar

	UI.add_context_menu_handler do |menu|
		ledge = SUToolsOnSurface.check_if_polyline Sketchup.active_model.selection
		if ledge
			menu.add_separator
			menu.add_item(Traductor[STR_PolyLine_Title]) { SUToolsOnSurface.launch_polyline ledge}
		end	
		if VoidTriangle.selection_check_for_menu(false)
			menu.add_item(Traductor[STR_VoidTriangle]) { VoidTriangle.selection_check_for_menu true}
		end	
	end	
end

unless $Loader__OnSurface_____loaded
	Loader_SUToolsOnSurface.require_modules
	SUToolsOnSurface.manage_command
	$Loader__OnSurface_____loaded = true
end
	
end	#End Module SUToolsOnSurface
