=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed April / July 2008 by Fredo6

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   Zloader__OnSurface.rb
# Original Date	:   04 June 2008 - version 1.2
#				:	12 July 2008 - version 1.3 (new config for installation)
# Type			:   Sketchup Tools
# Description	:   Loader for the Suite of Tools to draw on a surface
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

require 'sketchup.rb' 
require 'extensions.rb' 

version = "1.31"
folder = "TOS_Dir_13"
sdate = "14 Jul 2008"

path = File.join(File.dirname(__FILE__), folder, "LoaderOnSurface.rb") 
if Sketchup.get_locale == "FR"
	ext = SketchupExtension.new("Outils sur Surface", path) 
	ext.description = "Suite d'outil de dessin sur surface" 
else
	ext = SketchupExtension.new("Tools on Surface", path) 
	ext.description = "Suite of tools to draw on surface" 
end	
ext.creator = "Fredo6" 
ext.version = version + " - " + sdate 
ext.copyright = "Fredo6" 
Sketchup.register_extension ext
