require 'extensions.rb'
require 'LangHandler.rb'

# Extension Manager
$uStrings = LanguageHandler.new("Projection")
#Projection_Extension = SketchupExtension.new $uStrings.GetString("Projection"), "Projection/projection.rb"
Projection_Extension = SketchupExtension.new $uStrings.GetString("Projection"), "Projection/projection.rb"
Projection_Extension.description=$uStrings.GetString("Various projection functions set.")
Projection_Extension.name= "Projections"
Projection_Extension.creator = "Didier Bur"
Projection_Extension.copyright = "12.2005, CRAI - Didier Bur"
Projection_Extension.version = "1.0"

Sketchup.register_extension Projection_Extension, true

# Run
def exec_on_autoload
  puts("Projections loaded.")
end


#-----------------------------------------------------------------------------------------------------
#                                        MENU ITEMS
#-----------------------------------------------------------------------------------------------------

if( not $projections_menu_loaded )

  #Projection toolbar
  #-----------------------------------------------------------------------------------------
  gp_project_tb = UI::Toolbar.new("Projections")

  #Add Cpoint
  cmd0 = UI::Command.new(("Insert construction point")) { Sketchup.active_model.select_tool AddCpointTool.new }
  cmd0.small_icon = "Projection/Const_Point_Small.png"
  cmd0.large_icon = "Projection/Const_Point_Large.png"
  cmd0.tooltip = "Insert construction point"
  gp_project_tb.add_item(cmd0)
  #Project point on line
  cmd1 = UI::Command.new(("Point perpendicular to line")) { (project_point_line) }
  cmd1.small_icon = "Projection/Point_sur_ligne_Small.png"
  cmd1.large_icon = "Projection/Point_sur_ligne_Large.png"
  cmd1.tooltip = "Project selected point perpendicular to selected line"
  gp_project_tb.add_item(cmd1)
  #Project point on plane
  cmd2 = UI::Command.new(("Point perpendicular to plane")) { (project_point_plane) }
  cmd2.small_icon = "Projection/Point_sur_plan_Small.png"
  cmd2.large_icon = "Projection/Point_sur_plan_Large.png"
  cmd2.tooltip = "Project selected point perpendicular to selected face"
  gp_project_tb.add_item(cmd2)
  #Norml line through point
  cmd21 = UI::Command.new(("Line perpendicular to plane through point")) { Sketchup.active_model.select_tool AddNormalLineTool.new }
  cmd21.small_icon = "Projection/Normale_par_point_Small.png"
  cmd21.large_icon = "Projection/Normale_par_point_Large.png"
  cmd21.tooltip = "Draw a line perpendicular to selected face through point"
  gp_project_tb.add_item(cmd21)
  #Project lines on plane
  cmd3 = UI::Command.new(("Lines perpendicular to plane")) { (project_lines_plane) }
  cmd3.small_icon = "Projection/Lignes_sur_plan_Small.png"
  cmd3.large_icon = "Projection/Lignes_sur_plan_Large.png"
  cmd3.tooltip = "Project selected lines perpendicular to selected face"
  gp_project_tb.add_item(cmd3)
  #Project line on planes
  cmd4 = UI::Command.new(("Line perpendicular to planes")) { (project_line_planes) }
  cmd4.small_icon = "Projection/Ligne_sur_plans_Small.png"
  cmd4.large_icon = "Projection/Ligne_sur_plans_Large.png"
  cmd4.tooltip = "Project selected line perpendicular to plane"
  gp_project_tb.add_item(cmd4)
  #Project faces perpendicular to plane
  cmd5 = UI::Command.new(("Faces perpendicular to plane")) { Sketchup.active_model.select_tool ProjectFacesPerpendicularTool.new }
  cmd5.small_icon = "Projection/Faces_sur_plan_Small.png"
  cmd5.large_icon = "Projection/Faces_sur_plan_Large.png"
  cmd5.tooltip = "Project selected faces perpendicular to plane"
  gp_project_tb.add_item(cmd5)
  #Project faces on plane along vector
  cmd6 = UI::Command.new(("Faces to plane along vector")) { Sketchup.active_model.select_tool ProjectFacesVectorTool.new }
  cmd6.small_icon = "Projection/Faces_sur_plan_vecteur_Small.png"
  cmd6.large_icon = "Projection/Faces_sur_plan_vecteur_Large.png"
  cmd6.tooltip = "Project selected faces on plane along vector"
  gp_project_tb.add_item(cmd6)
  #Cline at intersection of selected faces
  cmd7 = UI::Command.new(("Create construction lines at intersection of faces")) { (CLineFaceIntersect.createCLineAtFaceIntersection if CLineFaceIntersect.check_selection ) }
  cmd7.small_icon = "Projection/o_ligne_intersection_faces_S.png"
  cmd7.large_icon = "Projection/o_ligne_intersection_faces_L.png"
  cmd7.tooltip = "Create lines at intersection of selected faces"
  gp_project_tb.add_item(cmd7)
  #Push-pull along vector
  cmd9 = UI::Command.new(("Push-Pull faces along vector")) { Sketchup.active_model.select_tool PushPullFacesVectorTool.new }
  cmd9.small_icon = "Projection/Pousser-tirer_vecteur_Small.png"
  cmd9.large_icon = "Projection/Pousser-tirer_vecteur_Large.png"
  cmd9.tooltip = "Push-Pull selected faces along vector"
  gp_project_tb.add_item(cmd9)
  #Push-pull along their normals
  cmd10 = UI::Command.new(("Push-Pull faces along their normals")) { (extrude_faces_along_normal) }
  cmd10.small_icon = "Projection/Pousser-tirer_normales_Small.png"
  cmd10.large_icon = "Projection/Pousser-tirer_normales_Large.png"
  cmd10.tooltip = "Push-Pull selected faces along their normals"
  gp_project_tb.add_item(cmd10)
  #Push-pull along their normals, random within rage
  cmd101 = UI::Command.new(("Push-Pull faces randomly")) { (randomPushPull) }
  cmd101.small_icon = "Projection/Pousser-tirer_aleatoire_Small.png"
  cmd101.large_icon = "Projection/Pousser-tirer_aleatoire_Large.png"
  cmd101.tooltip = "Push-Pull faces randomly within an interval"
  gp_project_tb.add_item(cmd101)
  #Extrude lines along vector
  cmd11 = UI::Command.new(("Extrude lines")) { Sketchup.active_model.select_tool ExtrudeLineTool.new }
  cmd11.small_icon = "Projection/Extruder_lignes_Small.png"
  cmd11.large_icon = "Projection/Extruder_lignes_Large.png"
  cmd11.tooltip = "Extrude selected lines along vector"
  gp_project_tb.add_item(cmd11)
  
# End of load
$projections_menu_loaded = true
end
file_loaded("projection_extension.rb")
