require  'sketchup.rb' # Link Sketchup 6.0
class Analysis
    def initialize()
        @volume = 0
    end
    
    def cal_volume(model,i)
        for e in model
            if e.kind_of? Sketchup::Group
                cal_volume(e.entities, i)
            else
                if e.kind_of? Sketchup::Face
                    Sketchup.set_status_text('Calculating volumes of seed#'+ i.to_s + '...'+e.to_s)
                    @volume = @volume + (e.area*e.vertices[0].position.to_a.dot(e.normal))/3
                end
            end
        end
        return ((@volume* 0.000016387064 *1000).round.to_f/1000)*0.15*0.15*0.15 #meter3
    end
    
    
end

class Geom::Point3d
   def dot(v)
      self.x * v.x + self.y * v.y + self.z * v.z
   end
end
