# ------------------------------------------------------------------------------Define Bezier_curve
# Evaluate a Bezier curve at a parameter.
# The curve is defined by an array of its control points.
# The parameter ranges from 0 to 1
# This is based on the technique described in "CAGD  A Practical Guide, 4th Editoin"
# by Gerald Farin. page 60
# This code is fixed by Yi

require File.dirname(__FILE__) + '/Rational.rb'

class Bezier_curve < Sketchup::Edge
  
  def eval(pts, t)

      degree = pts.length - 1.0
      if degree < 1.0
          return nil
      end
      
      t1 = 1.0 - t
      fact = 1.0
      n_choose_i = 1.0
      x = 0.0
      y = 0.0
      z = 0.0

      for i in 0..degree
      fact = Rational.fact(degree) / Rational.fact(i) / Rational.fact(degree - i) # factorial coef
      x = x + fact*pts[i].x * Rational.pow(t1, degree - i) * Rational.pow(t, i)
      y = y + fact*pts[i].y * Rational.pow(t1, degree - i) * Rational.pow(t, i)
      z = z + fact*pts[i].z * Rational.pow(t1, degree - i) * Rational.pow(t, i)
      end

      Geom::Point3d.new(x, y, z)
      
  end # method eval
  
  # Evaluate the curve at a number of points and return the points in an array
  def points(pts, numpts)
      
      curvepts = []
      dt = 1.0 / numpts

      # evaluate the points on the curve
      for i in 0..numpts
          t = i * dt
          curvepts[i] = eval(pts, t)
      end
      
      curvepts
  end
  
  # Create a Bezier curve in SketchUp
  # Using 3 or more control points
  def curve(pts, numseg, entities)
      curvepts = points(pts, numseg)
      # create the curve
      if (entities != nil)
          edges = entities.add_curve(curvepts)
      end

      return curvepts
  end

end
# ------------------------------------------------------------------------------Define Bezier_curve
