# ------------------------------------------------------------------------------Define Bezier_surface
class Bezier_surf

    @@MAX_ORDER = 3
    @@DFLT_NR_STEPS = 8
    
    @@C = []
    @@B = []
    
    attr_reader :uSteps, :vSteps
    attr_writer :ctrlPts
    
    def Bezier_surf.selected_patch
        active_sel = Sketchup.active_model.selection
        return nil if active_sel.count != 1
        item = active_sel.first
        return nil if ! item.get_attribute('BezPatch', 'ctrlPts')
        return item
    end

    def Bezier_surf.lines(pts, m, n)
        if (pts.length != (m+1)*(n+1))
            UI.messagebox "Array of points is not #{m+1}x#{n+1}"
            return nil
        end
        
        uLines = []
        vLines = []
        for j in (0..n)
            uLines[j] = []
        end
        for i in (0..m)
            vLines[i] = []
        end
        p = 0
        for j in (0..n)
            for i in (0..m)
                pt = pts[p]
                uLines[j].push(pt)
                vLines[i].push(pt)
                p += 1
            end
        end
        
        return [uLines, vLines]
    end
    
    def _init_order_coeffs(nOrder)
        if (@@C[nOrder])
            return @@C[nOrder]
        end
        
        # Precalculate factorials
        facs = []
        facs[0] = 1.0
        for i in (1..nOrder)
            facs[i] = i * facs[i-1]
        end
        
        @@C[nOrder] = []
        for i in (0..nOrder)
            @@C[nOrder][i] = facs[nOrder] / (facs[i]*facs[nOrder-i])
        end
        
        return @@C[nOrder]
    end
    
    def _init_bernstein_polys(nOrder, nSteps)
        if (@@B.length == 0)
            # One time allocation
            for i in (0..@@MAX_ORDER)
                @@B[i] = []
            end
        end
        
        if (@@B[nOrder][nSteps])
            return @@B[nOrder][nSteps]
        end
        
        tStep = 1.0 / nSteps
        b = []
        for i in (0..nOrder)
            b[i] = []
            for iStep in (0..nSteps)
                t = tStep * iStep
                tC = 1.0 - t
                b[i][iStep] = @@C[nOrder][i] * (t**i) * (tC**(nOrder-i))
            end
        end
        @@B[nOrder][nSteps] = b
        
        return b
    end

    def initialize(*args)
        data = args[0]
        return if not data
    
        return if not validate_parameters(data)
       
       # Set params.
       @uOrder = data['uOrder'].to_i
       @vOrder = data['vOrder'].to_i
       @ctrlPts = data['ctrlPts']
       @uSteps = data['uSteps'] ? data['uSteps'].to_i : @@DFLT_NR_STEPS
       @vSteps = data['vSteps'] ? data['vSteps'].to_i : @@DFLT_NR_STEPS
       #@bezType = data['bezType'] || 'Patch'
       
       # Init coefficients if not already done.
       [@uOrder, @vOrder].each do |nOrder|
           _init_order_coeffs(nOrder)
           [@uSteps, @vSteps].each do |nSteps|
               _init_bernstein_polys(nOrder, nSteps)
           end
       end
       
        if (args[1].kind_of? Geom::Transformation)
            @transformation = args[1]
        else
            @transformation = Geom::Transformation.axes(
                ORIGIN, X_AXIS, Y_AXIS, Z_AXIS)
        end
        
    end
    
    def validate_parameters(data)
        # Validate bezier orders
        uOrder = data['uOrder'].to_i
        vOrder = data['vOrder'].to_i
        [uOrder, vOrder].each do |order|
            if (order < 2 || order > @@MAX_ORDER)
                _msg "Bezier patch order must be 2 < x < #{@@MAX_ORDER}"
                return nil
            end
        end
        
        # Validate that number of control points given matches bez orders
        if (! data['ctrlPts'])
            _msg %q(Must pass array of control points as 'ctrlPts')
            return nil
        end
        n = (uOrder+1) * (vOrder+1)
        if (data['ctrlPts'].length != n)
            _msg "Wrong number of control points (should have #{n})"
            return nil
        end
        
        return data
    end
    
    def _msg(msg)
        UI.messagebox("Bezier Patch:\n" + msg)
    end
    
    def eval(sStep, tStep)
        pt = Geom::Point3d.new(0.0, 0.0, 0.0)
        sB = @@B[@uOrder][@uSteps]
        tB = @@B[@vOrder][@vSteps]
        p = 0
        for j in (0..@vOrder)
            for i in (0..@uOrder)
                f = sB[i][sStep] * tB[j][tStep]
                pt.x += f * @ctrlPts[p].x
                pt.y += f * @ctrlPts[p].y
                pt.z += f * @ctrlPts[p].z
                p += 1
            end
        end
        return pt
    end
    
    def uSteps=(uSteps)
        @uSteps = uSteps
        [@uOrder, @vOrder].each do |nOrder|
            _init_bernstein_polys(nOrder, uSteps)
        end
    end
    
    def vSteps=(vSteps)
        @vSteps = vSteps
        [@uOrder, @vOrder].each do |nOrder|
            _init_bernstein_polys(nOrder, vSteps)
        end
    end
    
    def points
        pts = []
        for j in (0..@vSteps)
            for i in (0..@uSteps)
                pts.push(self.eval(i, j))
            end
        end
        return pts
    end
    
    def create_patch(entities)
        model = Sketchup.active_model
        
        # Set custom attributes for group, so they may be recovered upon
        # editing.  I convert the control points from Point3ds to simple
        # arrays because for some reason the Point3ds get changed when 
        # the group is moved or rotated.
        #@group = model.active_entities.add_group
        #@group.set_attribute('BezPatch', 'uOrder', @uOrder)
        #@group.set_attribute('BezPatch', 'vOrder', @vOrder)
        #@group.set_attribute('BezPatch', 'uSteps', @uSteps)
        #@group.set_attribute('BezPatch', 'vSteps', @vSteps)
        #@group.set_attribute('BezPatch', 'bezType', @bezType)
        ctrlPts = []
        @ctrlPts.each do |pt|
            ctrlPts.push([pt.x, pt.y, pt.z])
        end
        #@group.set_attribute('BezPatch', 'ctrlPts', ctrlPts)
        #@group.transformation = @transformation
        #entities = @group.entities
        
        lines = Bezier_surf.lines(self.points, @uSteps, @vSteps)
        uLines = lines[0]
        vLines = lines[1]
        
        for j in (0...@vSteps)
            for i in (0...@uSteps)
                pt0 = vLines[i][j]
                pt1 = vLines[i+1][j]
                pt2 = vLines[i][j+1]
                pt3 = vLines[i+1][j+1]
                entities.add_face(pt0, pt1, pt2)
                entities.add_face(pt1, pt2, pt3)
            end
        end
        return @group
        model.commit_operation
    end
    
end


# ------------------------------------------------------------------------------Define Bezier_surface
