require  File.dirname(__FILE__) + '/Population.rb' # GA Population class
require  File.dirname(__FILE__) + '/Genotype.rb' # GA Genotype class
require  File.dirname(__FILE__) + '/Matchbox_r.rb' # Matchbox class
require  File.dirname(__FILE__) + '/Inputbox.rb' # Inputbox class from jim.foltz@gmail.com
require  File.dirname(__FILE__) + '/Analysis.rb' # Analysis methods
require  'sketchup.rb' # Link Sketchup 6.0

class IGA
@@pluginDirectory = File.dirname(__FILE__)
@@title1 = 'Initialize'
@@title2 = 'Evolve'
@@title3 = 'Load from seed'
@@title4 = 'Save seed(s)'
@@title5 = 'Undo'
@@title6 = 'Calculate volume'
@@title7 = 'List evolution tree'

@@population_size = 4.0
@@genotype_length = 41.0

##
# Main entry point
##
    def initialize()
      
        # Somehow we do not have a current directory. Alert the user and end.
        if !File.directory?(@@pluginDirectory)
          alert(@@title1 + " plugin has encountered an error:\n" +
                "Could not find the plugin directory. " +
                "Please re-install the plugin.")
          return
        end

        # make sure the plugin was installed correctly
        tempImgDirectory = @@pluginDirectory + "/images"
        if !File.directory?(tempImgDirectory) || 
           !File.writable?(tempImgDirectory) 
          alert(@@title1 + " plugin has encountered an error:\n" +
                "Could not find or could not write temporary images to:\n" +
                "[" + tempImgDirectory + "]\n" + 
                "Please re-install the plugin.")
          return
        end
        
        matchbox_menu = UI::menu('Plugins').add_submenu('Matchbox')
        @cmd = UI::Command.new(@@title1) {randomize()}
        @cmd.small_icon = tempImgDirectory + "/MatchboxButtontb.png"
        @cmd.large_icon = tempImgDirectory + "/MatchboxButtontb.png"
        @cmd.status_bar_text = @cmd.tooltip = @@title1
        @cmd.menu_text = @@title1
        @matchboxToolbar = UI::Toolbar.new(@@title1)
        @matchboxToolbar.add_item(@cmd)
        matchbox_menu.add_item(@cmd)

        @cmd2 = UI::Command.new(@@title2) {evolve()}
        @cmd2.small_icon = tempImgDirectory + "/MatchboxButtontb_evolve.png"
        @cmd2.large_icon = tempImgDirectory + "/MatchboxButtontb_evolve.png"
        @cmd2.status_bar_text = @cmd2.tooltip = @@title2
        @cmd2.menu_text = @@title2
        @matchboxToolbar.add_item(@cmd2)
        matchbox_menu.add_item(@cmd2)
        
        @matchboxToolbar.add_separator
        matchbox_menu.add_separator

        @cmd3 = UI::Command.new(@@title3) {seed()}
        @cmd3.small_icon = tempImgDirectory + "/MatchboxButtontb_from_seed.png"
        @cmd3.large_icon = tempImgDirectory + "/MatchboxButtontb_from_seed.png"
        @cmd3.status_bar_text = @cmd3.tooltip = @@title3
        @cmd3.menu_text = @@title3
        @matchboxToolbar.add_item(@cmd3)
        matchbox_menu.add_item(@cmd3)

        @cmd4 = UI::Command.new(@@title4) {save()}
        @cmd4.small_icon = tempImgDirectory + "/MatchboxButtontb_save.png"
        @cmd4.large_icon = tempImgDirectory + "/MatchboxButtontb_save.png"
        @cmd4.status_bar_text = @cmd4.tooltip = @@title4
        @cmd4.menu_text = @@title4
        @matchboxToolbar.add_item(@cmd4)
        matchbox_menu.add_item(@cmd4)


        @matchboxToolbar.add_separator
        matchbox_menu.add_separator

        @cmd5 = UI::Command.new(@@title5) {undo()}
        @cmd5.small_icon = tempImgDirectory + "/MatchboxButtontb_undo.png"
        @cmd5.large_icon = tempImgDirectory + "/MatchboxButtontb_undo.png"
        @cmd5.status_bar_text = @cmd5.tooltip = @@title5
        @cmd5.menu_text = @@title5
        @matchboxToolbar.add_item(@cmd5)
        matchbox_menu.add_item(@cmd5)
        
        @matchboxToolbar.add_separator
        matchbox_menu.add_separator

        @cmd6 = UI::Command.new(@@title6) {volume()}
        @cmd6.small_icon = tempImgDirectory + "/MatchboxButtontb_volume.png"
        @cmd6.large_icon = tempImgDirectory + "/MatchboxButtontb_volume.png"
        @cmd6.status_bar_text = @cmd6.tooltip = @@title6
        @cmd6.menu_text = @@title6
        @matchboxToolbar.add_item(@cmd6)
        matchbox_menu.add_item(@cmd6)

        @cmd7 = UI::Command.new(@@title7) {tree()}
        @cmd7.small_icon = tempImgDirectory + "/MatchboxButtontb_tree.png"
        @cmd7.large_icon = tempImgDirectory + "/MatchboxButtontb_tree.png"
        @cmd7.status_bar_text = @cmd7.tooltip = @@title7
        @cmd7.menu_text = @@title7
        @matchboxToolbar.add_item(@cmd7)
        matchbox_menu.add_item(@cmd7)

        @cmd2.set_validation_proc {MF_GRAYED}
        @cmd5.set_validation_proc {MF_GRAYED}
        @cmd7.set_validation_proc {MF_GRAYED}
        @cmd6.set_validation_proc {MF_GRAYED}
        #@cmd3.set_validation_proc {MF_GRAYED}
        
        @matchboxToolbar.show
        
        @ev = []
    end 
    
    def randomize()
        @evo_num = 0 # evolution number
        
        @p = Population.new(@@population_size, @@genotype_length)
        @p.randomize()
        generate_population()
        @cmd2.set_validation_proc {MF_ENABLED}
        @cmd3.set_validation_proc {MF_ENABLED}
        @cmd6.set_validation_proc {MF_ENABLED}
        @matchboxToolbar.show
        
        model = Sketchup.active_model
        model.add_note('Initial seeds', 0.01, 0.05)
    end
    
    def generate_population()
        model = Sketchup.active_model
        model.entities.clear!
        @phenotype = Array.new(@@population_size)
        i = 0
        @p.[].each {|g| @phenotype[i] = Matchbox.new(g, i)
                    i = i + 1}
                    
        # clear selection
        selection = model.selection
        selection.clear
        
        #Sketchup.set_status_text('Please select seeds.')
    end
    
    def evolve()
        r = Array.new(@@population_size, 0)
        i = 0
        flag = 0
        
        model = Sketchup.active_model
        selection = model.selection
        @phenotype.each {|matchbox| if selection.contains? matchbox.group
                                      r[i] = 1
                                      flag = 1
                                    end
                                    i = i + 1}

        @ev.push(r)

        if flag == 0
            Sketchup.set_status_text('No seed selected.')
        else
            @evo_num = @evo_num + 1
            @p.evolve(r, @evo_num)
            #@p.[].each{|g|model.add_notes(g.x.to_s, 0.0, 0.0)}
            generate_population()
            
            selection.clear
            
            @cmd4.set_validation_proc {MF_ENABLED}
            @cmd7.set_validation_proc {MF_ENABLED}
            @matchboxToolbar.show
        end
        model.add_note('Evolution#_' + @evo_num.to_s, 0.05, 0.05)
        
    end
    
    def seed()
        ipb = Inputbox.new('Input iteration and seed #, or file name .txt')
        ipb.add('Iteration #:  ', nil)
        ipb.add('Seed #: [1-' + @@population_size.to_i.to_s + '] ', nil)
        ipb.add('File name:    ', nil)
        result = ipb.show
        begin
            if result[2] == ''
                f = IO.readlines(File.dirname(__FILE__) + '/debug_' + result[0] + '.txt')
                  if f
                      model = Sketchup.active_model
                      model.entities.clear!
                      
                      @p = Population.new(@@population_size, @@genotype_length)
                      
                      temp2 = Array.new()
                      f.each {|e| temp2.push(e.to_f)}
                      if result
                          index = result[1].to_f
                          if  index != 0
                              if index <= @@population_size && index > 0
                                  seed = Genotype.new(@@genotype_length)
                                  for i in 0...@@genotype_length
                                      seed.x.push(temp2[(index-1)*@@genotype_length + i])
                                  end
                                  seed.randomize_delta()
                                  @phenotype = []
                                  @phenotype.push(Matchbox.new(seed, 0))
                                  @cmd2.set_validation_proc {MF_GRAYED}
                                  @matchboxToolbar.show
                              end
                          else
                              for i in 0...@@population_size
                                  seed = Genotype.new(@@genotype_length)
                                  for j in 0...@@genotype_length
                                      seed.x.push(temp2[j+i*@@genotype_length])
                                  end
                                  seed.randomize_delta()
                                  @p.push(i, seed)
                              end
                              generate_population()
                          end
                          #@cmd2.set_validation_proc {MF_GRAYED}
                          #@matchboxToolbar.show
                      @cmd6.set_validation_proc {MF_ENABLED}
                      @matchboxToolbar.show
                      end
                  else
                      UI.messagebox('Error IGA_Error#_IGA4_1: Cannot find seed file')
                  end
            else
                f = IO.readlines(File.dirname(__FILE__) + '/' + result[2] + '.txt')
                  if f
                      model = Sketchup.active_model
                      model.entities.clear!
                      
                      @p = Population.new(@@population_size, @@genotype_length)
                      
                      temp2 = Array.new()
                      f.each {|e| temp2.push(e.to_f)}
                      seed = Genotype.new(@@genotype_length)
                      for j in 0...@@genotype_length
                          seed.x.push(temp2[j])
                      end
                      seed.randomize_delta()
                      @phenotype = []
                      @phenotype.push(Matchbox.new(seed, 0))
                      @cmd2.set_validation_proc {MF_GRAYED}
                      @cmd6.set_validation_proc {MF_ENABLED}
                      @matchboxToolbar.show
                  else
                      UI.messagebox('Error IGA_Error#_IGA4_1: Cannot find seed file')
                  end
            end
        rescue SystemCallError
            UI.messagebox($!)
        end
    end
    
    def save()
        ipb = Inputbox.new('Save')
        ipb.add('Seed #: [1-' + @@population_size.to_i.to_s + '] ', nil)
        ipb.add('Save as:      ', nil)
        result = ipb.show
        if result[1] != ''
            f = File.new(File.dirname(__FILE__) + '/'+ result[1] + '.txt', 'w')
            index = result[0].to_i
            if index == 0
                for i in 0...@@population_size
                    @p.[](i).x.each {|n| f.write(n.to_s + "\n")}
                end
            else
                @p.[](index-1).x.each {|n| f.write(n.to_s + "\n")}
            end
            f.close
        else
            UI.messagebox('File name not valid.')
        end
    end
    
    def undo()
        model = Sketchup.active_model
        model.entities.clear!
        
        if @evo_num != 0
            @evo_num = @evo_num - 1
            f = IO.readlines(File.dirname(__FILE__) + '/Genotype_list_' + @evo_num.to_s + '.txt')
            temp2 = Array.new()
            f.each {|e| temp2.push(e.to_f)}
            i = 0
            for i in 0...@@population_size
                seed = Genotype.new(@@genotype_length)
                for j in 0...@@genotype_length
                    seed.x.push(temp2[j+i*@@genotype_length])
                end
                seed.randomize_delta()
                @p.push(i, seed)
            end
            generate_population()
            if @evo_num == 0
                @cmd5.set_validation_proc {MF_GRAYED}
                @cmd7.set_validation_proc {MF_GRAYED}
                @matchboxToolbar.show
            end
        end
        
        @ev.slice!(-1)
    end
    
    def volume()
        begin
        aa = Analysis.new()
        @phenotype.each {|matchbox|  i = 1
        Sketchup.set_status_text('Calculating volumes of seed#'+ i.to_s + '...')
        volume = aa.cal_volume(matchbox.group.entities, i)
        #matchbox.group.description = volume.to_s + '_m3'
        UI.messagebox(volume.to_s + '_m3')
        i = i + 1}
        
        rescue SystemCallError
            UI.messagebox($!)
        end
    end
    
    def make_component(group)
        group.to_component
    end
    
    def tree()
        #@fev = File.new(File.dirname(__FILE__) + '/evolution_record.txt', 'w')
        model = Sketchup.active_model
        layers = model.layers
        status = layers.add "Evolution Tree"
        model.active_layer=layers[1]

        status = layers[0].visible=false
        status = layers[1].visible=true
        
        i = 0
        for r in @ev
           f = IO.readlines(File.dirname(__FILE__) + '/Genotype_list_' + i.to_s + '.txt')
           temp = Array.new()
           f.each {|e| temp.push(e.to_f)}
           j = 0

           for s in r
              if s > 0
                  seed = Genotype.new(@@genotype_length)
                  for k in 0...@@genotype_length
                      seed.x.push(temp[j*@@genotype_length + k])
                  end
                  seed.randomize_delta()
                  Matchbox.new(seed, i*4+j)
              end
           j = j + 1
           end
           i = i + 1
        end
    end
    #def analysis()
    #    model = Sketchup.active_model
    #    
    #    aa = Analysis.new()
    #    volume = aa.cal_volume(model.entities, 1)
    #    
    #    UI.messagebox(volume)
    #end
end
