=begin
InputBox.rb Copyright 2008 jim.foltz@gmail.com

The InputBox class makes it easy to create user input 
dialogs by providing a consistent interface to UI.inputbox for
text fields and drop-down selection fields.


Instantiate a new InputBox:
> ipb = InputBox.new "My InputBox", [false]

By default, InputBox will remember the values of the user after it closes, and
will use the new values if the dialog is openened again. Add a false parameter
during initialization to make the InputBox always use its own default values.

Use the add method to add prompts to the dialog. 

> ipb.add "Prompt 1"                           # empty text entry
> ipb.add "Prompt 2", 2.2                      # text entry with default value
> ipb.add "Prompt 3", "huh"
> ipb.add "Prompt 4", %w(One Two Three)        # dropdown, 3 choices. Default choice is index 0
> ipb.add "Prompt 5", %w(Four Five Six), "Six" # dropdown, 3 choices, "Six" is default
> ipb.add "Prompt 6", [10, 12, 14, 16]
> ipb.add "Prompt 7", [11, 13, 15, 17], 15

Call the show method to show the dialog, and get the input.
> vals = ipb.show

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=end


# User input box class.
#
class Inputbox
  def initialize(title = "", r = true)
    @title = title
    @prompts = []
    @choices = []
    @defaults = []
    @rem = r
  end
  def add_prompt(prompt, default = nil)
    @prompts << prompt
    @defaults << default
    @choices << nil
  end
  def add_dropdown(prompt, choices, default = nil)
    @prompts << prompt
    @choices << choices.join("|")
    if default.nil?
      @defaults << choices[0]
    else
      @defaults << default
    end
  end
  def add(*args)
    case args.length
    when 1
      add_prompt(args[0])
    when 2
      if args[1].is_a? Array
	add_dropdown(args[0], args[1])
      else
	add_prompt(args[0], args[1])
      end
    when 3
      add_dropdown(args[0], args[1], args[2])
    end
  end
  def show
    if @prompts.length < 1
      return UI.messagebox("Inputbox #{@title}: No prompts added.")
    end
    @values =  UI.inputbox( @prompts, @defaults, @choices, @title )
    if @rem
      @defaults = @values
    end
    @values
  end
  def [](i)
    @values[i]
  end
  def values
    @values
  end

end # class 

