# --------------------------------------------------------------------------------------------------
# Copyright 2008, Yi Ren@BlockM

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

# This code is aimed for 3d model generation using Ruby and Sketchup
# Online viewer and update codes will be implemented
# --------------------------------------------------------------------------------------------------

module Intersect

    def Intersect.xz(a, b, c, d, e = nil)
    # Find the intersect point of one xz line and the projection of an arbitrary line
    # a, b are points on the arbitrary line and c, d on the xz plane, e is the intersect point on xz plane
    if ((b.z-a.z)*(d.x-c.x) - (d.z-c.z)*(b.x-a.x)) == 0
        x = e.x
        y = a.y - (a.y-b.y)/(b.x-a.x) * (x-a.x)
        z = e.z
    else
        x = (c.z*d.x*(b.x-a.x) - a.z*b.x*(d.x-c.x) + a.x*b.z*(d.x-c.x) - c.x*d.z*(b.x-a.x)) / ((b.z-a.z)*(d.x-c.x) - (d.z-c.z)*(b.x-a.x))
        z = (b.z - a.z)/(b.x - a.x) * (x - a.x) + a.z
        y = a.y - (a.y-b.y)/(b.x-a.x) * (x-a.x)
    end
    pt = Geom::Point3d.new(x, y, z)
    return pt
    end
end 
